/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public abstract class UpgradeBase<T>
implements IUpgrade<T> {
    public UpgradeManager upgradeManager;
    public int dataHolderSlot;
    public Point openTabSize;

    public UpgradeBase(UpgradeManager manager, int dataHolderSlot, Point openTabSize) {
        this.upgradeManager = manager;
        this.dataHolderSlot = dataHolderSlot;
        this.openTabSize = openTabSize;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public int getDataHolderSlot() {
        return this.dataHolderSlot;
    }

    @Override
    public boolean isTabOpened() {
        return (Boolean)this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot).getOrDefault(ModDataComponents.TAB_OPEN, (Object)false);
    }

    public ItemStack getDataHolderStack() {
        return this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot);
    }

    @Override
    public Point getTabSize() {
        if (this.isTabOpened()) {
            UpgradeBase upgradeBase = this;
            if (upgradeBase instanceof IFilter) {
                IFilter filter = (IFilter)((Object)upgradeBase);
                int rowCount = (int)Math.ceil((double)filter.getFilterSlotCount() / 3.0);
                return new Point(this.openTabSize.x(), this.openTabSize.y() - 18 * (3 - rowCount));
            }
            return this.openTabSize;
        }
        return new Point(24, 24);
    }

    public void updateDataHolderUnchecked(Consumer<ItemStack> updater) {
        ItemStack dataHolderStack = this.getDataHolderStack().copy();
        if (dataHolderStack.isEmpty()) {
            return;
        }
        updater.accept(dataHolderStack);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public <D> void updateDataHolderUnchecked(DataComponentType<D> dataKey, D value) {
        ItemStack dataHolderStack = this.getDataHolderStack().copy();
        if (dataHolderStack.isEmpty()) {
            return;
        }
        dataHolderStack.set(dataKey, value);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public void setCooldown(int cooldown) {
        ItemStack dataHolderStack = this.getDataHolderStack().copy();
        dataHolderStack.set(ModDataComponents.COOLDOWN, (Object)cooldown);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public int getCooldown() {
        return (Integer)this.getDataHolderStack().getOrDefault(ModDataComponents.COOLDOWN, (Object)100);
    }

    public boolean hasCooldown() {
        return this.getDataHolderStack().has(ModDataComponents.COOLDOWN);
    }
}

