/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class FeedingUpgrade
extends UpgradeBase<FeedingUpgrade>
implements IFilter,
IEnable,
ITickableUpgrade {
    private static final int STILL_HUNGRY_COOLDOWN = 10;
    public ItemStackHandler filter;
    private final FeedingFilterSettings filterSettings;

    public FeedingUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter) {
        super(manager, dataHolderSlot, new Point(66, 103));
        this.filter = this.createFilter(filter);
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.filterSlotCount.get();
        this.filterSettings = new FeedingFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(activeSlotCount).filter(stack -> !stack.isEmpty()).toList(), this.getFilter(), manager.wrapper.getRegistriesAccess());
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getDataHolderStack().getOrDefault(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0)));
    }

    public FeedingFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean canEat(Player player, ItemStack stack) {
        return this.getFilterSettings().matchesFilter(player, stack) && !player.getCooldowns().isOnCooldown(stack);
    }

    @Override
    public void updateSettings() {
        this.filterSettings.updateSettings(this.getFilter());
    }

    @Override
    public int getFilterSlotCount() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.filterSlotCount.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new FeedingWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<Slot> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.filterSlotCount.get();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add((Slot)new FilterSlotItemHandler(this, this, (IItemHandler)this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                    @Override
                    public boolean mayPlace(ItemStack pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.mayPlace(pStack);
                    }
                });
            }
        }
        return slots;
    }

    private ItemStackHandler createFilter(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                FeedingUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), InventoryHelper.itemsToList(9, FeedingUpgrade.this.filter));
                FeedingUpgrade.this.getFilterSettings().updateFilter((List<ItemStack>)((BackpackContainerContents)FeedingUpgrade.this.getDataHolderStack().get(ModDataComponents.BACKPACK_CONTAINER)).getItems());
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.has(DataComponents.FOOD);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    public int getTickRate() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.feedingUpgradeSettings.tickRate.get();
    }

    @Override
    public void tick(@Nullable Player player, Level level, BlockPos pos, int currentTick) {
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        this.getUpgradeManager().getWrapper().loadAdditionally(0);
        if (this.feedPlayerAndGetHungry(player, level)) {
            this.setCooldown(10);
            return;
        }
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    private boolean feedPlayerAndGetHungry(Player player, Level level) {
        int hungerLevel = 20 - player.getFoodData().getFoodLevel();
        if (hungerLevel == 0 || level.isClientSide) {
            return false;
        }
        return this.tryFeedingFoodFromStorage(level, hungerLevel, player) && player.getFoodData().getFoodLevel() < 20;
    }

    private boolean tryFeedingFoodFromStorage(Level level, int hungerLevel, Player player) {
        ItemStackHandler storage = this.getUpgradeManager().getWrapper().getStorage();
        return InventoryHelper.iterateHandler(storage, (slot, stack) -> this.tryFeedingStack(level, hungerLevel, player, (Integer)slot, (ItemStack)stack, storage));
    }

    private boolean tryFeedingStack(Level level, int hungerLevel, Player player, Integer slot, ItemStack stack, ItemStackHandler backpackStorage) {
        if (FeedingUpgrade.isEdible(stack, (LivingEntity)player) && this.canEat(player, stack)) {
            ItemStack mainHandItem = player.getMainHandItem();
            player.getInventory().getNonEquipmentItems().set(player.getInventory().getSelectedSlot(), (Object)stack);
            ItemStack singleItemCopy = stack.copy();
            singleItemCopy.setCount(1);
            if (singleItemCopy.use(level, player, InteractionHand.MAIN_HAND) == InteractionResult.CONSUME) {
                ItemStack insertResult;
                player.getInventory().getNonEquipmentItems().set(player.getInventory().getSelectedSlot(), (Object)mainHandItem);
                stack.shrink(1);
                backpackStorage.setStackInSlot(slot.intValue(), stack);
                ItemStack resultItem = EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)singleItemCopy, (int)0, (ItemStack)singleItemCopy.getItem().finishUsingItem(singleItemCopy, level, (LivingEntity)player));
                if (!resultItem.isEmpty() && !(insertResult = InventoryHelper.addItemStackToHandler(new StorageAccessWrapper(this.getUpgradeManager().getWrapper(), backpackStorage), resultItem, false)).isEmpty()) {
                    player.drop(insertResult, true);
                }
                return true;
            }
            player.getInventory().getNonEquipmentItems().set(player.getInventory().getSelectedSlot(), (Object)mainHandItem);
        }
        return false;
    }

    private static boolean isEdible(ItemStack stack, LivingEntity player) {
        if (!stack.has(DataComponents.FOOD)) {
            return false;
        }
        FoodProperties foodProperties = (FoodProperties)stack.get(DataComponents.FOOD);
        return foodProperties != null && foodProperties.nutrition() >= 1;
    }
}

