/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.jukebox;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class JukeboxWidget
extends UpgradeWidgetBase<JukeboxUpgrade> {
    private final WidgetElement playButton = new WidgetElement(new Point(24, 22), new Point(18, 18));
    private final WidgetElement stopButton = new WidgetElement(new Point(42, 22), new Point(18, 18));

    public JukeboxWidget(BackpackScreen screen, JukeboxUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 103), "screen.travelersbackpack.jukebox_upgrade");
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isTabOpened()) {
            if (this.isMouseOverPlayButton(mouseX, mouseY)) {
                guiGraphics.blit(RenderType::guiTextured, BackpackScreen.ICONS, this.pos.x() + this.playButton.pos().x(), this.pos.y() + this.playButton.pos().y(), 24.0f, 18.0f, this.playButton.size().x(), this.playButton.size().y(), 256, 256);
            }
            if (this.isMouseOverStopButton(mouseX, mouseY)) {
                guiGraphics.blit(RenderType::guiTextured, BackpackScreen.ICONS, this.pos.x() + this.stopButton.pos().x(), this.pos.y() + this.stopButton.pos().y(), 24.0f, 18.0f, this.stopButton.size().x(), this.stopButton.size().y(), 256, 256);
            }
        }
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        if (this.isTabOpened() && ((JukeboxUpgrade)this.upgrade).isPlayingRecord()) {
            guiGraphics.blit(RenderType::guiTextured, BackpackScreen.ICONS, this.pos.x() + 6, this.pos.y() + 22, 24.0f, 36.0f, 18, 18, 256, 256);
        }
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (((JukeboxUpgrade)this.upgrade).getUpgradeManager().getWrapper().getScreenID() == 2 && this.isMouseOverPlayButton(pMouseX, pMouseY) && this.isBackpackOwner() && this.isTabOpened() && ((JukeboxUpgrade)this.upgrade).canPlayRecord()) {
            ServerboundActionTagPacket.create(0, this.dataHolderSlot, true, 3);
            this.playDiscToPlayer(((BackpackBaseMenu)((BackpackScreen)this.screen).getMenu()).getPlayerInventory().player.getId(), this.getFromDisk(((JukeboxUpgrade)this.upgrade).diskHandler.getStackInSlot(0)));
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isMouseOverStopButton(pMouseX, pMouseY) && this.isBackpackOwner() && this.isTabOpened() && ((JukeboxUpgrade)this.upgrade).isPlayingRecord()) {
            ServerboundActionTagPacket.create(0, this.dataHolderSlot, false, 3);
            if (((JukeboxUpgrade)this.upgrade).getUpgradeManager().getWrapper().getScreenID() == 2) {
                this.stopDisc(this.getFromDisk(((JukeboxUpgrade)this.upgrade).diskHandler.getStackInSlot(0)));
            }
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean isMouseOverPlayButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.playButton);
    }

    public boolean isMouseOverStopButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.stopButton);
    }

    @Nullable
    public JukeboxSong getFromDisk(ItemStack stack) {
        if (stack.has(DataComponents.JUKEBOX_PLAYABLE)) {
            return (JukeboxSong)((Holder)JukeboxSong.fromStack((HolderLookup.Provider)((BackpackBaseMenu)((BackpackScreen)this.screen).getMenu()).getPlayerInventory().player.registryAccess(), (ItemStack)stack).get()).value();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playDiscToPlayer(int entityId, @Nullable JukeboxSong jukeboxSong) {
        if (jukeboxSong == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(entityId);
        if (entity == null) {
            return;
        }
        Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)new MovingSound(entity, (SoundEvent)jukeboxSong.soundEvent().value()));
        Minecraft.getInstance().gui.setNowPlaying(jukeboxSong.description());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopDisc(JukeboxSong jukeboxSong) {
        if (jukeboxSong == null) {
            return;
        }
        Minecraft.getInstance().getSoundManager().stop(((SoundEvent)jukeboxSong.soundEvent().value()).location(), SoundSource.NEUTRAL);
    }

    public static class MovingSound
    extends AbstractTickableSoundInstance {
        private final Entity entity;

        public MovingSound(Entity entityIn, SoundEvent soundIn) {
            super(soundIn, SoundSource.NEUTRAL, entityIn.level().getRandom());
            this.entity = entityIn;
            this.looping = false;
            this.delay = 0;
            this.volume = 1.0f;
        }

        public void tick() {
            Player player;
            Entity entity = this.entity;
            if (!(!(entity instanceof Player) || AttachmentUtils.isWearingBackpack(player = (Player)entity) && this.shouldStopPlaying(player))) {
                this.stop();
            }
            if (!this.entity.isAlive()) {
                this.stop();
            } else {
                this.x = (float)this.entity.getX();
                this.y = (float)this.entity.getY();
                this.z = (float)this.entity.getZ();
            }
        }

        public boolean shouldStopPlaying(Player player) {
            return AttachmentUtils.getBackpackWrapper(player, AttachmentUtils.UPGRADES_ONLY).getUpgradeManager().getUpgrade(JukeboxUpgrade.class).isPresent();
        }
    }
}

