/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.smelting;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.IMoveSelector;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.smelting.AbstractSmeltingWidget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractSmeltingUpgrade<T>
extends UpgradeBase<T>
implements IEnable,
ITickableUpgrade,
IMoveSelector {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    private final Level level;
    protected ItemStackHandler items;
    private RecipeHolder<? extends AbstractCookingRecipe> cachedRecipe = null;
    private boolean recipeFetched = false;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;
    private final String upgradeName;

    public AbstractSmeltingUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> furnaceContents, RecipeType<? extends AbstractCookingRecipe> recipeType, String upgradeName) {
        super(manager, dataHolderSlot, new Point(66, 82));
        this.level = manager.getWrapper().getLevel();
        this.items = this.createHandler(furnaceContents);
        this.recipeType = recipeType;
        this.quickCheck = RecipeManager.createCheck(this.recipeType);
        this.upgradeName = upgradeName;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new AbstractSmeltingWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), "screen.travelersbackpack." + this.upgradeName);
    }

    @Override
    public void onUpgradeRemoved(ItemStack removedStack) {
        removedStack.remove(ModDataComponents.COOKING_TOTAL_TIME);
        removedStack.remove(ModDataComponents.COOKING_FINISH_TIME);
        removedStack.remove(ModDataComponents.BURN_TOTAL_TIME);
        removedStack.remove(ModDataComponents.BURN_FINISH_TIME);
    }

    @Override
    public List<Slot> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        slots.add((Slot)new UpgradeSlotItemHandler<AbstractSmeltingUpgrade>(this, (IItemHandler)this.items, 0, x + 7, y + 23));
        slots.add((Slot)new UpgradeSlotItemHandler<AbstractSmeltingUpgrade>(this, (IItemHandler)this.items, 1, x + 7, y + 23 + 36));
        slots.add((Slot)new UpgradeSlotItemHandler<AbstractSmeltingUpgrade>(this, (IItemHandler)this.items, 2, x + 7 + 18 + 18, y + 23 + 18));
        return slots;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.stopCooking();
            this.stopBurning();
        } else {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.checkCooking(serverLevel, false);
            }
        }
    }

    @Override
    public void tick(@Nullable Player player, Level level, BlockPos pos, int currentTick) {
        Level level2;
        if (level.isClientSide || !this.isEnabled(this)) {
            return;
        }
        long currentTime = level.getGameTime();
        if (this.isBurning()) {
            if (this.isCooking() && currentTime >= this.getCookingFinishTime()) {
                this.finishCooking();
            }
            if (currentTime >= this.getBurnFinishTime()) {
                this.finishBurning();
            }
        }
        if (player != null && player.containerMenu instanceof BackpackBaseMenu && (level2 = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            this.tickSmelting(serverLevel);
        }
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    @Override
    public int getTickRate() {
        return 5;
    }

    public boolean isFuel(ItemStack pStack) {
        return this.getBurnDuration(pStack) > 0;
    }

    public boolean isBurning() {
        return this.getBurnFinishTime() > 0L;
    }

    public boolean isCooking() {
        return this.getCookingFinishTime() > 0L;
    }

    public boolean hasFuel() {
        return !this.getStack(1).isEmpty() && this.isFuel(this.getStack(1)) || this.isBurning();
    }

    public void tickSmelting(ServerLevel level) {
        if (!this.recipeFetched && this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(this.getStack(0)), level).orElse(null);
            this.recipeFetched = true;
        }
        boolean shouldStop = false;
        if (this.isCooking() && this.isBurning()) {
            if (this.cachedRecipe != null) {
                RecipeHolder currentRecipe = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(this.getStack(0)), level).orElse(null);
                if (this.cachedRecipe != currentRecipe) {
                    this.cachedRecipe = currentRecipe;
                    shouldStop = true;
                }
            } else {
                shouldStop = true;
            }
        }
        if (shouldStop) {
            this.stopCooking();
            this.checkCooking(level, false);
        }
    }

    public void checkCooking(ServerLevel level, boolean force) {
        if (level.isClientSide || !this.isEnabled(this)) {
            return;
        }
        if (this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(this.getStack(0)), level).orElse(null);
        }
        if ((force || !this.isCooking()) && this.canBurn(this.cachedRecipe)) {
            if (!this.isBurning()) {
                this.startBurning();
            }
            this.startCooking((AbstractCookingRecipe)this.cachedRecipe.value());
        }
    }

    public void startCooking(AbstractCookingRecipe recipe) {
        int cookingDuration = recipe.cookingTime();
        this.setCookingFinishTime(this.level.getGameTime() + (long)cookingDuration);
        this.setCookingTotalTime(cookingDuration);
    }

    public void startBurning() {
        int litDuration = this.getBurnDuration(this.getStack(1));
        this.setBurnFinishTime(this.level.getGameTime() + (long)litDuration);
        this.setBurnTotalTime(litDuration);
        this.shrinkFuelSlot();
    }

    private boolean canBurn(@Nullable RecipeHolder<? extends AbstractCookingRecipe> recipe) {
        if (!this.getStack(0).isEmpty() && recipe != null && this.hasFuel()) {
            ItemStack cookingResult = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(this.getStack(0)), (HolderLookup.Provider)this.level.registryAccess());
            if (cookingResult.isEmpty()) {
                return false;
            }
            ItemStack resultSlotStack = this.getStack(2);
            if (resultSlotStack.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)resultSlotStack, (ItemStack)cookingResult)) {
                return false;
            }
            if (resultSlotStack.getCount() + cookingResult.getCount() <= this.items.getSlotLimit(2) && resultSlotStack.getCount() + cookingResult.getCount() <= resultSlotStack.getMaxStackSize()) {
                return true;
            }
            return resultSlotStack.getCount() + cookingResult.getCount() <= cookingResult.getMaxStackSize();
        }
        return false;
    }

    public void finishCooking() {
        ServerLevel serverLevel;
        Level level;
        if (this.cachedRecipe == null && (level = this.level) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            this.cachedRecipe = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(this.getStack(0)), serverLevel).orElse(null);
        }
        if (this.cachedRecipe != null) {
            ItemStack result = ((AbstractCookingRecipe)this.cachedRecipe.value()).assemble(new SingleRecipeInput(this.getStack(0)), (HolderLookup.Provider)this.level.registryAccess());
            ItemStack input = this.getStack(0).copy();
            ItemStack resultSlot = this.getStack(2).copy();
            if (!resultSlot.isEmpty()) {
                resultSlot.grow(1);
            } else {
                resultSlot = result;
            }
            if (input.is(Blocks.WET_SPONGE.asItem()) && !this.getStack(1).isEmpty() && this.getStack(1).is(Items.BUCKET)) {
                this.setStack(1, new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            input.shrink(1);
            this.setStack(0, input);
            this.setStack(2, resultSlot);
        }
        if (this.canBurn(this.cachedRecipe) && (level = this.level) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            this.checkCooking(serverLevel, true);
        } else {
            this.stopCooking();
        }
    }

    public void shrinkFuelSlot() {
        ItemStack fuel = this.getStack(1).copy();
        if (!fuel.getCraftingRemainder().isEmpty()) {
            this.setStack(1, fuel.getCraftingRemainder());
        } else {
            fuel.shrink(1);
            this.setStack(1, fuel);
        }
    }

    public void finishBurning() {
        ItemStack fuel = this.getStack(1).copy();
        if (this.isFuel(fuel) && this.isCooking()) {
            this.startBurning();
        } else {
            this.stopCooking();
            this.stopBurning();
            this.cachedRecipe = null;
        }
    }

    public void setStack(int slot, ItemStack stack) {
        this.items.setStackInSlot(slot, stack);
    }

    public ItemStack getStack(int slot) {
        return this.items.getStackInSlot(slot);
    }

    protected int getBurnDuration(ItemStack pFuel) {
        if (pFuel.isEmpty() || this.level == null) {
            return 0;
        }
        return pFuel.getBurnTime(this.recipeType, this.level.fuelValues());
    }

    public int getBurnTotalTime() {
        return (Integer)this.getDataHolderStack().getOrDefault(ModDataComponents.BURN_TOTAL_TIME, (Object)0);
    }

    public long getBurnFinishTime() {
        return (Long)this.getDataHolderStack().getOrDefault(ModDataComponents.BURN_FINISH_TIME, (Object)0L);
    }

    public int getCookingTotalTime() {
        return (Integer)this.getDataHolderStack().getOrDefault(ModDataComponents.COOKING_TOTAL_TIME, (Object)0);
    }

    public long getCookingFinishTime() {
        return (Long)this.getDataHolderStack().getOrDefault(ModDataComponents.COOKING_FINISH_TIME, (Object)0L);
    }

    public void setBurnTotalTime(int time) {
        this.setStackData((DataComponentType)ModDataComponents.BURN_TOTAL_TIME.get(), time);
    }

    public void setBurnFinishTime(long time) {
        this.setStackData((DataComponentType)ModDataComponents.BURN_FINISH_TIME.get(), time);
    }

    public void setCookingTotalTime(int time) {
        this.setStackData((DataComponentType)ModDataComponents.COOKING_TOTAL_TIME.get(), time);
    }

    public void setCookingFinishTime(long time) {
        this.setStackData((DataComponentType)ModDataComponents.COOKING_FINISH_TIME.get(), time);
    }

    public void stopCooking() {
        this.setCookingFinishTime(0L);
        this.setCookingTotalTime(0);
    }

    public void stopBurning() {
        this.setBurnFinishTime(0L);
        this.setBurnTotalTime(0);
    }

    public void setSlotChanged(ItemStack dataHolderStack, int index, ItemStack stack) {
        dataHolderStack.update(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(3), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
    }

    public <D> void setStackData(DataComponentType<D> data, D value) {
        ItemStack stack = this.getDataHolderStack().copy();
        if (value == null) {
            stack.remove(data);
        } else {
            stack.set(data, value);
        }
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), stack);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                Level level;
                AbstractSmeltingUpgrade.this.updateDataHolderUnchecked(dataHolderStack -> AbstractSmeltingUpgrade.this.setSlotChanged((ItemStack)dataHolderStack, slot, this.getStackInSlot(slot)));
                if (AbstractSmeltingUpgrade.this.getUpgradeManager().getWrapper().getScreenID() == 2 && (level = AbstractSmeltingUpgrade.this.level) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    AbstractSmeltingUpgrade.this.checkCooking(serverLevel, false);
                }
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return BackpackSlotItemHandler.isItemValid(stack);
                }
                if (slot == 1) {
                    ItemStack fuel = AbstractSmeltingUpgrade.this.getStack(1);
                    return AbstractSmeltingUpgrade.this.getBurnDuration(stack) > 0 || stack.is(Items.BUCKET) && !fuel.is(Items.BUCKET);
                }
                return false;
            }

            protected int getStackLimit(int slot, @NotNull ItemStack stack) {
                if (slot == 1 && stack.is(Items.BUCKET)) {
                    return 1;
                }
                return super.getStackLimit(slot, stack);
            }
        };
    }
}

