/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import java.util.Optional;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.function.TriFunction;

public class PickupUpgradeItem
extends UpgradeItem {
    public PickupUpgradeItem(Item.Properties pProperties) {
        super(pProperties, "pickup_upgrade");
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        if (TravelersBackpackConfig.serverSpec.isLoaded()) {
            return (Boolean)TravelersBackpackConfig.SERVER.backpackUpgrades.pickupUpgradeSettings.enableUpgrade.get() != false && super.isEnabled(enabledFeatures);
        }
        return super.isEnabled(enabledFeatures);
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return AutoPickupUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, ItemStack, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents filter = (BackpackContainerContents)provider.getOrDefault(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(9));
            return Optional.of(new AutoPickupUpgrade((UpgradeManager)upgradeManager, (int)dataHolderSlot, filter.getItems()));
        };
    }
}

