/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items.upgrades;

import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.function.TriFunction;

public class TanksUpgradeItem
extends UpgradeItem {
    public TanksUpgradeItem(Item.Properties pProperties) {
        super(pProperties.component(ModDataComponents.FLUIDS, (Object)Fluids.empty()), "tanks_upgrade");
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        if (TravelersBackpackConfig.serverSpec.isLoaded()) {
            return (Boolean)TravelersBackpackConfig.SERVER.backpackUpgrades.enableTanksUpgrade.get() != false && super.isEnabled(enabledFeatures);
        }
        return super.isEnabled(enabledFeatures);
    }

    public static boolean canBePutInBackpack(int backpackFluidStorageSize, ItemStack tanksUpgrade) {
        int[] fluidTanks = new int[]{0, 0};
        if (tanksUpgrade.has(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks2 = (Fluids)tanksUpgrade.get(ModDataComponents.FLUIDS);
            fluidTanks[0] = fluidTanks2.leftFluidStack().getAmount();
            fluidTanks[1] = fluidTanks2.rightFluidStack().getAmount();
        }
        return backpackFluidStorageSize >= fluidTanks[0] && backpackFluidStorageSize >= fluidTanks[1];
    }

    public static FluidStack getLeftFluidStack(ItemStack tanksUpgrade) {
        if (tanksUpgrade.has(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks2 = (Fluids)tanksUpgrade.get(ModDataComponents.FLUIDS);
            return fluidTanks2.leftFluidStack();
        }
        return FluidStack.EMPTY;
    }

    public static FluidStack getRightFluidStack(ItemStack tanksUpgrade) {
        if (tanksUpgrade.has(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks2 = (Fluids)tanksUpgrade.get(ModDataComponents.FLUIDS);
            return fluidTanks2.rightFluidStack();
        }
        return FluidStack.EMPTY;
    }

    public static RenderInfo writeToRenderData() {
        CompoundTag tag = new CompoundTag();
        tag.put("LeftTank", (Tag)new CompoundTag());
        tag.put("RightTank", (Tag)new CompoundTag());
        return new RenderInfo(tag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipDisplay, componentConsumer, tooltipFlag);
        if (stack.has(ModDataComponents.FLUIDS)) {
            Fluids fluidTanks = (Fluids)stack.get(ModDataComponents.FLUIDS);
            FluidStack leftFluidStack = fluidTanks.leftFluidStack();
            FluidStack rightFluidStack = fluidTanks.rightFluidStack();
            if (!leftFluidStack.isEmpty()) {
                componentConsumer.accept((Component)Component.literal((String)(leftFluidStack.getHoverName().getString() + ": " + leftFluidStack.getAmount() + "mB")).withStyle(ChatFormatting.BLUE));
            }
            if (!rightFluidStack.isEmpty()) {
                componentConsumer.accept((Component)Component.literal((String)(rightFluidStack.getHoverName().getString() + ": " + rightFluidStack.getAmount() + "mB")).withStyle(ChatFormatting.BLUE));
            }
        }
    }

    @Override
    public boolean requiresEquippedBackpack() {
        return false;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return TanksUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, ItemStack, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            Fluids fluids = (Fluids)provider.getOrDefault(ModDataComponents.FLUIDS, (Object)new Fluids(FluidStack.EMPTY, FluidStack.EMPTY));
            return Optional.of(new TanksUpgrade((UpgradeManager)upgradeManager, (int)dataHolderSlot, fluids));
        };
    }
}

