/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SleepingBagBlock
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    public static final BooleanProperty CAN_DROP = BlockStateProperties.CONDITIONAL;
    protected static final VoxelShape SLEEPING_BAG = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SLEEPING_BAG_NORTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)2.5, (double)8.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape SLEEPING_BAG_EAST = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)8.0, (double)2.0, (double)0.0, (double)16.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape SLEEPING_BAG_SOUTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)2.0, (double)8.0, (double)16.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape SLEEPING_BAG_WEST = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)2.0, (double)0.0, (double)8.0, (double)2.5, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public SleepingBagBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(color, properties.forceSolidOn());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.FALSE)).setValue((Property)CAN_DROP, (Comparable)Boolean.TRUE));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((BedPart)state.getValue(PART)) {
            default -> throw new MatchException(null, null);
            case BedPart.FOOT -> SLEEPING_BAG;
            case BedPart.HEAD -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case EAST: {
                        yield SLEEPING_BAG_EAST;
                    }
                    case SOUTH: {
                        yield SLEEPING_BAG_SOUTH;
                    }
                    case WEST: {
                        yield SLEEPING_BAG_WEST;
                    }
                }
                yield SLEEPING_BAG_NORTH;
            }
        };
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (pState.getValue(PART) != BedPart.HEAD && !(pState = pLevel.getBlockState(pPos = pPos.relative((Direction)pState.getValue((Property)FACING)))).is((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!SleepingBagBlock.canSetSpawn((Level)pLevel)) {
            BlockEntity blockEntity;
            pLevel.removeBlock(pPos, false);
            BlockPos blockpos = pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite());
            if (pLevel.getBlockState(blockpos).is((Block)this)) {
                pLevel.removeBlock(blockpos, false);
            }
            if ((blockEntity = pLevel.getBlockEntity(pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite(), pState.getValue(PART) == BedPart.FOOT ? 1 : 2))) instanceof BackpackBlockEntity) {
                BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
                blockEntity2.setSleepingBagDeployed(false);
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)pState.getValue((Property)OCCUPIED)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(pLevel, pPos)) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.enableSleepingBagSpawnPoint.get()).booleanValue() && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            serverPlayer.setRespawnPosition(new ServerPlayer.RespawnConfig(pLevel.dimension(), pPos, serverPlayer.getYRot(), true), true);
        }
        pPlayer.startSleepInBed(pPos).ifLeft(p_49477_ -> {
            if (p_49477_.getMessage() != null) {
                pPlayer.displayClientMessage(p_49477_.getMessage(), true);
            }
        });
        return InteractionResult.SUCCESS;
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List var3 = level.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (var3.isEmpty()) {
            return false;
        }
        ((Villager)var3.get(0)).stopSleeping();
        return true;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, double factor) {
        super.fallOn(level, state, pos, entity, factor * 0.75);
    }

    public void updateEntityMovementAfterFallOn(BlockGetter getter, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(getter, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 var2 = entity.getDeltaMovement();
        if (var2.y < 0.0) {
            double var3 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(var2.x, -var2.y * 0.3300000262260437 * var3, var2.z);
        }
    }

    protected BlockState updateShape(BlockState state, LevelReader reader, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos newPos, BlockState newState, RandomSource randomSource) {
        if (direction == SleepingBagBlock.getNeighbourDirection((BedPart)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            return newState.is((Block)this) && newState.getValue(PART) != state.getValue(PART) ? (BlockState)state.setValue((Property)OCCUPIED, (Comparable)((Boolean)newState.getValue((Property)OCCUPIED))) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, reader, tickAccess, pos, direction, newPos, newState, randomSource);
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        boolean isFoot = state.getValue(PART) == BedPart.FOOT;
        BlockPos backpackPos = isFoot ? pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()) : pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite(), 2);
        BlockEntity blockEntity = level.getBlockEntity(backpackPos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
            blockEntity2.setSleepingBagDeployed(false);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos blockpos = context.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        return context.getLevel().getBlockState(blockpos1).canBeReplaced(context) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, OCCUPIED, CAN_DROP});
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemstack) {
        super.setPlacedBy(level, pos, state, livingEntity, itemstack);
        if (!level.isClientSide) {
            BlockPos var6 = pos.relative((Direction)state.getValue((Property)FACING));
            level.setBlock(var6, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
            level.updateNeighborsAt(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    public long getSeed(BlockState state, BlockPos pos) {
        BlockPos var3 = pos.relative((Direction)state.getValue((Property)FACING), state.getValue(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.getSeed((int)var3.getX(), (int)pos.getY(), (int)var3.getZ());
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        if (!((Boolean)pState.getValue((Property)CAN_DROP)).booleanValue()) {
            return List.of();
        }
        return super.getDrops(pState, pParams);
    }

    public BlockEntity newBlockEntity(BlockPos p_152175_, BlockState p_152176_) {
        return null;
    }
}

