/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.DynamicBlockStateModel;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.model.data.ModelData;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BackpackDynamicModel
implements UnbakedModel {
    private final Map<ModelParts, UnbakedModel> modelParts;
    private final RenderTypeGroup renderTypeGroup;

    private BackpackDynamicModel(Map<ModelParts, UnbakedModel> modelParts, RenderTypeGroup renderTypeGroup) {
        this.modelParts = modelParts;
        this.renderTypeGroup = renderTypeGroup;
    }

    public BlockStateModel bakeBlockStateModel(ModelBaker baker, ResolvedModel resolvedModel, ModelState modelState) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.modelParts.forEach((part, model) -> builder.put((Object)part, (Object)baker.getModel(model.parent()).getTopGeometry().bake(this.getTextureSlots(baker, (UnbakedModel)model, (ModelDebugName)resolvedModel), baker, modelState, (ModelDebugName)resolvedModel, ContextMap.EMPTY)));
        return new BlockStateModel((Map<ModelParts, QuadCollection>)builder.build(), modelState, resolvedModel.resolveParticleSprite(this.getTextureSlots(baker, this.modelParts.get((Object)ModelParts.BASE), (ModelDebugName)resolvedModel), baker), this.renderTypeGroup.block());
    }

    private TextureSlots getTextureSlots(ModelBaker baker, UnbakedModel partModel, ModelDebugName debugName) {
        TextureSlots.Resolver resolver = new TextureSlots.Resolver();
        resolver.addLast(partModel.textureSlots());
        ResourceLocation parent = partModel.parent();
        if (parent != null) {
            for (ResolvedModel resolvedParent = baker.getModel(parent); resolvedParent != null; resolvedParent = resolvedParent.parent()) {
                resolver.addLast(resolvedParent.wrapped().textureSlots());
            }
        }
        return resolver.resolve(debugName);
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        this.modelParts.values().forEach(model -> {
            ResourceLocation parent = model.parent();
            if (parent != null) {
                resolver.markDependency(parent);
            }
            model.resolveDependencies(resolver);
        });
    }

    public void fillAdditionalProperties(ContextMap.Builder propertiesBuilder) {
        NeoForgeModelProperties.fillRenderTypeProperty((ContextMap.Builder)propertiesBuilder, (RenderTypeGroup)this.renderTypeGroup);
    }

    public static final class BlockStateModel
    implements DynamicBlockStateModel {
        private final Map<ModelParts, QuadCollection> models;
        private final ModelState modelTransform;
        private final TextureAtlasSprite particleIcon;
        private final ChunkSectionLayer chunkSectionLayer;
        public boolean isDyed;
        public boolean isSleepingBagDeployed;
        public int sleepingBagColor;
        public RenderInfo renderInfo;
        public Block block;

        public BlockStateModel(Map<ModelParts, QuadCollection> models, ModelState modelTransform, TextureAtlasSprite particleIcon, ChunkSectionLayer chunkSectionLayer) {
            this.models = models;
            this.modelTransform = modelTransform;
            this.particleIcon = particleIcon;
            this.chunkSectionLayer = chunkSectionLayer;
        }

        public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
            ModelData extraData = level.getModelData(pos);
            if (state != null) {
                this.block = state.getBlock();
                this.isDyed = extraData.has(BackpackBlockEntity.DYE_COLOR);
                this.renderInfo = extraData.has(BackpackBlockEntity.RENDER_INFO) ? (RenderInfo)extraData.get(BackpackBlockEntity.RENDER_INFO) : RenderInfo.EMPTY;
                this.sleepingBagColor = extraData.has(BackpackBlockEntity.SLEEPING_BAG_COLOR) ? ((Integer)extraData.get(BackpackBlockEntity.SLEEPING_BAG_COLOR)).intValue() : DyeColor.RED.getId();
                this.isSleepingBagDeployed = extraData.has(BackpackBlockEntity.SLEEPING_BAG_DEPLOYED) ? (Boolean)extraData.get(BackpackBlockEntity.SLEEPING_BAG_DEPLOYED) : false;
            }
            this.collectParts(parts);
        }

        private void collectParts(List<BlockModelPart> parts) {
            QuadCollection.Builder builder = new QuadCollection.Builder();
            this.addBaseBackpack(builder);
            this.addTanks(builder);
            this.addSleepingBag(builder);
            this.addExtras(builder);
            parts.add((BlockModelPart)new SimpleModelWrapper(builder.build(), true, this.particleIcon, this.chunkSectionLayer));
        }

        public void addBaseBackpack(QuadCollection.Builder builder) {
            if (this.isDyed && this.block == ModBlocks.STANDARD_TRAVELERS_BACKPACK.get()) {
                builder.addAll(this.models.get((Object)ModelParts.BASE_DYED));
                builder.addAll(this.models.get((Object)ModelParts.EXTRAS));
            } else {
                builder.addAll(this.models.get((Object)ModelParts.BASE));
            }
        }

        public TextureAtlasSprite particleIcon() {
            return this.particleIcon;
        }

        public List<BakedQuad> getQuads() {
            ArrayList<BlockModelPart> parts = new ArrayList<BlockModelPart>();
            this.collectParts(parts);
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
            for (BlockModelPart part : parts) {
                for (Direction dir : Direction.values()) {
                    bakedQuads.addAll(part.getQuads(dir));
                }
                bakedQuads.addAll(part.getQuads(null));
            }
            return bakedQuads;
        }

        private void addFluids(QuadCollection.Builder builder, RenderInfo renderInfo) {
            if (renderInfo != null && !renderInfo.isEmpty()) {
                if (!renderInfo.getLeftFluidStack().isEmpty()) {
                    this.addFluid(builder, renderInfo.getLeftFluidStack(), (float)renderInfo.getLeftFluidStack().getAmount() / (float)renderInfo.getCapacity(), 0.1125f);
                }
                if (!renderInfo.getRightFluidStack().isEmpty()) {
                    this.addFluid(builder, renderInfo.getRightFluidStack(), (float)renderInfo.getRightFluidStack().getAmount() / (float)renderInfo.getCapacity(), 0.79375f);
                }
            }
        }

        private void addSleepingBag(QuadCollection.Builder builder) {
            if (this.isSleepingBagDeployed) {
                return;
            }
            builder.addAll(this.models.get((Object)ModelParts.SLEEPING_BAG_EXTRAS));
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)("block/bag/" + DyeColor.byId((int)this.sleepingBagColor).getName().toLowerCase(Locale.ENGLISH) + "_sleeping_bag")));
            this.rebakeSleepingBag(builder, sprite);
        }

        private void rebakeSleepingBag(QuadCollection.Builder builder, TextureAtlasSprite sprite) {
            this.models.get((Object)ModelParts.SLEEPING_BAG).getAll().forEach(quad -> {
                TextureAtlasSprite oldSprite = quad.sprite();
                int[] oldData = quad.vertices();
                int[] newData = Arrays.copyOf(oldData, oldData.length);
                for (int i = 0; i < 4; ++i) {
                    int index = i * 8;
                    float oldU = Float.intBitsToFloat(oldData[index + 4]);
                    float oldV = Float.intBitsToFloat(oldData[index + 5]);
                    float uUn = oldSprite.getUOffset(oldU);
                    float vUn = oldSprite.getVOffset(oldV);
                    float newU = sprite.getU(uUn);
                    float newV = sprite.getV(vUn);
                    newData[index + 4] = Float.floatToRawIntBits(newU);
                    newData[index + 5] = Float.floatToRawIntBits(newV);
                    builder.addUnculledFace(new BakedQuad(newData, quad.tintIndex(), quad.direction(), sprite, quad.shade(), quad.lightEmission()));
                }
            });
        }

        private void addExtras(QuadCollection.Builder builder) {
            if (this.block == ModBlocks.FOX_TRAVELERS_BACKPACK.get()) {
                builder.addAll(this.models.get((Object)ModelParts.FOX_NOSE));
            }
            if (this.block == ModBlocks.WARDEN_TRAVELERS_BACKPACK.get()) {
                builder.addAll(this.models.get((Object)ModelParts.WARDEN_HORNS));
            }
            if (this.block == ModBlocks.WOLF_TRAVELERS_BACKPACK.get()) {
                builder.addAll(this.models.get((Object)ModelParts.WOLF_NOSE));
            }
            if (this.block == ModBlocks.OCELOT_TRAVELERS_BACKPACK.get()) {
                builder.addAll(this.models.get((Object)ModelParts.OCELOT_NOSE));
            }
            if (this.block == ModBlocks.PIG_TRAVELERS_BACKPACK.get() || this.block == ModBlocks.HORSE_TRAVELERS_BACKPACK.get()) {
                builder.addAll(this.models.get((Object)ModelParts.PIG_NOSE));
            }
            if (this.block == ModBlocks.VILLAGER_TRAVELERS_BACKPACK.get() || this.block == ModBlocks.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                builder.addAll(this.models.get((Object)ModelParts.VILLAGER_NOSE));
            }
        }

        private void addTanks(QuadCollection.Builder builder) {
            if (this.renderInfo == null || !this.renderInfo.isEmpty()) {
                builder.addAll(this.models.get((Object)ModelParts.TANKS));
                this.addFluids(builder, this.renderInfo);
            }
        }

        private void addFluid(QuadCollection.Builder builder, FluidStack fluidStack, float ratio, double xMin) {
            if (fluidStack.isEmpty()) {
                return;
            }
            double yMin = 0.05;
            double yMax = yMin + (double)ratio * 6.2 / 16.0;
            AABB bounds = new AABB(xMin, yMin, 0.39375, xMin + 0.09375, yMax, 0.4875);
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation stillTexture = renderProperties.getStillTexture(fluidStack);
            int color = renderProperties.getTintColor(fluidStack) | 0xFF000000;
            TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(stillTexture);
            float x1 = 0.0f;
            float x2 = 3.0f;
            float y1 = 0.0f;
            float y2 = ratio * 12.0f;
            float z1 = 0.0f;
            float z2 = 3.0f;
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(bounds.minX, bounds.maxY, bounds.minZ), this.getVector(bounds.minX, bounds.maxY, bounds.maxZ), this.getVector(bounds.maxX, bounds.maxY, bounds.maxZ), this.getVector(bounds.maxX, bounds.maxY, bounds.minZ)), still, Direction.UP, false, color, x1, x2, z1, z2));
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(bounds.maxX, bounds.maxY, bounds.minZ), this.getVector(bounds.maxX, bounds.minY, bounds.minZ), this.getVector(bounds.minX, bounds.minY, bounds.minZ), this.getVector(bounds.minX, bounds.maxY, bounds.minZ)), still, Direction.NORTH, false, color, x1, x2, y1, y2));
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(bounds.minX, bounds.maxY, bounds.maxZ), this.getVector(bounds.minX, bounds.minY, bounds.maxZ), this.getVector(bounds.maxX, bounds.minY, bounds.maxZ), this.getVector(bounds.maxX, bounds.maxY, bounds.maxZ)), still, Direction.SOUTH, false, color, x1, x2, y1, y2));
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(bounds.minX, bounds.maxY, bounds.minZ), this.getVector(bounds.minX, bounds.minY, bounds.minZ), this.getVector(bounds.minX, bounds.minY, bounds.maxZ), this.getVector(bounds.minX, bounds.maxY, bounds.maxZ)), still, Direction.WEST, false, color, z1, z2, y1, y2));
            builder.addUnculledFace(this.createQuad(List.of(this.getVector(bounds.maxX, bounds.maxY, bounds.maxZ), this.getVector(bounds.maxX, bounds.minY, bounds.maxZ), this.getVector(bounds.maxX, bounds.minY, bounds.minZ), this.getVector(bounds.maxX, bounds.maxY, bounds.minZ)), still, Direction.EAST, false, color, z1, z2, y1, y2));
        }

        private BakedQuad createQuad(List<Vector3f> vectors, TextureAtlasSprite sprite, Direction face, boolean hasAmbientOcclusion, int color, float u1x, float u2x, float v1x, float v2x) {
            QuadBakingVertexConsumer quadBaker = new QuadBakingVertexConsumer();
            quadBaker.setSprite(sprite);
            Vec3i dirVec = face.getUnitVec3i();
            quadBaker.setDirection(face);
            quadBaker.setTintIndex(-1);
            quadBaker.setShade(true);
            quadBaker.setHasAmbientOcclusion(hasAmbientOcclusion);
            float u1 = sprite.getU(u1x /= 16.0f);
            float u2 = sprite.getU(u2x /= 16.0f);
            float v1 = sprite.getV(v1x /= 16.0f);
            float v2 = sprite.getV(v2x /= 16.0f);
            quadBaker.addVertex(vectors.get(0).x(), vectors.get(0).y(), vectors.get(0).z()).setColor(color).setUv(u1, v1).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            quadBaker.addVertex(vectors.get(1).x(), vectors.get(1).y(), vectors.get(1).z()).setColor(color).setUv(u1, v2).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            quadBaker.addVertex(vectors.get(2).x(), vectors.get(2).y(), vectors.get(2).z()).setColor(color).setUv(u2, v2).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            quadBaker.addVertex(vectors.get(3).x(), vectors.get(3).y(), vectors.get(3).z()).setColor(color).setUv(u2, v1).setNormal((float)dirVec.getX(), (float)dirVec.getY(), (float)dirVec.getZ());
            return quadBaker.bakeQuad();
        }

        private Vector3f getVector(double x, double y, double z) {
            Vector3f ret = new Vector3f((float)x, (float)y, (float)z);
            this.rotate(ret, this.modelTransform.transformation().getMatrix());
            return ret;
        }

        private void rotate(Vector3f posIn, Matrix4fc transform) {
            Vector3f originIn = new Vector3f(0.5f, 0.5f, 0.5f);
            Vector4f vector4f = transform.transform(new Vector4f(posIn.x() - originIn.x(), posIn.y() - originIn.y(), posIn.z() - originIn.z(), 1.0f));
            posIn.set(vector4f.x() + originIn.x(), vector4f.y() + originIn.y(), vector4f.z() + originIn.z());
        }
    }

    private static enum ModelParts {
        BASE,
        BASE_DYED,
        EXTRAS,
        TANKS,
        SLEEPING_BAG,
        SLEEPING_BAG_EXTRAS,
        FOX_NOSE,
        OCELOT_NOSE,
        WOLF_NOSE,
        VILLAGER_NOSE,
        PIG_NOSE,
        WARDEN_HORNS;

    }

    public static final class Loader
    implements UnbakedModelLoader<BackpackDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public BackpackDynamicModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            ResourceLocation particleTexture;
            ResourceLocation backpackTexture;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            TextureSlots.Data.Builder texturesBuilder = new TextureSlots.Data.Builder();
            if (modelContents.has("backpackTexture") && (backpackTexture = ResourceLocation.tryParse((String)modelContents.get("backpackTexture").getAsString())) != null) {
                texturesBuilder.addTexture("0", new Material(TextureAtlas.LOCATION_BLOCKS, backpackTexture));
            }
            if (modelContents.has("particle") && (particleTexture = ResourceLocation.tryParse((String)modelContents.get("particle").getAsString())) != null) {
                texturesBuilder.addTexture("particle", new Material(TextureAtlas.LOCATION_BLOCKS, particleTexture));
            }
            texturesBuilder.addTexture("missing", new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation()));
            RenderTypeGroup renderTypeGroup = NeoForgeModelProperties.deserializeRenderType((JsonObject)modelContents);
            for (ModelParts part : ModelParts.values()) {
                this.addPartModel((ImmutableMap.Builder<ModelParts, UnbakedModel>)builder, part, texturesBuilder.build());
            }
            return new BackpackDynamicModel((Map<ModelParts, UnbakedModel>)builder.build(), renderTypeGroup);
        }

        private void addPartModel(ImmutableMap.Builder<ModelParts, UnbakedModel> builder, ModelParts modelPart, TextureSlots.Data textures) {
            builder.put((Object)modelPart, (Object)new BlockModel(null, null, Boolean.valueOf(true), ItemTransforms.NO_TRANSFORMS, textures, ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)("block/backpack_" + modelPart.name().toLowerCase(Locale.ENGLISH)))));
        }
    }

    public record UnbakedBlockStateModel(Variant variant) implements CustomUnbakedBlockStateModel
    {
        public static final MapCodec<UnbakedBlockStateModel> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Variant.MAP_CODEC.forGetter(UnbakedBlockStateModel::variant)).apply((Applicative)instance, UnbakedBlockStateModel::new));
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"backpack_loader");

        public BlockStateModel bake(ModelBaker modelBaker) {
            ResolvedModel resolvedModel = modelBaker.getModel(this.variant.modelLocation());
            UnbakedModel unbakedModel = resolvedModel.wrapped();
            if (unbakedModel instanceof BackpackDynamicModel) {
                BackpackDynamicModel model = (BackpackDynamicModel)unbakedModel;
                return model.bakeBlockStateModel(modelBaker, resolvedModel, this.variant.modelState().asModelState());
            }
            throw new IllegalStateException("Expected BackpackDynamicModel, instead received " + resolvedModel.wrapped().getClass().getName());
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.variant.modelLocation());
        }

        public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
            return CODEC;
        }
    }
}

