/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.model.BackpackModel;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Supporters;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;

public class BackpackLayer
extends RenderLayer<PlayerRenderState, PlayerModel> {
    public static final ContextKey<ItemStack> BACKPACK_KEY = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"backpack"));
    private static final BackpackModel BACKPACK_MODEL = new BackpackModel();

    public BackpackLayer(RenderLayerParent<PlayerRenderState, PlayerModel> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, PlayerRenderState state, float limbSwing, float limbSwingAmount) {
        if (TravelersBackpack.enableIntegration()) {
            return;
        }
        ItemStack backpack = (ItemStack)state.getRenderData(BACKPACK_KEY);
        if (backpack != null && backpack.getItem() instanceof TravelersBackpackItem) {
            BackpackLayer.renderBackpackLayer((HumanoidModel)this.getParentModel(), poseStack, bufferIn, packedLightIn, (HumanoidRenderState)state, backpack);
        }
    }

    public static void renderBackpackLayer(HumanoidModel humanoidModel, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, HumanoidRenderState state, ItemStack stack) {
        if (!((Boolean)stack.getOrDefault(ModDataComponents.IS_VISIBLE, (Object)true)).booleanValue()) {
            return;
        }
        if (!(stack.getItem() instanceof TravelersBackpackItem)) {
            return;
        }
        poseStack.pushPose();
        BackpackLayer.alignModel(poseStack, humanoidModel, BACKPACK_MODEL, state);
        BACKPACK_MODEL.render(poseStack, packedLightIn, bufferIn, stack);
        if (state instanceof PlayerRenderState) {
            PlayerRenderState playerRenderState = (PlayerRenderState)state;
            if (Supporters.SUPPORTERS.contains(playerRenderState.name)) {
                BackpackLayer.BACKPACK_MODEL.supporterBadgeModel.render(poseStack, packedLightIn);
            }
        }
        poseStack.popPose();
    }

    public static void alignModel(PoseStack poseStack, HumanoidModel parent, BackpackModel backpackModel, HumanoidRenderState state) {
        backpackModel.copyFrom(parent.body);
        backpackModel.supporterBadgeModel.copyFrom(parent.body);
        if (state.isBaby) {
            poseStack.translate(0.0f, 0.8f, -0.165f);
            float scaleFactor = state.scale;
            poseStack.scale(scaleFactor + 0.1f, scaleFactor + 0.1f, scaleFactor + 0.1f);
        }
    }
}

