/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets.settings;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundSlotPacket;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class MemoryWidget
extends SettingsWidgetBase {
    private final WidgetElement buttonElement = new WidgetElement(new Point(6, 22), new Point(18, 18));
    private final Point matchButtonUv = new Point(96, 36);
    private final Point ignoreButtonUv = new Point(114, 36);
    private final Point openTabUv = new Point(203, 0);
    private final Point iconUv = new Point(78, 0);
    private final Point iconHighlightedUv = new Point(78, 18);
    public boolean matchComponents;
    private static final List<Component> IGNORE_MODE_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_match_components"), Component.translatable((String)"screen.travelersbackpack.filter_ignore_components"));

    public MemoryWidget(BackpackSettingsScreen screen, Point pos, boolean matchComponents) {
        super(screen, pos, new Point(30, 46));
        this.matchComponents = matchComponents;
    }

    public boolean isTabOpened() {
        return this.tabOpened;
    }

    public void sendDataToServer() {
        if (!((BackpackSettingsScreen)this.screen).memorySlots.equals(((BackpackSettingsScreen)this.screen).lastMemorySlots)) {
            ((BackpackSettingsScreen)this.screen).memorySlots.sort(Comparator.comparingInt(Pair::getFirst));
            ArrayList<Pair<Integer, Boolean>> reducedMemoryList = new ArrayList<Pair<Integer, Boolean>>();
            for (Pair<Integer, Pair<ItemStack, Boolean>> memoryPair : ((BackpackSettingsScreen)this.screen).memorySlots) {
                reducedMemoryList.add((Pair<Integer, Boolean>)Pair.of((Object)((Integer)memoryPair.getFirst()), (Object)((Boolean)((Pair)memoryPair.getSecond()).getSecond())));
            }
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSlotPacket(1, List.of(), reducedMemoryList), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((BackpackSettingsScreen)this.screen).lastMemorySlots.clear();
            ((BackpackSettingsScreen)this.screen).lastMemorySlots.addAll(((BackpackSettingsScreen)this.screen).memorySlots);
        }
    }

    public boolean contains(int index, List<Pair<Integer, Pair<ItemStack, Boolean>>> memory) {
        for (Pair<Integer, Pair<ItemStack, Boolean>> memoryPairs : memory) {
            if ((Integer)memoryPairs.getFirst() != index) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.tabOpened) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.TABS, this.pos.x(), this.pos.y(), (float)this.openTabUv.x(), (float)this.openTabUv.y(), this.openTabSize.x(), this.openTabSize.y(), 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 3, this.pos.y() + 3, (float)this.iconHighlightedUv.x(), (float)this.iconHighlightedUv.y(), this.iconSize.x(), this.iconSize.y(), 256, 256);
            Point buttonUv = this.matchComponents ? this.matchButtonUv : this.ignoreButtonUv;
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + this.buttonElement.pos().x(), this.pos.y() + this.buttonElement.pos().y(), (float)buttonUv.x(), (float)buttonUv.y(), this.buttonElement.size().x(), this.buttonElement.size().y(), 256, 256);
        } else {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x(), this.pos.y(), (float)this.emptyTabUv.x(), (float)this.emptyTabUv.y(), this.width, this.height, 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 3, this.pos.y() + 3, (float)this.iconUv.x(), (float)this.iconUv.y(), this.iconSize.x(), this.iconSize.y(), 256, 256);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isTabOpened() && this.isMouseOverMatchComponentsButton(mouseX, mouseY)) {
            guiGraphics.setTooltipForNextFrame(((BackpackSettingsScreen)this.screen).getFont(), IGNORE_MODE_TOOLTIPS.get(this.matchComponents ? 0 : 1), mouseX, mouseY);
        }
        if (this.isMouseOverIcon(mouseX, mouseY)) {
            guiGraphics.setComponentTooltipForNextFrame(((BackpackSettingsScreen)this.screen).getFont(), TextUtils.getTranslatedSplittedText("screen.travelersbackpack.memory", null), mouseX, mouseY);
        }
    }

    public boolean isMouseOverMatchComponentsButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.buttonElement);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isTabOpened() && this.isMouseOverMatchComponentsButton(pMouseX, pMouseY)) {
            this.matchComponents = !this.matchComponents;
            ((BackpackSettingsScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isMouseOverIcon(pMouseX, pMouseY)) {
            this.tabOpened = !this.tabOpened;
            ((BackpackSettingsScreen)this.screen).updateWidgetsPosition(this);
            if (!this.tabOpened) {
                this.sendDataToServer();
            }
            ((BackpackSettingsScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }
}

