/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.network.ClientboundSyncAttachmentPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public record BackpackContainer(ItemStack stack, Player player, int screenID, int index) implements MenuProvider,
Nameable
{
    public BackpackContainer(ItemStack stack, Player player, int screenID) {
        this(stack, player, screenID, -1);
    }

    public Component getName() {
        return Component.translatable((String)"screen.travelersbackpack.item");
    }

    public Component getDisplayName() {
        return Component.translatable((String)"screen.travelersbackpack.item");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (this.screenID == 2) {
            return new BackpackItemMenu(pContainerId, pPlayerInventory, AttachmentUtils.getBackpackWrapper(this.player));
        }
        return new BackpackItemMenu(pContainerId, pPlayerInventory, new BackpackWrapper(this.stack, this.screenID, (HolderLookup.Provider)pPlayer.registryAccess(), pPlayer, pPlayer.level(), this.index));
    }

    public static FriendlyByteBuf saveExtraData(FriendlyByteBuf buf, @Nullable Player target, int screenID) {
        buf.writeInt(screenID);
        buf.writeInt(target == null ? -1 : target.getId());
        return buf;
    }

    public static FriendlyByteBuf saveExtraData(FriendlyByteBuf buf, int index, int screenID) {
        buf.writeInt(screenID);
        buf.writeInt(index);
        return buf;
    }

    public static void openBackpack(ServerPlayer serverPlayerEntity, ItemStack stack, int screenID) {
        if (!serverPlayerEntity.level().isClientSide) {
            serverPlayerEntity.openMenu((MenuProvider)new BackpackContainer(stack, (Player)serverPlayerEntity, screenID), buf -> BackpackContainer.saveExtraData((FriendlyByteBuf)buf, null, screenID));
        }
    }

    public static void openBackpack(ServerPlayer serverPlayerEntity, ItemStack stack, int screenID, int index) {
        if (!serverPlayerEntity.level().isClientSide) {
            serverPlayerEntity.openMenu((MenuProvider)new BackpackContainer(stack, (Player)serverPlayerEntity, screenID, index), buf -> BackpackContainer.saveExtraData((FriendlyByteBuf)buf, index, screenID));
        }
    }

    public static void openAnotherPlayerBackpack(ServerPlayer opener, ServerPlayer targetPlayer, ItemStack stack, int screenID) {
        if (!opener.level().isClientSide) {
            BackpackContainer.synchroniseToOpener(opener, targetPlayer);
            opener.openMenu((MenuProvider)new BackpackContainer(stack, (Player)targetPlayer, screenID), buf -> BackpackContainer.saveExtraData((FriendlyByteBuf)buf, (Player)targetPlayer, screenID));
        }
    }

    public static void synchroniseToOpener(ServerPlayer opener, ServerPlayer target) {
        if (opener != null) {
            AttachmentUtils.getAttachment((Player)target).ifPresent(cap -> PacketDistributor.sendToPlayer((ServerPlayer)opener, (CustomPacketPayload)new ClientboundSyncAttachmentPacket(target.getId(), cap.getBackpack()), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }
}

