/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public abstract class FilterSettingsBase {
    protected List<ItemStack> filterItems;
    protected List<String> filterTags = new ArrayList<String>();
    protected List<TagKey<Item>> tags = new ArrayList<TagKey<Item>>();
    protected List<Integer> filterSettings;
    protected ItemStackHandler storage;
    protected HolderLookup.Provider access;
    private final int slotLimit;

    public FilterSettingsBase(ItemStackHandler storage, List<ItemStack> items, List<Integer> filterSettings, HolderLookup.Provider access, int slotLimit) {
        this(storage, items, filterSettings, List.of(), access, slotLimit);
    }

    public FilterSettingsBase(ItemStackHandler storage, List<ItemStack> items, List<Integer> filterSettings, List<String> filterTags, HolderLookup.Provider access, int slotLimit) {
        this.filterItems = items;
        this.filterTags = filterTags;
        this.filterSettings = filterSettings;
        this.storage = storage;
        this.access = access;
        this.slotLimit = slotLimit;
        this.reloadItemTags();
    }

    public abstract boolean matchesFilter(@Nullable Player var1, ItemStack var2);

    public List<Integer> getSettings() {
        return this.filterSettings;
    }

    public boolean isTagFilter() {
        return false;
    }

    public boolean compareModId(ItemStack stack, ItemStack other) {
        return stack.getItem().getCreatorModId(this.access, stack).equals(other.getItem().getCreatorModId(this.access, other));
    }

    public Stream<ItemStack> streamStorageContents() {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.storage.getSlots(); ++i) {
            if (this.storage.getStackInSlot(i).isEmpty()) continue;
            arrayList.add(this.storage.getStackInSlot(i));
        }
        return arrayList.stream();
    }

    public void reloadItemTags() {
        this.tags.clear();
        if (this.filterTags != null) {
            this.filterTags.forEach(string -> {
                TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)string));
                if (!this.tags.contains(tagKey)) {
                    this.tags.add((TagKey<Item>)tagKey);
                }
            });
        }
    }

    public void updateFilter(@Nullable List<ItemStack> items) {
        if (items == null) {
            return;
        }
        this.filterItems = items.stream().limit(this.slotLimit).filter(stack -> !stack.isEmpty()).toList();
    }

    public void updateFilterTags(List<String> tags) {
        if (tags == null) {
            return;
        }
        this.filterTags = new ArrayList<String>(tags);
        this.reloadItemTags();
    }

    public void updateSettings(List<Integer> settings) {
        this.filterSettings = settings;
    }

    public List<ItemStack> getFilterItems() {
        return this.filterItems;
    }

    public List<String> getFilterTags() {
        return this.filterTags;
    }

    public List<String> getAddableTags() {
        ArrayList<String> addableTags = new ArrayList<String>();
        ItemStack stack = ItemStack.EMPTY;
        if (this.filterItems != null && !this.filterItems.isEmpty()) {
            stack = this.filterItems.get(0);
        }
        if (!stack.isEmpty()) {
            stack.getTags().forEach(tag -> addableTags.add(tag.location().toString()));
        }
        addableTags.removeAll(this.filterTags);
        return addableTags;
    }
}

