/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.advancements.ActionTypeTrigger;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModAdvancements;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class HoseItem
extends Item {
    public static final int NO_ASSIGN = 0;
    public static final int SUCK_MODE = 1;
    public static final int SPILL_MODE = 2;
    public static final int DRINK_MODE = 3;

    public HoseItem(Item.Properties properties) {
        super(properties.component(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(1), Integer.valueOf(1))));
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        if (HoseItem.getHoseMode(stack) == 3) {
            return ItemUseAnimation.DRINK;
        }
        return ItemUseAnimation.NONE;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pEntity) {
        return 24;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (AttachmentUtils.isWearingBackpack(player) && hand == InteractionHand.MAIN_HAND) {
            BackpackWrapper wrapper = AttachmentUtils.getBackpackWrapper(player, AttachmentUtils.UPGRADES_ONLY);
            if (!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                return InteractionResult.PASS;
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());
            if (HoseItem.getHoseMode(stack) == 1) {
                BlockState blockstate1;
                Block block;
                BlockHitResult result = HoseItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
                BlockPos blockpos = result.getBlockPos();
                Direction direction1 = result.getDirection();
                BlockPos blockpos1 = blockpos.relative(result.getDirection());
                if (level.mayInteract((Entity)player, blockpos) && player.mayUseItemAt(blockpos1, direction1, stack) && (block = (blockstate1 = level.getBlockState(blockpos)).getBlock()) instanceof BucketPickup) {
                    BucketPickup pickup = (BucketPickup)block;
                    Fluid fluid = blockstate1.getFluidState().getType();
                    if (fluid != Fluids.EMPTY) {
                        ItemStack actualFluid;
                        boolean canFill;
                        FluidStack fluidStack = new FluidStack(fluid, 1000);
                        int tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                        boolean bl = canFill = tank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)fluidStack);
                        if (canFill && fluidStack.getAmount() + tankAmount <= tank.getCapacity() && !(actualFluid = pickup.pickupBlock((LivingEntity)player, (LevelAccessor)level, blockpos, blockstate1)).isEmpty()) {
                            SoundEvent bucketFill = Optional.ofNullable(fluidStack.getFluidType().getSound(SoundActions.BUCKET_FILL)).orElse(fluid.is(FluidTags.LAVA) ? SoundEvents.BUCKET_FILL_LAVA : SoundEvents.BUCKET_FILL);
                            level.playSound((Entity)player, result.getBlockPos(), bucketFill, SoundSource.BLOCKS, 1.0f, 1.0f);
                            tank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                            this.triggerAdvancement(player, "hose_suck");
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
            if (HoseItem.getHoseMode(stack) == 2 && tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get() && ((CustomData)tank.getFluid().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("PotionType")) {
                int potionType = ((CustomData)tank.getFluid().get(DataComponents.CUSTOM_DATA)).copyTag().getIntOr("PotionType", 0);
                if (potionType == 1) {
                    if (tank.getFluidAmount() >= 250) {
                        potionStack = FluidStackHelper.getSplashItemStackFromFluidStack(tank.getFluid());
                        int drainAmount = ServerActions.throwPotion(level, player, potionStack, true);
                        tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                        this.triggerAdvancement(player, "hose_spill_potion");
                        return InteractionResult.SUCCESS;
                    }
                } else if (potionType == 2 && tank.getFluidAmount() >= 250) {
                    potionStack = FluidStackHelper.getLingeringItemStackFromFluidStack(tank.getFluid());
                    int drainAmount = ServerActions.throwPotion(level, player, potionStack, false);
                    tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                    this.triggerAdvancement(player, "hose_spill_potion");
                    return InteractionResult.SUCCESS;
                }
            }
            if (HoseItem.getHoseMode(stack) == 3 && !tank.isEmpty() && EffectFluidRegistry.hasExecutableEffects(tank.getFluid(), level, (Entity)player)) {
                player.startUsingItem(hand);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        ItemStack stack = player.getItemInHand(context.getHand());
        if (AttachmentUtils.isWearingBackpack(player) && context.getHand() == InteractionHand.MAIN_HAND) {
            FluidStack fluidStack;
            FluidStack fluidStack2;
            Optional fluidHandler = FluidUtil.getFluidHandler((Level)level, (BlockPos)pos, (Direction)direction);
            BackpackWrapper wrapper = AttachmentUtils.getBackpackWrapper(player, AttachmentUtils.UPGRADES_ONLY);
            if (!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                return InteractionResult.PASS;
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());
            if (HoseItem.getHoseMode(stack) == 1) {
                BlockState blockstate1;
                Block block;
                if (fluidHandler.isPresent() && !fluidHandler.map(h -> h.getFluidInTank(0).isEmpty()).get().booleanValue() && !(fluidStack2 = FluidUtil.tryFluidTransfer((IFluidHandler)tank, (IFluidHandler)fluidHandler.orElse(null), (int)1000, (boolean)true)).isEmpty()) {
                    SoundEvent bucketFill = Optional.ofNullable(fluidStack2.getFluidType().getSound(SoundActions.BUCKET_FILL)).orElse(SoundEvents.BUCKET_FILL);
                    level.playSound((Entity)player, pos, bucketFill, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.triggerAdvancement(player, "hose_suck");
                    return InteractionResult.SUCCESS;
                }
                BlockHitResult result = HoseItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
                BlockPos blockpos = result.getBlockPos();
                Direction direction1 = result.getDirection();
                BlockPos blockpos1 = blockpos.relative(direction);
                if (level.mayInteract((Entity)player, blockpos) && player.mayUseItemAt(blockpos1, direction1, stack) && (block = (blockstate1 = level.getBlockState(blockpos)).getBlock()) instanceof BucketPickup) {
                    BucketPickup pickup = (BucketPickup)block;
                    Fluid fluid = blockstate1.getFluidState().getType();
                    if (fluid != Fluids.EMPTY) {
                        ItemStack actualFluid;
                        boolean canFill;
                        fluidStack = new FluidStack(fluid, 1000);
                        int tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                        boolean bl = canFill = tank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)fluidStack);
                        if (canFill && fluidStack.getAmount() + tankAmount <= tank.getCapacity() && !(actualFluid = pickup.pickupBlock((LivingEntity)player, (LevelAccessor)level, blockpos, blockstate1)).isEmpty()) {
                            SoundEvent bucketFill = Optional.ofNullable(fluidStack.getFluidType().getSound(SoundActions.BUCKET_FILL)).orElse(fluid.is(FluidTags.LAVA) ? SoundEvents.BUCKET_FILL_LAVA : SoundEvents.BUCKET_FILL);
                            level.playSound((Entity)player, result.getBlockPos(), bucketFill, SoundSource.BLOCKS, 1.0f, 1.0f);
                            tank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                            this.triggerAdvancement(player, "hose_suck");
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
            if (HoseItem.getHoseMode(stack) == 2) {
                if (fluidHandler.isPresent() && !tank.isEmpty() && !(fluidStack2 = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler.orElse(null), (IFluidHandler)tank, (int)1000, (boolean)true)).isEmpty()) {
                    SoundEvent bucketFill = Optional.ofNullable(fluidStack2.getFluidType().getSound(SoundActions.BUCKET_FILL)).orElse(SoundEvents.BUCKET_FILL);
                    level.playSound((Entity)player, pos, bucketFill, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.triggerAdvancement(player, "hose_spill");
                    return InteractionResult.SUCCESS;
                }
                if (tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get() && ((CustomData)tank.getFluid().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("PotionType")) {
                    int potionType = ((CustomData)tank.getFluid().get(DataComponents.CUSTOM_DATA)).copyTag().getIntOr("PotionType", 0);
                    if (potionType == 1) {
                        if (tank.getFluidAmount() >= 250) {
                            potionStack = FluidStackHelper.getSplashItemStackFromFluidStack(tank.getFluid());
                            int drainAmount = ServerActions.throwPotion(level, player, potionStack, true);
                            tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                            this.triggerAdvancement(player, "hose_spill_potion");
                            return InteractionResult.SUCCESS;
                        }
                    } else if (potionType == 2 && tank.getFluidAmount() >= 250) {
                        potionStack = FluidStackHelper.getLingeringItemStackFromFluidStack(tank.getFluid());
                        int drainAmount = ServerActions.throwPotion(level, player, potionStack, false);
                        tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                        this.triggerAdvancement(player, "hose_spill_potion");
                        return InteractionResult.SUCCESS;
                    }
                }
                if (!tank.isEmpty()) {
                    BlockState blockState = level.getBlockState(pos);
                    Block block = blockState.getBlock();
                    Fluid fluid = tank.getFluid().getFluid();
                    if (tank.getFluidAmount() >= 1000 && fluid instanceof FlowingFluid) {
                        LiquidBlockContainer container;
                        FlowingFluid flowingFluid = (FlowingFluid)fluid;
                        if (block instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).canPlaceLiquid((LivingEntity)player, (BlockGetter)level, pos, blockState, fluid)) {
                            container.placeLiquid((LevelAccessor)level, pos, blockState, flowingFluid.getSource(false));
                            SoundEvent bucketEmpty = Optional.ofNullable(fluid.getFluidType().getSound(SoundActions.BUCKET_EMPTY)).orElse(SoundEvents.BUCKET_EMPTY);
                            level.playSound((Entity)player, pos, bucketEmpty, SoundSource.BLOCKS, 1.0f, 1.0f);
                            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            this.triggerAdvancement(player, "hose_spill");
                            return InteractionResult.SUCCESS;
                        }
                    }
                    int x = pos.getX();
                    int y = pos.getY();
                    int z = pos.getZ();
                    if (!level.getBlockState(pos).canBeReplaced(fluid)) {
                        switch (context.getClickedFace()) {
                            case WEST: {
                                --x;
                                break;
                            }
                            case EAST: {
                                ++x;
                                break;
                            }
                            case NORTH: {
                                --z;
                                break;
                            }
                            case SOUTH: {
                                ++z;
                                break;
                            }
                            case UP: {
                                ++y;
                                break;
                            }
                            case DOWN: {
                                --y;
                                break;
                            }
                        }
                    }
                    BlockPos newPos = new BlockPos(x, y, z);
                    fluidStack = tank.getFluid();
                    if (level.getBlockState(newPos).canBeReplaced(fluid) && fluid.getFluidType().canBePlacedInLevel((BlockAndTintGetter)level, newPos, fluidStack)) {
                        boolean flag;
                        boolean bl = flag = !level.getBlockState(newPos).isSolid();
                        if (level.dimensionType().ultraWarm() && fluidStack.getFluid().is(FluidTags.WATER)) {
                            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            level.playSound(null, newPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.8f);
                            for (int i = 0; i < 3; ++i) {
                                double d0 = (double)newPos.getX() + level.getRandom().nextDouble();
                                double d1 = (double)newPos.getY() + level.getRandom().nextDouble() * 0.5 + 0.5;
                                double d2 = (double)newPos.getZ() + level.getRandom().nextDouble();
                                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                            }
                            this.triggerAdvancement(player, "hose_spill");
                            return InteractionResult.SUCCESS;
                        }
                        if (fluidStack.getAmount() >= 1000) {
                            if (!level.isClientSide && flag && !level.getBlockState(newPos).liquid()) {
                                level.destroyBlock(newPos, false);
                            }
                            if (level.setBlock(newPos, fluidStack.getFluid().defaultFluidState().createLegacyBlock(), 3)) {
                                SoundEvent bucketEmpty = Optional.ofNullable(fluidStack.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY)).orElse(SoundEvents.BUCKET_EMPTY);
                                level.playSound((Entity)player, newPos, bucketEmpty, SoundSource.BLOCKS, 1.0f, 1.0f);
                                tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                                level.updateNeighborsAt(newPos, fluidStack.getFluid().defaultFluidState().createLegacyBlock().getBlock());
                            }
                            this.triggerAdvancement(player, "hose_spill");
                            return InteractionResult.SUCCESS;
                        }
                    }
                }
            }
            if (HoseItem.getHoseMode(stack) == 3 && !tank.isEmpty() && EffectFluidRegistry.hasExecutableEffects(tank.getFluid(), level, (Entity)player)) {
                player.startUsingItem(context.getHand());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        Player player;
        if (entityLiving instanceof Player && AttachmentUtils.isWearingBackpack(player = (Player)entityLiving)) {
            BackpackWrapper wrapper = AttachmentUtils.getBackpackWrapper(player, AttachmentUtils.UPGRADES_ONLY);
            if (!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                return stack;
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());
            if (HoseItem.getHoseMode(stack) == 3 && tank != null && ServerActions.setFluidEffect(level, player, tank)) {
                int drainAmount = EffectFluidRegistry.getHighestFluidEffectAmount(tank.getFluid().getFluid());
                if (tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get()) {
                    this.triggerAdvancement(player, "hose_drink_potion");
                }
                this.triggerAdvancement(player, "hose_drink");
                tank.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return stack;
    }

    public void triggerAdvancement(Player player, String type) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((ActionTypeTrigger)((Object)ModAdvancements.ACTION_TRIGGER.get())).trigger(serverPlayer, type);
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (AttachmentUtils.isWearingBackpack(player) && hand == InteractionHand.MAIN_HAND && HoseItem.getHoseMode(stack) == 1) {
            BackpackWrapper wrapper = AttachmentUtils.getBackpackWrapper(player, AttachmentUtils.UPGRADES_ONLY);
            if (!wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                return InteractionResult.PASS;
            }
            FluidTank tank = this.getSelectedFluidTank(stack, wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get());
            Optional milk = BuiltInRegistries.FLUID.getOptional(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"milk"));
            if (milk.isPresent() && entity instanceof Cow) {
                int tankAmount = tank.isEmpty() ? 0 : tank.getFluidAmount();
                FluidStack milkStack = new FluidStack((Fluid)milk.get(), 1000);
                if (milkStack.getFluid() != Fluids.EMPTY && (tank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)milkStack)) && milkStack.getAmount() + tankAmount <= tank.getCapacity()) {
                    tank.fill(milkStack, IFluidHandler.FluidAction.EXECUTE);
                    player.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static int getHoseMode(ItemStack stack) {
        if (stack.has(ModDataComponents.HOSE_MODES)) {
            return (Integer)((List)stack.get(ModDataComponents.HOSE_MODES)).get(0);
        }
        return 0;
    }

    public static int getHoseTank(ItemStack stack) {
        if (((List)stack.getOrDefault(ModDataComponents.HOSE_MODES, List.of())).size() == 2) {
            return (Integer)((List)stack.get(ModDataComponents.HOSE_MODES)).get(1);
        }
        return 0;
    }

    public FluidTank getSelectedFluidTank(ItemStack stack, TanksUpgrade upgrade) {
        return HoseItem.getHoseTank(stack) == 1 ? upgrade.getLeftTank() : upgrade.getRightTank();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag tooltipFlag) {
        if (stack.has(ModDataComponents.HOSE_MODES)) {
            int tank;
            int mode = (Integer)((List)stack.get(ModDataComponents.HOSE_MODES)).get(0);
            if (mode == 1) {
                componentConsumer.accept((Component)Component.translatable((String)"item.travelersbackpack.hose.suck").withStyle(ChatFormatting.BLUE));
            }
            if (mode == 2) {
                componentConsumer.accept((Component)Component.translatable((String)"item.travelersbackpack.hose.spill").withStyle(ChatFormatting.BLUE));
            }
            if (mode == 3) {
                componentConsumer.accept((Component)Component.translatable((String)"item.travelersbackpack.hose.drink").withStyle(ChatFormatting.BLUE));
            }
            if ((tank = ((Integer)((List)stack.get(ModDataComponents.HOSE_MODES)).get(1)).intValue()) == 1) {
                componentConsumer.accept((Component)Component.translatable((String)"item.travelersbackpack.hose.tank_left").withStyle(ChatFormatting.BLUE));
            }
            if (tank == 2) {
                componentConsumer.accept((Component)Component.translatable((String)"item.travelersbackpack.hose.tank_right").withStyle(ChatFormatting.BLUE));
            }
        }
    }
}

