/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items.upgrades;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.smelting.BlastFurnaceUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.function.TriFunction;

public class BlastFurnaceUpgradeItem
extends UpgradeItem {
    public BlastFurnaceUpgradeItem(Item.Properties pProperties) {
        super(pProperties, "blast_furnace_upgrade");
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        if (TravelersBackpackConfig.serverSpec.isLoaded()) {
            return (Boolean)TravelersBackpackConfig.SERVER.backpackUpgrades.enableBlastFurnaceUpgrade.get() != false && super.isEnabled(enabledFeatures);
        }
        return super.isEnabled(enabledFeatures);
    }

    @Override
    public boolean isTickingUpgrade() {
        return true;
    }

    @Override
    public Class<? extends UpgradeBase<?>> getUpgradeClass() {
        return BlastFurnaceUpgrade.class;
    }

    @Override
    public TriFunction<UpgradeManager, Integer, ItemStack, Optional<? extends UpgradeBase<?>>> getUpgrade() {
        return (upgradeManager, dataHolderSlot, provider) -> {
            BackpackContainerContents contents = (BackpackContainerContents)provider.getOrDefault((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), (Object)new BackpackContainerContents(3));
            return Optional.of(new BlastFurnaceUpgrade((UpgradeManager)upgradeManager, (int)dataHolderSlot, contents.getItems()));
        };
    }
}

