/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.mojang.serialization.DynamicOps;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankActions;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundActionTagPacket(CompoundTag actionTag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundActionTagPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"action_tag"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundActionTagPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, ServerboundActionTagPacket::actionTag, ServerboundActionTagPacket::new);
    public static final int UPGRADE_TAB = 0;
    public static final int OPEN_SCREEN = 1;
    public static final int OPEN_BACKPACK = 2;
    public static final int SORTER = 3;
    public static final int SLEEPING_BAG = 4;
    public static final int FILL_TANK = 5;
    public static final int SWAP_TOOL = 6;
    public static final int TOGGLE_BUTTONS_VISIBILITY = 7;
    public static final int SHOW_TOOL_SLOTS = 8;
    public static final int REMOVE_UPGRADE = 9;
    public static final int OPEN_SETTINGS = 10;
    public static final int SWITCH_HOSE_MODE = 11;
    public static final int SWITCH_HOSE_TANK = 12;
    public static final int TOGGLE_VISIBILITY = 13;
    public static final int ABILITY_SLIDER = 14;
    public static final int EQUIP_BACKPACK = 15;

    public static void handle(ServerboundActionTagPacket message, IPayloadContext ctx) {
        ctx.player().getServer().execute(() -> {
            Player patt0$temp = ctx.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            CompoundTag actionTag = message.actionTag();
            int actionType = actionTag.getIntOr("ActionType", -1);
            switch (actionType) {
                case 0: {
                    int slot = actionTag.getIntOr("Arg0", -1);
                    boolean open = actionTag.getBooleanOr("Arg1", false);
                    int packetType = actionTag.getIntOr("Arg2", -1);
                    ServerActions.modifyUpgradeTab(player, slot, open, packetType);
                    break;
                }
                case 1: {
                    if (!AttachmentUtils.isWearingBackpack((Player)player)) break;
                    BackpackContainer.openBackpack(player, AttachmentUtils.getWearingBackpack((Player)player), 2);
                    break;
                }
                case 2: {
                    int index = actionTag.getIntOr("Arg0", -1);
                    boolean fromSlot = actionTag.getBooleanOr("Arg1", false);
                    ServerActions.openBackpackFromSlot(player, index, fromSlot);
                    break;
                }
                case 3: {
                    int button = actionTag.getIntOr("Arg0", -1);
                    boolean shiftPressed = actionTag.getBooleanOr("Arg1", false);
                    ServerActions.sortBackpack((Player)player, button, shiftPressed);
                    break;
                }
                case 4: {
                    BlockPos pos = (BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)actionTag.get("Arg0")).getOrThrow();
                    boolean isEquipped = actionTag.getBooleanOr("Arg1", false);
                    ServerActions.toggleSleepingBag((Player)player, pos, isEquipped);
                    break;
                }
                case 5: {
                    boolean leftTank = actionTag.getBooleanOr("Arg0", false);
                    TankActions.fillTank(player, leftTank);
                    break;
                }
                case 6: {
                    double scrollDelta = actionTag.getDoubleOr("Arg0", 0.0);
                    ServerActions.swapTool((Player)player, scrollDelta);
                    break;
                }
                case 7: {
                    ServerActions.toggleButtonsVisibility((Player)player);
                    break;
                }
                case 8: {
                    boolean show = actionTag.getBooleanOr("Arg0", false);
                    ServerActions.showToolSlots(player, show);
                    break;
                }
                case 9: {
                    int slot = actionTag.getIntOr("Arg0", -1);
                    ServerActions.removeBackpackUpgrade(player, slot);
                    break;
                }
                case 10: {
                    int entityId = actionTag.getIntOr("Arg0", -1);
                    boolean open = actionTag.getBooleanOr("Arg1", false);
                    ServerActions.openBackpackSettings(player, entityId, open);
                    break;
                }
                case 11: {
                    double scrollDelta = actionTag.getDoubleOr("Arg0", 0.0);
                    ServerActions.switchHoseMode((Player)player, scrollDelta);
                    break;
                }
                case 12: {
                    ServerActions.toggleHoseTank((Player)player);
                    break;
                }
                case 13: {
                    ServerActions.toggleVisibility((Player)player);
                    break;
                }
                case 14: {
                    boolean sliderValue = actionTag.getBooleanOr("Arg0", false);
                    ServerActions.switchAbilitySlider(player, sliderValue);
                    break;
                }
                case 15: {
                    boolean equip = actionTag.getBooleanOr("Arg0", false);
                    ServerActions.equipBackpack((Player)player, equip);
                }
            }
        });
    }

    public static void create(int type, Object ... args) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundActionTagPacket(ServerboundActionTagPacket.createPacketTag(type, args)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static CompoundTag createPacketTag(int type, Object ... args) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("ActionType", type);
        for (int i = 0; i < args.length; ++i) {
            String argName = "Arg" + i;
            if (args[i] instanceof BlockPos) {
                tag.put(argName, (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((BlockPos)args[i])).getOrThrow());
                continue;
            }
            if (args[i] instanceof Boolean) {
                tag.putBoolean(argName, ((Boolean)args[i]).booleanValue());
                continue;
            }
            if (args[i] instanceof Byte) {
                tag.putByte(argName, ((Byte)args[i]).byteValue());
                continue;
            }
            if (args[i] instanceof Integer) {
                tag.putInt(argName, ((Integer)args[i]).intValue());
                continue;
            }
            if (!(args[i] instanceof Double)) continue;
            tag.putDouble(argName, ((Double)args[i]).doubleValue());
        }
        return tag;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

