/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.mojang.serialization.DynamicOps;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncAttachmentPacket;
import com.tiviacz.travelersbackpack.network.ClientboundSyncComponentsPacket;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.network.PacketDistributor;

public class TravelersBackpackSerializable
implements ITravelersBackpack,
ValueIOSerializable {
    public final Player player;
    public BackpackWrapper backpackWrapper;
    public ItemStack backpack = new ItemStack((ItemLike)Items.AIR, 0);

    public TravelersBackpackSerializable(IAttachmentHolder holder) {
        this.player = (Player)holder;
    }

    @Override
    public boolean hasBackpack() {
        return this.backpack.getItem() instanceof TravelersBackpackItem;
    }

    @Override
    public ItemStack getBackpack() {
        return this.backpack;
    }

    @Override
    public void equipBackpack(ItemStack stack) {
        this.remove();
        if (!(stack.getItem() instanceof TravelersBackpackItem)) {
            return;
        }
        this.backpack = stack;
        this.backpackWrapper = new BackpackWrapper(this.backpack, 2, (HolderLookup.Provider)this.player.registryAccess(), this.player, this.player.level());
        this.backpackWrapper.setBackpackOwner(this.player);
        this.synchronise();
    }

    @Override
    public void updateBackpack(ItemStack stack) {
        if (this.backpackWrapper != null) {
            this.backpack = stack;
            this.backpackWrapper.setBackpackStack(this.backpack);
        } else {
            this.equipBackpack(stack);
        }
    }

    @Override
    public void applyComponents(DataComponentMap map) {
        if (this.backpackWrapper != null) {
            this.backpack.applyComponents(map);
            this.backpackWrapper.setBackpackStack(this.backpack);
        }
    }

    @Override
    public void removeWearable() {
        this.backpack = new ItemStack((ItemLike)Items.AIR, 0);
    }

    @Override
    public void removeWrapper() {
        if (this.backpackWrapper != null) {
            this.backpackWrapper = null;
        }
    }

    @Override
    public void remove() {
        this.removeWearable();
        this.removeWrapper();
        if (this.player.level() != null && !this.player.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.player, (CustomPacketPayload)new ClientboundSyncAttachmentPacket(this.player.getId(), this.backpack, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.backpackWrapper;
    }

    @Override
    public void synchronise() {
        if (this.player != null && !this.player.level().isClientSide) {
            AttachmentUtils.getAttachment(this.player).ifPresent(cap -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.player, (CustomPacketPayload)new ClientboundSyncAttachmentPacket(this.player.getId(), this.backpack), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    @Override
    public void synchronise(DataComponentMap map) {
        if (this.player != null && !this.player.level().isClientSide) {
            AttachmentUtils.getAttachment(this.player).ifPresent(cap -> PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this.player, (CustomPacketPayload)new ClientboundSyncComponentsPacket(this.player.getId(), map), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    public void serialize(ValueOutput valueOutput) {
        valueOutput.store("Backpack", ItemStack.OPTIONAL_CODEC, (Object)this.backpack);
    }

    public void deserialize(ValueInput valueInput) {
        Optional compound = valueInput.read("components", CompoundTag.CODEC);
        int count = valueInput.getIntOr("count", 0);
        String id = valueInput.getStringOr("id", "null");
        if (compound.isPresent() && count == 1 && !id.equals("null")) {
            DataComponentPatch map = DataComponentPatch.CODEC.parse((DynamicOps)valueInput.lookup().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)((Tag)compound.get())).result().orElse(DataComponentPatch.EMPTY);
            Item backpack = ((Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.parse((String)id))).asItem();
            if (backpack instanceof TravelersBackpackItem) {
                ItemStack backpackStack = new ItemStack((ItemLike)backpack, count);
                backpackStack.applyComponents(map);
                this.equipBackpack(backpackStack.copy());
                return;
            }
        }
        ItemStack backpack = valueInput.read("Backpack", ItemStack.OPTIONAL_CODEC).orElseGet(() -> new ItemStack((ItemLike)Items.AIR, 0));
        this.equipBackpack(backpack);
    }
}

