/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tiviacz.travelersbackpack.client.model.BackpackModelPart;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionfc;

public class StackModelPart
extends BackpackModelPart {
    public List<ItemStack> prepare(ItemStack stack) {
        if (stack.has(ModDataComponents.TOOLS_CONTAINER)) {
            return new ArrayList<ItemStack>((Collection<ItemStack>)((BackpackContainerContents)stack.get(ModDataComponents.TOOLS_CONTAINER)).getItems()).stream().filter(itemStack -> !itemStack.isEmpty()).toList();
        }
        return new ArrayList<ItemStack>();
    }

    public void render(ItemStack backpack, MultiBufferSource buffer, PoseStack poseStack, int light, int overlay) {
        if (buffer == null) {
            return;
        }
        this.render(this.prepare(backpack), poseStack, buffer, light, overlay);
    }

    public void render(List<ItemStack> tools, PoseStack poseStack, MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        if (tools.isEmpty()) {
            return;
        }
        ItemStack toolUpper = tools.get(0);
        ItemStack toolLower = ItemStack.EMPTY;
        if (!toolUpper.isEmpty() && tools.size() > 1) {
            toolLower = tools.get(tools.size() - 1);
        }
        if (!toolUpper.isEmpty()) {
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(0.04, 0.075, 0.17);
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(45.0f));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(toolUpper, ItemDisplayContext.NONE, pPackedLight, pPackedOverlay, poseStack, buffer, null, 0);
            poseStack.popPose();
        }
        if (!toolLower.isEmpty()) {
            poseStack.pushPose();
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(-0.25, 0.75, -0.025);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(45.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(toolLower, ItemDisplayContext.NONE, pPackedLight, pPackedOverlay, poseStack, buffer, null, 0);
            poseStack.popPose();
        }
    }
}

