/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.inventory.CommonFluid;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class ClientBackpackTooltipComponent
implements ClientTooltipComponent {
    private final BackpackTooltipComponent component;

    public ClientBackpackTooltipComponent(BackpackTooltipComponent component) {
        this.component = component;
    }

    public int getHeight(Font p_365134_) {
        int height = 0;
        if (KeyHelper.isCtrlPressed()) {
            if (!this.component.leftFluidStack.isEmpty()) {
                height += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                height += 10;
            }
            if (!this.component.upgrades.isEmpty()) {
                height += 18;
            }
            if (!this.component.storage.isEmpty()) {
                height += (int)(Math.ceil((float)this.component.storage.size() / 9.0f) * 18.0);
            }
            if (!this.component.tools.isEmpty()) {
                height += 18;
            }
        }
        return height;
    }

    public int getWidth(Font font) {
        int width = 0;
        int textWidth = 0;
        if (KeyHelper.isCtrlPressed()) {
            if (!this.component.storage.isEmpty()) {
                width += Math.min(this.component.storage.size(), 9) * 18 + Math.min(this.component.storage.size(), 9) * 2;
            }
            if (!this.component.leftFluidStack.isEmpty()) {
                textWidth = font.width((FormattedText)this.getFluidTankTooltip(this.component.leftFluidStack));
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                textWidth = Math.max(font.width((FormattedText)this.getFluidTankTooltip(this.component.rightFluidStack)), textWidth);
            }
            if (textWidth > width) {
                width = textWidth;
            }
        }
        return width;
    }

    public void renderText(GuiGraphics guiGraphics, Font pFont, int pMouseX, int pMouseY) {
        if (KeyHelper.isCtrlPressed()) {
            int yOffset = 0;
            if (!this.component.leftFluidStack.isEmpty()) {
                this.renderFluidTankTooltip(this.component.leftFluidStack, guiGraphics, pFont, pMouseX, pMouseY);
                yOffset += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                this.renderFluidTankTooltip(this.component.rightFluidStack, guiGraphics, pFont, pMouseX, pMouseY + yOffset);
            }
        }
    }

    public void renderImage(Font pFont, int pX, int pY, int k, int k1, GuiGraphics pGuiGraphics) {
        int yOffset = 0;
        if (KeyHelper.isCtrlPressed()) {
            int i;
            if (!this.component.leftFluidStack.isEmpty()) {
                yOffset += 10;
            }
            if (!this.component.rightFluidStack.isEmpty()) {
                yOffset += 10;
            }
            boolean flag = false;
            if (!this.component.upgrades.isEmpty()) {
                flag = true;
                for (i = 0; i < this.component.upgrades.size(); ++i) {
                    this.renderItem(this.component.upgrades.get(i), pX + i * 18, pY + yOffset, pFont, pGuiGraphics);
                }
            }
            if (!this.component.storage.isEmpty()) {
                int j = 0;
                if (flag) {
                    yOffset += 18;
                }
                flag = true;
                for (int i2 = 0; i2 < this.component.storage.size(); ++i2) {
                    this.renderItem(this.component.storage.get(i2), pX + j * 2 + j * 18, pY + yOffset, pFont, pGuiGraphics);
                    if (j < 8) {
                        ++j;
                        continue;
                    }
                    j = 0;
                    yOffset += 18;
                }
            }
            if (!this.component.tools.isEmpty()) {
                if (flag) {
                    yOffset += 18;
                }
                for (i = 0; i < this.component.tools.size(); ++i) {
                    this.renderItem(this.component.tools.get(i), pX + i * 18, pY + yOffset, pFont, pGuiGraphics);
                }
            }
        }
    }

    private void renderItem(ItemStack stack, int pX, int pY, Font pFont, GuiGraphics guiGraphics) {
        guiGraphics.renderFakeItem(stack, pX, pY);
        guiGraphics.renderItemDecorations(pFont, stack, pX, pY);
    }

    public Component getFluidTankTooltip(FluidStack fluidStack) {
        Component c = CommonFluid.getFluidName(fluidStack);
        MutableComponent c1 = Component.literal((String)": ");
        MutableComponent c2 = Component.literal((String)(fluidStack.getAmount() + "mB")).withStyle(ChatFormatting.BLUE);
        return MutableComponent.create((ComponentContents)c.getContents()).append((Component)c1).append((Component)c2);
    }

    public void renderFluidTankTooltip(FluidStack fluidStack, GuiGraphics guiGraphics, Font font, int mouseX, int mouseY) {
        guiGraphics.drawString(font, this.getFluidTankTooltip(fluidStack), mouseX, mouseY, -1);
    }
}

