/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.screens.AbstractBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;

public class SettingsWidget
extends WidgetBase<AbstractBackpackScreen<?>> {
    private final Point tabUvOpen = new Point(42, 0);
    private final Point tabUvReturn = new Point(42, 18);
    private final boolean isSettingsScreen;

    public SettingsWidget(AbstractBackpackScreen<?> screen, Point pos, boolean isSettingsScreen) {
        super(screen, pos, 24, 24);
        this.isSettingsScreen = isSettingsScreen;
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x(), this.pos.y(), (float)this.emptyTabUv.x(), (float)this.emptyTabUv.y(), this.width, this.height, 256, 256);
        if (this.isSettingsScreen) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 3, this.pos.y() + 3, (float)this.tabUvReturn.x(), (float)this.tabUvReturn.y(), this.iconSize.x(), this.iconSize.y(), 256, 256);
        } else {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 3, this.pos.y() + 3, (float)this.tabUvOpen.x(), (float)this.tabUvOpen.y(), this.iconSize.x(), this.iconSize.y(), 256, 256);
        }
    }

    public int getSettingsUser() {
        BlockPos pos;
        if (this.screen.getWrapper().getScreenID() == 3 && (pos = this.screen.getWrapper().getBackpackPos()) != null) {
            return ((BackpackBlockEntity)this.screen.getScreenPlayer().level().getBlockEntity(pos)).getSettingsUser();
        }
        return -1;
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.isSettingsScreen) {
                guiGraphics.setTooltipForNextFrame(this.screen.getScreenFont(), (Component)Component.translatable((String)"screen.travelersbackpack.settings_back"), mouseX, mouseY);
            } else {
                if (this.screen.getWrapper().getScreenID() != 3) {
                    if (!this.screen.getWrapper().isOwner(this.screen.getScreenPlayer())) {
                        guiGraphics.setTooltipForNextFrame(this.screen.getScreenFont(), (Component)Component.translatable((String)"screen.travelersbackpack.settings_owner"), mouseX, mouseY);
                        return;
                    }
                } else if (this.getSettingsUser() != -1) {
                    guiGraphics.setTooltipForNextFrame(this.screen.getScreenFont(), (Component)Component.translatable((String)"screen.travelersbackpack.settings_other_player"), mouseX, mouseY);
                    return;
                }
                guiGraphics.setTooltipForNextFrame(this.screen.getScreenFont(), (Component)Component.translatable((String)"screen.travelersbackpack.settings"), mouseX, mouseY);
            }
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.screen.getWrapper().getScreenID() != 3 && !this.screen.getWrapper().isOwner(this.screen.getScreenPlayer())) {
            return false;
        }
        if (this.screen.getWrapper().getScreenID() == 3 && this.getSettingsUser() != -1 && !this.isSettingsScreen) {
            return false;
        }
        if (this.isMouseOver(pMouseX, pMouseY)) {
            if (this.isSettingsScreen) {
                this.screen.sendDataToServer();
                ServerboundActionTagPacket.create(10, this.screen.getScreenPlayer().getId(), false);
            } else {
                ServerboundActionTagPacket.create(10, this.screen.getScreenPlayer().getId(), true);
            }
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }
}

