/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets.settings;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.SupporterBadgePacket;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class SupporterBadgeWidget
extends SettingsWidgetBase {
    private final Point iconUv = new Point(132, 72);
    private final Point iconEnabledUv = new Point(132, 54);

    public SupporterBadgeWidget(BackpackSettingsScreen screen, Point pos) {
        super(screen, pos, new Point(24, 24));
    }

    public void sendDataToServer() {
        boolean showSupporterStar = (Boolean)TravelersBackpackConfig.CLIENT.showSupporterBadge.get();
        TravelersBackpackConfig.CLIENT.showSupporterBadge.set((Object)(!showSupporterStar ? 1 : 0));
        TravelersBackpackConfig.CLIENT.showSupporterBadge.save();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SupporterBadgePacket.Serverbound(!showSupporterStar), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        Point uv = (Boolean)TravelersBackpackConfig.CLIENT.showSupporterBadge.get() != false ? this.iconEnabledUv : this.iconUv;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x(), this.pos.y(), (float)this.emptyTabUv.x(), (float)this.emptyTabUv.y(), this.width, this.height, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 3, this.pos.y() + 3, (float)uv.x(), (float)uv.y(), this.iconSize.x(), this.iconSize.y(), 256, 256);
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOverIcon(mouseX, mouseY)) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"screen.travelersbackpack.toggle_supporter_badge_visibility"));
            tooltip.add(Component.literal((String)"Thanks for your support! :) - Tiviacz1337"));
            guiGraphics.setTooltipForNextFrame(((BackpackSettingsScreen)this.screen).getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isMouseOverIcon(pMouseX, pMouseY)) {
            this.sendDataToServer();
            ((BackpackSettingsScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }
}

