/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets.settings;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundSlotPacket;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class UnsortablesWidget
extends SettingsWidgetBase {
    private final WidgetElement selectAllButton = new WidgetElement(new Point(6, 22), new Point(18, 18));
    private final WidgetElement removeAllButton = new WidgetElement(new Point(24, 22), new Point(18, 18));
    private final Point openTabUv = new Point(0, 72);
    private final Point iconUv = new Point(60, 0);
    private final Point iconHighlightedUv = new Point(60, 18);

    public UnsortablesWidget(BackpackSettingsScreen screen, Point pos) {
        super(screen, pos, new Point(48, 46));
    }

    public boolean isTabOpened() {
        return this.tabOpened;
    }

    public void sendDataToServer() {
        if (!((BackpackSettingsScreen)this.screen).unsortableSlots.equals(((BackpackSettingsScreen)this.screen).lastUnsortableSlots)) {
            Collections.sort(((BackpackSettingsScreen)this.screen).unsortableSlots);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSlotPacket(0, ((BackpackSettingsScreen)this.screen).unsortableSlots, List.of()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((BackpackSettingsScreen)this.screen).lastUnsortableSlots.clear();
            ((BackpackSettingsScreen)this.screen).lastUnsortableSlots.addAll(((BackpackSettingsScreen)this.screen).unsortableSlots);
        }
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.tabOpened) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.TABS, this.pos.x(), this.pos.y(), (float)this.openTabUv.x(), (float)this.openTabUv.y(), this.openTabSize.x(), this.openTabSize.y(), 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 3, this.pos.y() + 3, (float)this.iconHighlightedUv.x(), (float)this.iconHighlightedUv.y(), this.iconSize.x(), this.iconSize.y(), 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + this.selectAllButton.pos().x(), this.pos.y() + this.selectAllButton.pos().y(), 132.0f, 18.0f, this.selectAllButton.size().x(), this.selectAllButton.size().y(), 256, 256);
            if (this.isMouseOverSelectAllButton(mouseX, mouseY)) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + this.selectAllButton.pos().x(), this.pos.y() + this.selectAllButton.pos().y(), 24.0f, 18.0f, this.selectAllButton.size().x(), this.selectAllButton.size().y(), 256, 256);
            }
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + this.removeAllButton.pos().x(), this.pos.y() + this.removeAllButton.pos().y(), 132.0f, 36.0f, this.removeAllButton.size().x(), this.removeAllButton.size().y(), 256, 256);
            if (this.isMouseOverRemoveAllButton(mouseX, mouseY)) {
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + this.removeAllButton.pos().x(), this.pos.y() + this.removeAllButton.pos().y(), 24.0f, 18.0f, this.removeAllButton.size().x(), this.removeAllButton.size().y(), 256, 256);
            }
        } else {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x(), this.pos.y(), (float)this.emptyTabUv.x(), (float)this.emptyTabUv.y(), this.width, this.height, 256, 256);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, BackpackScreen.ICONS, this.pos.x() + 3, this.pos.y() + 3, (float)this.iconUv.x(), (float)this.iconUv.y(), this.iconSize.x(), this.iconSize.y(), 256, 256);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOverIcon(mouseX, mouseY) || this.tabOpened && (this.isMouseOverSelectAllButton(mouseX, mouseY) || this.isMouseOverRemoveAllButton(mouseX, mouseY))) {
            ArrayList<Component> components = new ArrayList<Component>(TextUtils.getTranslatedSplittedText("screen.travelersbackpack.unsortable", null));
            if (this.tabOpened && this.isMouseOverSelectAllButton(mouseX, mouseY)) {
                components.add((Component)Component.translatable((String)"screen.travelersbackpack.select_all"));
            }
            if (this.tabOpened && this.isMouseOverRemoveAllButton(mouseX, mouseY)) {
                components.add((Component)Component.translatable((String)"screen.travelersbackpack.remove_all"));
            }
            guiGraphics.setComponentTooltipForNextFrame(((BackpackSettingsScreen)this.screen).getFont(), components, mouseX, mouseY);
        }
    }

    public boolean isMouseOverSelectAllButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.selectAllButton);
    }

    public boolean isMouseOverRemoveAllButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.removeAllButton);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isTabOpened()) {
            if (this.isMouseOverSelectAllButton(pMouseX, pMouseY)) {
                for (int i = 0; i < ((BackpackSettingsScreen)this.screen).getWrapper().getStorage().getSlots(); ++i) {
                    ((BackpackSettingsScreen)this.screen).unsortableSlots.add(i);
                }
                ((BackpackSettingsScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.isMouseOverRemoveAllButton(pMouseX, pMouseY)) {
                ((BackpackSettingsScreen)this.screen).unsortableSlots.clear();
                ((BackpackSettingsScreen)this.screen).playUIClickSound();
                return true;
            }
        }
        if (this.isMouseOverIcon(pMouseX, pMouseY)) {
            this.tabOpened = !this.tabOpened;
            ((BackpackSettingsScreen)this.screen).updateWidgetsPosition(this);
            if (!this.tabOpened) {
                this.sendDataToServer();
            }
            ((BackpackSettingsScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }

    @Override
    public int[] getWidgetSizeAndPos() {
        int[] size = new int[]{this.pos.x(), this.pos.y(), this.tabOpened ? this.openTabSize.x() : this.width, this.tabOpened ? this.openTabSize.y() : this.height};
        return size;
    }
}

