/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.mojang.serialization.DynamicOps;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.Nullable;

public class BackpackManager {
    public static LevelResource BACKPACKS = new LevelResource("backpacks");

    public static void addBackpack(ServerPlayer player, ItemStack stack) {
        try {
            LocalDateTime deathTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy-HH.mm.ss");
            String formattedDeathTime = deathTime.format(formatter);
            String datedBackpackName = stack.getItemHolder().getRegisteredName().replace(":", ".") + "_" + formattedDeathTime + ".dat";
            File backpackFile = BackpackManager.getBackpackFile(player, datedBackpackName);
            backpackFile.getParentFile().mkdirs();
            CompoundTag stackTag = (CompoundTag)ItemStack.CODEC.encodeStart((DynamicOps)player.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack).result().orElseGet(CompoundTag::new);
            NbtIo.write((CompoundTag)stackTag, (Path)backpackFile.toPath());
            LogHelper.info("Created new backpack backup file for " + player.getDisplayName().getString() + " with unique ID " + datedBackpackName, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ItemStack readBackpack(ServerLevel serverLevel, UUID playerUUID, String backpackId) {
        try {
            CompoundTag data = NbtIo.read((Path)BackpackManager.getBackpackFile(serverLevel, playerUUID, backpackId).toPath());
            if (data == null) {
                return null;
            }
            return ItemStack.CODEC.parse((DynamicOps)serverLevel.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)data).result().orElse(ItemStack.EMPTY);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static ItemStack getBackpack(ServerLevel serverLevel, String backpackId) {
        File deathFolder = BackpackManager.getBackpackFolder(serverLevel);
        File[] players = deathFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"));
        if (players == null) {
            return null;
        }
        for (File f : players) {
            File[] files;
            if (!f.isDirectory() || (files = f.listFiles((dir, name) -> name.equals(backpackId))) == null || files.length <= 0) continue;
            return BackpackManager.readBackpack(serverLevel, UUID.fromString(f.getName()), backpackId);
        }
        return null;
    }

    public static File getBackpackFile(ServerLevel serverLevel, UUID playerUUID, String backpackId) {
        return new File(BackpackManager.getPlayerBackpackFolder(serverLevel, playerUUID), backpackId);
    }

    public static File getBackpackFile(ServerPlayer player, String backpackId) {
        return new File(BackpackManager.getPlayerBackpackFolder(player), backpackId);
    }

    public static File getPlayerBackpackFolder(ServerPlayer player) {
        return BackpackManager.getPlayerBackpackFolder(player.level(), player.getUUID());
    }

    public static File getPlayerBackpackFolder(ServerLevel serverLevel, UUID uuid) {
        return new File(BackpackManager.getBackpackFolder(serverLevel), uuid.toString());
    }

    public static File getBackpackFolder(ServerLevel serverLevel) {
        return BackpackManager.getWorldFolder(serverLevel, BACKPACKS);
    }

    public static File getWorldFolder(ServerLevel serverLevel, LevelResource path) {
        return serverLevel.getServer().getWorldPath(path).toFile();
    }
}

