/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.advancements.ActionTypeTrigger;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.handlers.NeoForgeEventHandler;
import com.tiviacz.travelersbackpack.init.ModAdvancements;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.BackpackSettingsContainer;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.ContainerSorter;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownLingeringPotion;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ServerActions {
    public static final int TAB_OPEN = 0;
    public static final int UPGRADE_ENABLED = 1;
    public static final int SHIFT_CLICK_TO_BACKPACK = 2;
    public static final int PLAY_RECORD = 3;

    public static void swapTool(Player player, double scrollDelta) {
        if (AttachmentUtils.isWearingBackpack(player)) {
            int i;
            BackpackWrapper wrapper = AttachmentUtils.getBackpackWrapper(player, AttachmentUtils.TOOLS_ONLY);
            ItemStackHandler inv = wrapper.getTools();
            if (InventoryHelper.isEmpty(inv)) {
                return;
            }
            int toolSlots = inv.getSlots();
            int lastSlot = toolSlots - 1;
            int j = 0;
            for (int i2 = 0; i2 <= lastSlot; ++i2) {
                if (inv.getStackInSlot(i2).isEmpty()) continue;
                ++j;
            }
            ItemStack[] tools = new ItemStack[j];
            int slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                tools[slot] = inv.getStackInSlot(i).copy();
                ++slot;
            }
            ServerActions.swapTool(scrollDelta, tools, player);
            slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                inv.setStackInSlot(i, tools[slot]);
                ++slot;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((ActionTypeTrigger)((Object)ModAdvancements.ACTION_TRIGGER.get())).trigger(serverPlayer, "swap_tools");
            }
            wrapper.sendDataToClients((DataComponentType)ModDataComponents.TOOLS_CONTAINER.get());
        }
    }

    public static void swapTool(double delta, ItemStack[] tools, Player player) {
        int i;
        ItemStack tempStack;
        if (delta > 0.0) {
            tempStack = tools[0];
            for (i = 0; i <= tools.length - 1; ++i) {
                if (i + 1 > tools.length - 1) {
                    tools[tools.length - 1] = player.getMainHandItem();
                    player.setItemInHand(InteractionHand.MAIN_HAND, tempStack);
                    continue;
                }
                tools[i] = tools[i + 1];
            }
        }
        if (delta < 0.0) {
            tempStack = tools[tools.length - 1];
            for (i = tools.length - 1; i >= 0; --i) {
                if (i - 1 < 0) {
                    tools[0] = player.getMainHandItem();
                    player.setItemInHand(InteractionHand.MAIN_HAND, tempStack);
                    continue;
                }
                tools[i] = tools[i - 1];
            }
        }
    }

    public static void equipBackpack(Player player, boolean equip) {
        if (equip) {
            ServerActions.handleEquipBackpack(player);
        } else {
            ServerActions.handleUnequipBackpack(player);
        }
    }

    public static boolean swapBackpack(Player player) {
        Level level = player.level();
        if (level.isClientSide || !AttachmentUtils.isWearingBackpack(player)) {
            return false;
        }
        if (player.containerMenu instanceof BackpackItemMenu) {
            player.closeContainer();
        }
        ItemStack equippedBackpack = AttachmentUtils.getWearingBackpack(player).copy();
        ItemStack newBackpack = player.getMainHandItem().copy();
        AttachmentUtils.getAttachment(player).ifPresent(attachment -> {
            attachment.equipBackpack(newBackpack);
            attachment.synchronise();
        });
        NeoForgeEventHandler.runAbilitiesRemoval(player);
        player.getMainHandItem().shrink(1);
        player.getInventory().add(equippedBackpack);
        return true;
    }

    public static boolean equipBackpack(Player player) {
        Level level = player.level();
        if (level.isClientSide) {
            return false;
        }
        if (AttachmentUtils.isWearingBackpack(player)) {
            return ServerActions.swapBackpack(player);
        }
        if (player.containerMenu instanceof BackpackItemMenu) {
            player.closeContainer();
        }
        ItemStack stack = player.getMainHandItem().copy();
        AttachmentUtils.getAttachment(player).ifPresent(attachment -> {
            attachment.equipBackpack(stack);
            attachment.synchronise();
        });
        player.getMainHandItem().shrink(1);
        return true;
    }

    public static void handleEquipBackpack(Player player) {
        if (!ServerActions.equipBackpack(player)) {
            return;
        }
        ServerActions.playEquippingSound(player);
    }

    public static boolean unequipBackpack(Player player) {
        Level level = player.level();
        if (level.isClientSide || !AttachmentUtils.isWearingBackpack(player)) {
            return false;
        }
        if (player.containerMenu instanceof BackpackItemMenu) {
            player.closeContainer();
        }
        ItemStack backpack = AttachmentUtils.getWearingBackpack(player).copy();
        if (!player.getInventory().add(backpack)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"action.travelersbackpack.unequip_nospace"));
            }
            return false;
        }
        AttachmentUtils.getAttachment(player).ifPresent(attachment -> {
            attachment.equipBackpack(new ItemStack((ItemLike)Items.AIR, 0));
            attachment.synchronise();
        });
        return true;
    }

    public static void handleUnequipBackpack(Player player) {
        if (!ServerActions.unequipBackpack(player)) {
            return;
        }
        ServerActions.playEquippingSound(player);
    }

    private static void playEquippingSound(Player player) {
        player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, (1.0f + (player.level().getRandom().nextFloat() - player.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
    }

    public static void openBackpackFromSlot(ServerPlayer player, int index, boolean fromSlot) {
        ItemStack backpackStack;
        if (index >= 0 && index < player.getInventory().getNonEquipmentItems().size() && (backpackStack = (ItemStack)player.getInventory().getNonEquipmentItems().get(index)).getItem() instanceof TravelersBackpackItem && !((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowOnlyEquippedBackpack.get()).booleanValue() && (!fromSlot || ((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowOpeningFromSlot.get()).booleanValue())) {
            BackpackContainer.openBackpack(player, backpackStack, 1, index);
        }
    }

    public static void openBackpackSettings(ServerPlayer player, int entityId, boolean open) {
        if (player.getId() == entityId) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof BackpackBaseMenu) {
                BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
                if (open) {
                    if (menu.getWrapper().getScreenID() == 3) {
                        BlockEntity blockEntity = player.level().getBlockEntity(menu.getWrapper().getBackpackPos());
                        if (blockEntity instanceof BackpackBlockEntity) {
                            backpackBlockEntity = (BackpackBlockEntity)blockEntity;
                            ((BackpackBlockEntity)((Object)backpackBlockEntity)).openSettings((Player)player, (MenuProvider)backpackBlockEntity, menu.getWrapper().getBackpackPos());
                        }
                    } else {
                        BackpackSettingsContainer.openSettings(player, menu.getWrapper().getBackpackStack(), menu.getWrapper().getScreenID(), menu.getWrapper().getBackpackSlotIndex());
                    }
                }
            } else {
                backpackBlockEntity = player.containerMenu;
                if (backpackBlockEntity instanceof BackpackSettingsMenu) {
                    BackpackSettingsMenu menu = (BackpackSettingsMenu)((Object)backpackBlockEntity);
                    if (!open) {
                        if (menu.getWrapper().getScreenID() == 3) {
                            BlockEntity blockEntity = player.level().getBlockEntity(menu.getWrapper().getBackpackPos());
                            if (blockEntity instanceof BackpackBlockEntity) {
                                backpackBlockEntity = (BackpackBlockEntity)blockEntity;
                                ((BackpackBlockEntity)((Object)backpackBlockEntity)).openBackpack((Player)player, (MenuProvider)backpackBlockEntity, menu.getWrapper().getBackpackPos());
                            }
                        } else {
                            BackpackContainer.openBackpack(player, menu.getWrapper().getBackpackStack(), menu.getWrapper().getScreenID(), menu.getWrapper().getBackpackSlotIndex());
                        }
                    }
                }
            }
        }
    }

    public static void modifyUpgradeTab(ServerPlayer player, int slot, boolean open, int packetType) {
        BackpackBaseMenu menu;
        ItemStack upgradeStack;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BackpackBaseMenu && !(upgradeStack = (menu = (BackpackBaseMenu)abstractContainerMenu).getWrapper().getUpgrades().getStackInSlot(slot)).isEmpty()) {
            ItemStack updateStack = upgradeStack.copy();
            updateStack.set(ServerActions.getPacketType(packetType), (Object)open);
            menu.getWrapper().getUpgrades().setStackInSlot(slot, updateStack);
            if (packetType == 1 && menu.getWrapper().getUpgradeManager().hasUpgradeInSlot(slot)) {
                ((Optional)menu.getWrapper().getUpgradeManager().mappedUpgrades.get((Object)slot)).ifPresent(upgradeBase -> {
                    if (upgradeBase instanceof IEnable) {
                        IEnable upg = (IEnable)((Object)upgradeBase);
                        upg.setEnabled(open);
                    }
                });
            }
        }
    }

    public static DeferredHolder<DataComponentType<?>, DataComponentType<Boolean>> getPacketType(int type) {
        return switch (type) {
            case 0 -> ModDataComponents.TAB_OPEN;
            case 1 -> ModDataComponents.UPGRADE_ENABLED;
            case 2 -> ModDataComponents.SHIFT_CLICK_TO_BACKPACK;
            case 3 -> ModDataComponents.IS_PLAYING;
            default -> ModDataComponents.TAB_OPEN;
        };
    }

    public static void removeBackpackUpgrade(ServerPlayer player, int slot) {
        BackpackBaseMenu menu;
        BackpackWrapper wrapper;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BackpackBaseMenu && !(wrapper = (menu = (BackpackBaseMenu)abstractContainerMenu).getWrapper()).getUpgrades().getStackInSlot(slot).isEmpty()) {
            Optional upgrade = (Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)slot);
            ItemStack upgradeStack = wrapper.getUpgrades().getStackInSlot(slot).copy();
            upgradeStack.set(ModDataComponents.TAB_OPEN, (Object)false);
            wrapper.getUpgrades().setStackInSlot(slot, ItemStack.EMPTY);
            upgrade.ifPresent(upgradeBase -> upgradeBase.onUpgradeRemoved(upgradeStack));
            if (!player.getInventory().add(upgradeStack)) {
                player.drop(upgradeStack, true);
            }
            wrapper.saveHandler.run();
        }
    }

    public static void switchAbilitySlider(ServerPlayer player, boolean sliderValue) {
        BackpackWrapper wrapper = AttachmentUtils.getBackpackWrapperArtificial((Player)player);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
            wrapper = menu.getWrapper();
        }
        wrapper.setDataAndSync((DataComponentType)ModDataComponents.ABILITY_ENABLED.get(), sliderValue);
        if (wrapper.getBackpackOwner() != null) {
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, wrapper.getBackpackStack()) && !sliderValue) {
                BackpackAbilities.ABILITIES.abilityRemoval(wrapper.getBackpackStack(), wrapper.getBackpackOwner());
            }
            if (wrapper.getBackpackStack().getItem() == ModItems.CHICKEN_TRAVELERS_BACKPACK.get() && wrapper.getCooldown() <= 0) {
                BackpackAbilities.ABILITIES.chickenAbility(wrapper.getBackpackStack(), wrapper.getBackpackOwner(), true);
            }
        }
    }

    public static void showToolSlots(ServerPlayer player, boolean show) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
            menu.getWrapper().setDataAndSync((DataComponentType)ModDataComponents.SHOW_TOOL_SLOTS.get(), show);
        }
    }

    public static void sortBackpack(Player player, int button, boolean shiftPressed) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
            ContainerSorter.selectSort(menu.getWrapper(), player, button, shiftPressed);
        }
    }

    public static void toggleVisibility(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BackpackSettingsMenu) {
            BackpackSettingsMenu menu = (BackpackSettingsMenu)abstractContainerMenu;
            boolean visibility = (Boolean)menu.getWrapper().getBackpackStack().getOrDefault(ModDataComponents.IS_VISIBLE, (Object)true);
            menu.getWrapper().setDataAndSync((DataComponentType)ModDataComponents.IS_VISIBLE.get(), !visibility);
        }
    }

    public static void toggleButtonsVisibility(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)abstractContainerMenu;
            boolean current = menu.getWrapper().showMoreButtons();
            menu.getWrapper().setDataAndSync((DataComponentType)ModDataComponents.SHOW_MORE_BUTTONS.get(), !current);
        }
    }

    public static void toggleSleepingBag(Player player, BlockPos pos, boolean isEquipped) {
        Level level = player.level();
        if (isEquipped) {
            BlockPos sleepingBagPos2;
            BlockPos sleepingBagPos1 = pos.relative(player.getDirection());
            boolean canPlace = ServerActions.placeAndUseSleepingBag(player, sleepingBagPos1, sleepingBagPos2 = sleepingBagPos1.relative(player.getDirection()), pos, level, player.getDirection());
            if (!canPlace) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"action.travelersbackpack.deploy_sleeping_bag"));
                }
                player.closeContainer();
                return;
            }
            if (!level.isClientSide && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                player.startSleepInBed(pos.relative(player.getDirection()).relative(player.getDirection())).ifLeft(bedSleepingProblem -> {
                    if (bedSleepingProblem.getMessage() != null) {
                        player.displayClientMessage(bedSleepingProblem.getMessage(), true);
                        if (level.getBlockState(sleepingBagPos1).getBlock() instanceof SleepingBagBlock) {
                            level.setBlockAndUpdate(sleepingBagPos1, Blocks.AIR.defaultBlockState());
                        }
                        if (level.getBlockState(sleepingBagPos2).getBlock() instanceof SleepingBagBlock) {
                            level.setBlockAndUpdate(sleepingBagPos2, Blocks.AIR.defaultBlockState());
                        }
                    }
                });
                ((ActionTypeTrigger)((Object)ModAdvancements.ACTION_TRIGGER.get())).trigger(serverPlayer, "use_sleeping_bag");
                player.closeContainer();
            }
        } else {
            BlockEntity sleepingBagPos2 = level.getBlockEntity(pos);
            if (sleepingBagPos2 instanceof BackpackBlockEntity) {
                BackpackBlockEntity blockEntity = (BackpackBlockEntity)sleepingBagPos2;
                if (!blockEntity.isSleepingBagDeployed()) {
                    if (!blockEntity.deploySleepingBag(level, pos) && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.sendSystemMessage((Component)Component.translatable((String)"action.travelersbackpack.deploy_sleeping_bag"));
                    }
                } else {
                    blockEntity.removeSleepingBag(level, blockEntity.getBlockDirection());
                }
                if (!level.isClientSide) {
                    player.closeContainer();
                }
            }
        }
    }

    public static boolean placeAndUseSleepingBag(Player player, BlockPos sleepingBagPos1, BlockPos sleepingBagPos2, BlockPos pos, Level level, Direction direction) {
        if (!player.onGround() || level.getBlockState(sleepingBagPos1.below()).isAir() || level.getBlockState(sleepingBagPos1.below()).getBlock() instanceof LiquidBlock || !BedBlock.canSetSpawn((Level)level)) {
            return false;
        }
        ItemStack backpack = AttachmentUtils.getWearingBackpack(player);
        if (BackpackBlockEntity.canPlaceSleepingBag(sleepingBagPos2, level) && BackpackBlockEntity.canPlaceSleepingBag(sleepingBagPos1, level)) {
            level.playSound(null, sleepingBagPos2, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 0.5f, 1.0f);
            if (!level.isClientSide) {
                BlockState sleepingBagState = BackpackBlockEntity.getProperSleepingBag((Integer)backpack.getOrDefault((DataComponentType)ModDataComponents.SLEEPING_BAG_COLOR.get(), (Object)DyeColor.RED.getId()));
                level.setBlock(sleepingBagPos1, (BlockState)((BlockState)((BlockState)sleepingBagState.setValue((Property)SleepingBagBlock.FACING, (Comparable)direction)).setValue(SleepingBagBlock.PART, (Comparable)BedPart.FOOT)).setValue((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.setBlock(sleepingBagPos2, (BlockState)((BlockState)((BlockState)sleepingBagState.setValue((Property)SleepingBagBlock.FACING, (Comparable)direction)).setValue(SleepingBagBlock.PART, (Comparable)BedPart.HEAD)).setValue((Property)SleepingBagBlock.CAN_DROP, (Comparable)Boolean.valueOf(false)), 3);
                level.updateNeighborsAt(pos, sleepingBagState.getBlock());
                level.updateNeighborsAt(sleepingBagPos2, sleepingBagState.getBlock());
            }
            return true;
        }
        return false;
    }

    public static int throwPotion(Level level, Player player, ItemStack potionStack, boolean isSplash) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), isSplash ? SoundEvents.SPLASH_POTION_THROW : SoundEvents.LINGERING_POTION_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Projectile.spawnProjectileFromRotation((Projectile.ProjectileFactory)(isSplash ? ThrownSplashPotion::new : ThrownLingeringPotion::new), (ServerLevel)serverlevel, (ItemStack)potionStack, (LivingEntity)player, (float)-20.0f, (float)ThrowablePotionItem.PROJECTILE_SHOOT_POWER, (float)1.0f);
        }
        if (!player.getAbilities().instabuild) {
            return 250;
        }
        return 0;
    }

    public static boolean setFluidEffect(Level level, Player player, FluidTank tank) {
        FluidStack fluidStack = tank.getFluid();
        boolean done = false;
        if (EffectFluidRegistry.hasExecutableEffects(fluidStack, level, (Entity)player)) {
            done = EffectFluidRegistry.executeEffects(fluidStack, (Entity)player, level);
        }
        return done;
    }

    public static void switchHoseMode(Player player, double scrollDelta) {
        ItemStack hose = player.getMainHandItem();
        if (hose.getItem() instanceof HoseItem) {
            List settings = (List)hose.getOrDefault(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if (scrollDelta > 0.0) {
                int nextMode = (Integer)settings.get(0) + 1;
                hose.set(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(nextMode == 4 ? 1 : nextMode), (Integer)settings.get(1)));
            } else if (scrollDelta < 0.0) {
                int nextMode = (Integer)settings.get(0) - 1;
                hose.set(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(nextMode == 0 ? 3 : nextMode), (Integer)settings.get(1)));
            }
        }
        if (!player.level().isClientSide) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientboundSyncItemStackPacket(player.getId(), player.getInventory().getSelectedSlot(), hose, ItemStackUtils.createDataComponentMap(hose, (DataComponentType)ModDataComponents.HOSE_MODES.get())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void toggleHoseTank(Player player) {
        ItemStack hose = player.getMainHandItem();
        if (hose.getItem() instanceof HoseItem) {
            List settings = (List)hose.getOrDefault(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if ((Integer)settings.get(1) == 1) {
                hose.set(ModDataComponents.HOSE_MODES, List.of((Integer)settings.get(0), Integer.valueOf(2)));
            } else {
                hose.set(ModDataComponents.HOSE_MODES, List.of((Integer)settings.get(0), Integer.valueOf(1)));
            }
        }
        if (!player.level().isClientSide) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientboundSyncItemStackPacket(player.getId(), player.getInventory().getSelectedSlot(), hose, ItemStackUtils.createDataComponentMap(hose, (DataComponentType)ModDataComponents.HOSE_MODES.get())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

