/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.accessories;

import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.SyncContainerData;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AccessoriesPacketSender {
    public static void sendSyncingPacketForBackpack(ServerPlayer player) {
        if (player.level().isClientSide) {
            return;
        }
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability != null) {
            HashMap<CallSite, ItemStack> dirtyStacks = new HashMap<CallSite, ItemStack>();
            HashMap<CallSite, ItemStack> dirtyCosmeticStacks = new HashMap<CallSite, ItemStack>();
            for (Map.Entry containerEntry : AccessoriesHolderImpl.getHolder((AccessoriesCapability)capability).getAllSlotContainers().entrySet()) {
                AccessoriesContainer container = (AccessoriesContainer)containerEntry.getValue();
                ExpandedContainer accessories = container.getAccessories();
                ExpandedContainer cosmetics = container.getCosmeticAccessories();
                for (int i = 0; i < accessories.getContainerSize(); ++i) {
                    ItemStack currentCosmeticStack;
                    String slotId = container.getSlotName() + "/" + i;
                    ItemStack currentStack = accessories.getItem(i);
                    if (currentStack.getItem() instanceof TravelersBackpackItem) {
                        dirtyStacks.put((CallSite)((Object)slotId), currentStack.copy());
                    }
                    if (!((currentCosmeticStack = cosmetics.getItem(i)).getItem() instanceof TravelersBackpackItem)) continue;
                    dirtyCosmeticStacks.put((CallSite)((Object)slotId), currentCosmeticStack.copy());
                }
            }
            if (!dirtyStacks.isEmpty() || !dirtyCosmeticStacks.isEmpty()) {
                SyncContainerData packet = SyncContainerData.of((LivingEntity)player, capability.getContainers().values(), dirtyStacks, dirtyCosmeticStacks);
                AccessoriesNetworking.sendToTrackingAndSelf((Entity)player, (Record)packet);
            }
        }
    }
}

