/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.curios;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public record TravelersBackpackCurio(ItemStack stack) implements ICurio
{
    public static void registerCurio(RegisterCapabilitiesEvent event) {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> {
            ItemLike[] itemLikeArray = new ItemLike[1];
            itemLikeArray[0] = () -> ((DeferredHolder)holder).get();
            event.registerItem(CuriosCapability.ITEM, (stack, context) -> new TravelersBackpackCurio((ItemStack)stack), itemLikeArray);
        });
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean canEquip(SlotContext context) {
        return (Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backSlotIntegration.get();
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return false;
    }

    public void curioTick(SlotContext slotContext) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.backSlotIntegration.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BackpackWrapper.tick(this.stack, player, true);
        }
    }
}

