/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.datagen;

import com.tiviacz.travelersbackpack.common.recipes.BackpackUpgradeRecipeBuilder;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipeBuilder;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class ModRecipeProvider
extends RecipeProvider {
    public static final Item[] BACKPACKS = new Item[]{(Item)ModItems.STANDARD_TRAVELERS_BACKPACK.get(), (Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get(), (Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.COAL_TRAVELERS_BACKPACK.get(), (Item)ModItems.QUARTZ_TRAVELERS_BACKPACK.get(), (Item)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get(), (Item)ModItems.END_TRAVELERS_BACKPACK.get(), (Item)ModItems.NETHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.SANDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.SNOW_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.HAY_TRAVELERS_BACKPACK.get(), (Item)ModItems.MELON_TRAVELERS_BACKPACK.get(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.DRAGON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get(), (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get(), (Item)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get(), (Item)ModItems.SKELETON_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPIDER_TRAVELERS_BACKPACK.get(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.WARDEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.BAT_TRAVELERS_BACKPACK.get(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get(), (Item)ModItems.WOLF_TRAVELERS_BACKPACK.get(), (Item)ModItems.FOX_TRAVELERS_BACKPACK.get(), (Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), (Item)ModItems.HORSE_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.PIG_TRAVELERS_BACKPACK.get(), (Item)ModItems.SHEEP_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.SQUID_TRAVELERS_BACKPACK.get(), (Item)ModItems.VILLAGER_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()};

    public ModRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
    }

    protected void buildRecipes() {
        for (Item item : BACKPACKS) {
            BackpackUpgradeRecipeBuilder.backpackUpgrade(this.ofTag((TagKey<Item>)Tags.Items.LEATHERS), Ingredient.of((ItemLike)item), Ingredient.of((HolderSet)this.registries.lookupOrThrow(Registries.ITEM).getOrThrow(ModTags.BACKPACK_UPGRADES)), RecipeCategory.MISC, item).unlocks(ModRecipeProvider.getHasName((ItemLike)item), this.has((ItemLike)item)).save(this.output, ModRecipeProvider.getItemName((ItemLike)item) + "_smithing");
        }
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get()), (int)4).define(Character.valueOf('A'), Tags.Items.LEATHERS).define(Character.valueOf('B'), Tags.Items.STRINGS).pattern(" B ").pattern("BAB").pattern(" B ").unlockedBy("has_leather", this.has(Tags.Items.LEATHERS)).save(this.output);
        this.createFullGrid((Item)ModItems.IRON_TIER_UPGRADE.get(), Ingredient.of((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get())), this.ofTag((TagKey<Item>)Tags.Items.INGOTS_IRON), Items.IRON_INGOT, (TagKey<Item>)Tags.Items.INGOTS_IRON).save(this.output);
        this.createFullGrid((Item)ModItems.GOLD_TIER_UPGRADE.get(), Ingredient.of((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get())), this.ofTag((TagKey<Item>)Tags.Items.INGOTS_GOLD), Items.GOLD_INGOT, (TagKey<Item>)Tags.Items.INGOTS_GOLD).save(this.output);
        this.createFullGrid((Item)ModItems.DIAMOND_TIER_UPGRADE.get(), Ingredient.of((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get())), this.ofTag((TagKey<Item>)Tags.Items.GEMS_DIAMOND), Items.DIAMOND, (TagKey<Item>)Tags.Items.GEMS_DIAMOND).save(this.output);
        this.createBackpackSmallGrid((Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), this.ofTag((TagKey<Item>)Tags.Items.GEMS_DIAMOND), ModRecipeProvider.getHasName((ItemLike)Items.DIAMOND), this.has(Tags.Items.GEMS_DIAMOND)).save(this.output);
        this.createBackpackSmallGrid((Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), this.ofTag((TagKey<Item>)Tags.Items.INGOTS_GOLD), ModRecipeProvider.getHasName((ItemLike)Items.GOLD_INGOT), this.has(Tags.Items.INGOTS_GOLD)).save(this.output);
        this.createBackpackSmallGrid((Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), this.ofTag((TagKey<Item>)Tags.Items.GEMS_EMERALD), ModRecipeProvider.getHasName((ItemLike)Items.EMERALD), this.has(Tags.Items.GEMS_EMERALD)).save(this.output);
        this.createBackpackSmallGrid((Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), this.ofTag((TagKey<Item>)Tags.Items.INGOTS_IRON), ModRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), this.has(Tags.Items.INGOTS_IRON)).save(this.output);
        this.createBackpackSmallGrid((Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get(), this.ofTag((TagKey<Item>)Tags.Items.ENDER_PEARLS), ModRecipeProvider.getHasName((ItemLike)Items.ENDER_PEARL), this.has(Tags.Items.ENDER_PEARLS)).save(this.output);
        this.createBackpackSmallGrid((Item)ModItems.WOLF_TRAVELERS_BACKPACK.get(), this.ofTag((TagKey<Item>)Tags.Items.BONES), ModRecipeProvider.getHasName((ItemLike)Items.BONE), this.has(Tags.Items.BONES)).save(this.output);
        this.createBackpackSmallGrid((Item)ModItems.FOX_TRAVELERS_BACKPACK.get(), Ingredient.of((ItemLike)Items.SWEET_BERRIES), ModRecipeProvider.getHasName((ItemLike)Items.SWEET_BERRIES), this.has((ItemLike)Items.SWEET_BERRIES)).save(this.output);
        this.createBackpackSmallGrid((Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), Ingredient.of((ItemLike)Items.COD), ModRecipeProvider.getHasName((ItemLike)Items.COD), this.has((ItemLike)Items.COD)).save(this.output);
        this.createBackpackFullGrid((Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), this.ofTag((TagKey<Item>)Tags.Items.DUSTS_REDSTONE), ModRecipeProvider.getHasName((ItemLike)Items.REDSTONE), this.has(Tags.Items.DUSTS_REDSTONE)).save(this.output);
        this.createBackpackFullGrid((Item)ModItems.COAL_TRAVELERS_BACKPACK.get(), this.ofTag((TagKey<Item>)ItemTags.COALS), ModRecipeProvider.getHasName((ItemLike)Items.COAL), this.has(ItemTags.COALS)).save(this.output);
        this.createBackpackFullGrid((Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), Ingredient.of((ItemLike)Items.SPONGE), ModRecipeProvider.getHasName((ItemLike)Items.SPONGE), this.has((ItemLike)Items.SPONGE)).save(this.output);
        this.createBackpackFullGrid((Item)ModItems.HAY_TRAVELERS_BACKPACK.get(), this.ofTag((TagKey<Item>)Tags.Items.CROPS_WHEAT), ModRecipeProvider.getHasName((ItemLike)Items.WHEAT), this.has(Tags.Items.CROPS_WHEAT)).save(this.output);
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get())), (Ingredient)this.ofTag((TagKey<Item>)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.NETHERITE_TIER_UPGRADE.get())).unlocks(ModRecipeProvider.getHasName((ItemLike)Items.NETHERITE_INGOT), this.has(Tags.Items.INGOTS_NETHERITE)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"netherite_tier_upgrade")));
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.TANKS_UPGRADE.get())).define(Character.valueOf('A'), ModItems.BACKPACK_TANK).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).pattern("ABA").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), this.has((ItemLike)ModItems.BLANK_UPGRADE)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CRAFTING_UPGRADE.get())).define(Character.valueOf('A'), Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).pattern("A").pattern("B").pattern("C").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), this.has((ItemLike)ModItems.BLANK_UPGRADE)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.FURNACE_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Blocks.FURNACE).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).pattern("A").pattern("B").pattern("C").unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get())), this.has((ItemLike)ModItems.BLANK_UPGRADE.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SMOKER_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Blocks.SMOKER).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).pattern("A").pattern("B").pattern("C").unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get())), this.has((ItemLike)ModItems.BLANK_UPGRADE.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BLAST_FURNACE_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Blocks.BLAST_FURNACE).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).pattern("A").pattern("B").pattern("C").unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get())), this.has((ItemLike)ModItems.BLANK_UPGRADE.get())).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.FEEDING_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), (ItemLike)Items.GOLDEN_APPLE).define(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).pattern("ABC").pattern("DDD").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), this.has((ItemLike)ModItems.BLANK_UPGRADE)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.PICKUP_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Items.HOPPER).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.DUSTS_REDSTONE).pattern("ABA").pattern("CCC").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), this.has((ItemLike)ModItems.BLANK_UPGRADE)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.JUKEBOX_UPGRADE.get())).define(Character.valueOf('A'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), (ItemLike)Items.JUKEBOX).pattern(" B ").pattern("ACA").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), this.has((ItemLike)ModItems.BLANK_UPGRADE)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.REFILL_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Items.DROPPER).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.DUSTS_REDSTONE).pattern("ABA").pattern("CCC").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), this.has((ItemLike)ModItems.BLANK_UPGRADE)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.MAGNET_UPGRADE.get())).define(Character.valueOf('A'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('B'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('C'), ModItems.BLANK_UPGRADE).define(Character.valueOf('D'), Tags.Items.GEMS_LAPIS).define(Character.valueOf('E'), Tags.Items.INGOTS_IRON).pattern("A A").pattern("BCD").pattern("BED").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), this.has((ItemLike)ModItems.BLANK_UPGRADE)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.VOID_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.DUSTS_REDSTONE).pattern("ABA").pattern("CCC").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), this.has((ItemLike)ModItems.BLANK_UPGRADE)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BACKPACK_TANK.get())).define(Character.valueOf('B'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('A'), Tags.Items.INGOTS_IRON).pattern("BAB").pattern("B B").pattern("BAB").unlockedBy("has_iron", this.has(Tags.Items.INGOTS_IRON)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.HOSE_NOZZLE.get())).define(Character.valueOf('A'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('B'), Tags.Items.INGOTS_IRON).pattern(" A ").pattern("B B").unlockedBy("has_iron", this.has(Tags.Items.INGOTS_IRON)).save(this.output);
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.HOSE.get())).define(Character.valueOf('A'), (ItemLike)ModItems.HOSE_NOZZLE.get()).define(Character.valueOf('B'), Tags.Items.DYES_GREEN).pattern("ABB").pattern("  B").pattern("  B").unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.HOSE_NOZZLE.get())), this.has((ItemLike)ModItems.HOSE_NOZZLE.get())).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).group("standard_travelers_backpack").define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.LEATHERS).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.STRINGS).define(Character.valueOf('C'), (ItemLike)ModItems.BACKPACK_TANK.get()).define(Character.valueOf('D'), (TagKey<Item>)Tags.Items.CHESTS_WOODEN).define(Character.valueOf('S'), ModTags.SLEEPING_BAGS).pattern("XBX").pattern("CDC").pattern("XSX").unlockedBy("has_chest", this.has(Tags.Items.CHESTS_WOODEN)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).group("standard_travelers_backpack").define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.LEATHERS).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.STRINGS).define(Character.valueOf('D'), (TagKey<Item>)Tags.Items.CHESTS_WOODEN).define(Character.valueOf('S'), ModTags.SLEEPING_BAGS).pattern("XBX").pattern(" D ").pattern("XSX").unlockedBy("has_chest", this.has(Tags.Items.CHESTS_WOODEN)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"standard_no_tanks")));
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), (Ingredient)Ingredient.of((ItemLike)((ItemLike)ModItems.DIAMOND_TRAVELERS_BACKPACK.get())), (Ingredient)this.ofTag((TagKey<Item>)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get())).unlocks(ModRecipeProvider.getHasName((ItemLike)Items.NETHERITE_INGOT), this.has(Tags.Items.INGOTS_NETHERITE)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"netherite")));
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.BEE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.HONEYCOMB).define(Character.valueOf('B'), (ItemLike)Items.HONEY_BOTTLE).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), this.has((ItemLike)Items.HONEYCOMB)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.HONEY_BOTTLE), this.has((ItemLike)Items.HONEY_BOTTLE)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.BLAZE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)Tags.Items.RODS_BLAZE).define(Character.valueOf('B'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (ItemLike)Items.BLAZE_POWDER).define(Character.valueOf('E'), (ItemLike)Items.LAVA_BUCKET).pattern("ABA").pattern("ACA").pattern("DED").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.BLAZE_ROD), this.has(Tags.Items.RODS_BLAZE)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("AAA").pattern("BCB").pattern("AAA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.BOOK), this.has((ItemLike)Items.BOOK)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.CACTUS_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.CACTUS).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.DYES_GREEN).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (TagKey<Item>)Tags.Items.SANDS).pattern("ABA").pattern("ACA").pattern("DDD").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.CACTUS), this.has((ItemLike)Items.CACTUS)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.CAKE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.MILK_BUCKET).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.EGGS).define(Character.valueOf('C'), (ItemLike)Items.SUGAR).define(Character.valueOf('D'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('E'), (TagKey<Item>)Tags.Items.CROPS_WHEAT).pattern("ABA").pattern("CDC").pattern("EEE").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.EGG), this.has(Tags.Items.EGGS)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.CHICKEN_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)Tags.Items.FEATHERS).define(Character.valueOf('B'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.EGGS).pattern(" A ").pattern("ABA").pattern("CCC").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.FEATHER), this.has(Tags.Items.FEATHERS)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.COW_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.BEEF).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.LEATHERS).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (ItemLike)Items.MILK_BUCKET).pattern("ABA").pattern("ACA").pattern("BDB").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.MILK_BUCKET), this.has((ItemLike)Items.MILK_BUCKET)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.CREEPER_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.GUNPOWDER).define(Character.valueOf('B'), (ItemLike)Items.CREEPER_HEAD).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (ItemLike)Items.TNT).pattern("ABA").pattern("ACA").pattern("DDD").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.GUNPOWDER), this.has((ItemLike)Items.GUNPOWDER)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.DRAGON_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.DRAGON_BREATH).define(Character.valueOf('B'), (ItemLike)Items.DRAGON_HEAD).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.END_STONES).define(Character.valueOf('D'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('E'), (TagKey<Item>)Tags.Items.ENDER_PEARLS).pattern("ABA").pattern("CDC").pattern("ECE").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.DRAGON_BREATH), this.has((ItemLike)Items.DRAGON_BREATH)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.END_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.END_STONES).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.ENDER_EYE), this.has((ItemLike)Items.ENDER_EYE)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.GHAST_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('B'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.GUNPOWDERS).define(Character.valueOf('D'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("CDC").pattern("ACA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.GHAST_TEAR), this.has((ItemLike)Items.GHAST_TEAR)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.HORSE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)Tags.Items.LEATHERS).define(Character.valueOf('B'), (ItemLike)Items.APPLE).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.CROPS_WHEAT).define(Character.valueOf('D'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("CDC").pattern("ACA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.LEATHER), this.has((ItemLike)Items.LEATHER)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.LAPIS_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.GEMS_LAPIS).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.LAPIS_LAZULI), this.has(Tags.Items.GEMS_LAPIS)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.MAGMA_CREAM).define(Character.valueOf('B'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("ACA").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.MAGMA_CREAM), this.has((ItemLike)Items.MAGMA_CREAM)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.MELON_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.MELON_SLICE).define(Character.valueOf('B'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('C'), (ItemLike)Items.MELON_SEEDS).pattern("A A").pattern("ABA").pattern("ACA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.MELON_SLICE), this.has((ItemLike)Items.MELON_SLICE)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.NETHER_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)Tags.Items.GEMS_QUARTZ).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.CROPS_NETHER_WART).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.NETHERRACKS).define(Character.valueOf('D'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('E'), (ItemLike)Items.BLACKSTONE).define(Character.valueOf('F'), (ItemLike)Items.LAVA_BUCKET).pattern("ABA").pattern("CDC").pattern("EFE").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.NETHER_WART), this.has(Tags.Items.CROPS_NETHER_WART)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.PIG_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.PORKCHOP).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.CROPS_CARROT).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("ACA").pattern("AAA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.PORKCHOP), this.has((ItemLike)Items.PORKCHOP)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.PUMPKIN).define(Character.valueOf('B'), (ItemLike)Items.CARVED_PUMPKIN).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (TagKey<Item>)Tags.Items.SEEDS_PUMPKIN).pattern("ABA").pattern("ACA").pattern("ADA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.PUMPKIN), this.has((ItemLike)Items.PUMPKIN)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.QUARTZ_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.QUARTZ_BLOCK).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.GEMS_QUARTZ).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.QUARTZ), this.has(Tags.Items.GEMS_QUARTZ)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.SANDSTONE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.SANDSTONE).define(Character.valueOf('B'), (ItemLike)Items.CHISELED_SANDSTONE).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("ACA").pattern("AAA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.SANDSTONE), this.has((ItemLike)Items.SANDSTONE)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.SHEEP_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.WHITE_WOOL).define(Character.valueOf('B'), (ItemLike)Items.MUTTON).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.WHITE_WOOL), this.has((ItemLike)Items.WHITE_WOOL)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.SKELETON_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.BONE).define(Character.valueOf('B'), (ItemLike)Items.ARROW).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (ItemLike)Items.BOW).pattern("ABA").pattern("BCB").pattern("ADA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.ARROW), this.has((ItemLike)Items.ARROW)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.SNOW_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.ICE).define(Character.valueOf('B'), (ItemLike)Items.SNOW_BLOCK).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (ItemLike)Items.SNOWBALL).pattern("AAA").pattern("BCB").pattern("DBD").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.SNOWBALL), this.has((ItemLike)Items.SNOWBALL)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.SPIDER_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.SPIDER_EYE).define(Character.valueOf('B'), (ItemLike)Items.STRING).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.STRING), this.has((ItemLike)Items.STRING)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.SQUID_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.GLOW_INK_SAC).define(Character.valueOf('B'), (ItemLike)Items.INK_SAC).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.INK_SAC), this.has((ItemLike)Items.INK_SAC)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.WITHER_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.WITHER_SKELETON_SKULL).define(Character.valueOf('B'), (ItemLike)Items.SOUL_SAND).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("AAA").pattern("BCB").pattern(" B ").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.WITHER_SKELETON_SKULL), this.has((ItemLike)Items.WITHER_SKELETON_SKULL)).save(this.output);
        ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)ModItems.WARDEN_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.ECHO_SHARD).define(Character.valueOf('B'), (ItemLike)Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("AAA").pattern("ACA").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.ECHO_SHARD), this.has((ItemLike)Items.ECHO_SHARD)).save(this.output);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.BLACK_SLEEPING_BAG.get(), (ItemLike)Items.BLACK_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.BLUE_SLEEPING_BAG.get(), (ItemLike)Items.BLUE_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.BROWN_SLEEPING_BAG.get(), (ItemLike)Items.BROWN_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.CYAN_SLEEPING_BAG.get(), (ItemLike)Items.CYAN_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.GRAY_SLEEPING_BAG.get(), (ItemLike)Items.GRAY_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.GREEN_SLEEPING_BAG.get(), (ItemLike)Items.GREEN_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.LIGHT_BLUE_SLEEPING_BAG.get(), (ItemLike)Items.LIGHT_BLUE_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.LIGHT_GRAY_SLEEPING_BAG.get(), (ItemLike)Items.LIGHT_GRAY_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.LIME_SLEEPING_BAG.get(), (ItemLike)Items.LIME_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.MAGENTA_SLEEPING_BAG.get(), (ItemLike)Items.MAGENTA_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.ORANGE_SLEEPING_BAG.get(), (ItemLike)Items.ORANGE_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.PINK_SLEEPING_BAG.get(), (ItemLike)Items.PINK_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.PURPLE_SLEEPING_BAG.get(), (ItemLike)Items.PURPLE_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.RED_SLEEPING_BAG.get(), (ItemLike)Items.RED_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.WHITE_SLEEPING_BAG.get(), (ItemLike)Items.WHITE_WOOL);
        this.sleepingBagFromWool(this.output, (ItemLike)ModItems.YELLOW_SLEEPING_BAG.get(), (ItemLike)Items.YELLOW_WOOL);
        List<Item> list = List.of(Items.BLACK_DYE, Items.BLUE_DYE, Items.BROWN_DYE, Items.CYAN_DYE, Items.GRAY_DYE, Items.GREEN_DYE, Items.LIGHT_BLUE_DYE, Items.LIGHT_GRAY_DYE, Items.LIME_DYE, Items.MAGENTA_DYE, Items.ORANGE_DYE, Items.PINK_DYE, Items.PURPLE_DYE, Items.RED_DYE, Items.YELLOW_DYE, Items.WHITE_DYE);
        List<Item> list2 = List.of((Item)ModItems.BLACK_SLEEPING_BAG.get(), (Item)ModItems.BLUE_SLEEPING_BAG.get(), (Item)ModItems.BROWN_SLEEPING_BAG.get(), (Item)ModItems.CYAN_SLEEPING_BAG.get(), (Item)ModItems.GRAY_SLEEPING_BAG.get(), (Item)ModItems.GREEN_SLEEPING_BAG.get(), (Item)ModItems.LIGHT_BLUE_SLEEPING_BAG.get(), (Item)ModItems.LIGHT_GRAY_SLEEPING_BAG.get(), (Item)ModItems.LIME_SLEEPING_BAG.get(), (Item)ModItems.MAGENTA_SLEEPING_BAG.get(), (Item)ModItems.ORANGE_SLEEPING_BAG.get(), (Item)ModItems.PINK_SLEEPING_BAG.get(), (Item)ModItems.PURPLE_SLEEPING_BAG.get(), (Item)ModItems.RED_SLEEPING_BAG.get(), (Item)ModItems.YELLOW_SLEEPING_BAG.get(), (Item)ModItems.WHITE_SLEEPING_BAG.get());
        this.colorWithDye(this.output, list, list2, null, "sleeping_bag");
    }

    public Ingredient ofTag(TagKey<Item> tag) {
        return Ingredient.of((HolderSet)this.registries.lookupOrThrow(Registries.ITEM).getOrThrow(tag));
    }

    public ShapedBackpackRecipeBuilder createBackpackSmallGrid(Item result, Ingredient ingredient, String criterionName, Criterion<?> criterion) {
        return ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('A'), ingredient).define(Character.valueOf('B'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern(" A ").pattern("ABA").pattern(" A ").unlockedBy(criterionName, (Criterion)criterion);
    }

    public ShapedBackpackRecipeBuilder createBackpackFullGrid(Item result, Ingredient ingredient, String criterionName, Criterion<?> criterion) {
        return ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('A'), ingredient).define(Character.valueOf('B'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("AAA").pattern("ABA").pattern("AAA").unlockedBy(criterionName, (Criterion)criterion);
    }

    public ShapedBackpackRecipeBuilder createFullGrid(Item result, Ingredient ingredient, Ingredient ingredient1, Item unlocker, TagKey<Item> tag) {
        return ShapedBackpackRecipeBuilder.shaped((HolderGetter<Item>)this.registries.lookupOrThrow(Registries.ITEM), RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('A'), ingredient1).define(Character.valueOf('B'), ingredient).pattern("AAA").pattern("ABA").pattern("AAA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)unlocker), this.has(tag));
    }

    protected void sleepingBagFromWool(RecipeOutput recipeOutput, ItemLike sleepingBag, ItemLike pWool) {
        ShapedRecipeBuilder.shaped((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)sleepingBag).group("sleeping_bag").define(Character.valueOf('#'), pWool).define(Character.valueOf('X'), (ItemLike)Items.WHITE_WOOL).pattern("##X").unlockedBy(ModRecipeProvider.getHasName((ItemLike)pWool), this.has(pWool)).save(recipeOutput);
    }

    protected void colorWithDye(RecipeOutput output, List<Item> dyes, List<Item> dyeableItems, @Nullable Item dye, String group) {
        for (int i = 0; i < dyes.size(); ++i) {
            Item item = dyes.get(i);
            Item item1 = dyeableItems.get(i);
            Stream<Item> stream = dyeableItems.stream().filter(p_288265_ -> !p_288265_.equals(item1));
            if (dye != null) {
                stream = Stream.concat(stream, Stream.of(dye));
            }
            ShapelessRecipeBuilder.shapeless((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item1).requires((ItemLike)item).requires(Ingredient.of(stream)).group(group).unlockedBy("has_needed_dye", this.has((ItemLike)item)).save(output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)("dye_" + ModRecipeProvider.getItemName((ItemLike)item1)))));
        }
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new ModRecipeProvider(registries, output);
        }

        public String getName() {
            return "Traveler's Backpack Recipes";
        }
    }
}

