/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.entity;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BackpackItemEntity
extends ItemEntity {
    public boolean wasFloatingUp = false;
    public boolean isInvulnerable;

    public BackpackItemEntity(EntityType<? extends ItemEntity> entityType, Level level) {
        super(entityType, level);
        this.lifespan = Integer.MAX_VALUE;
        this.isInvulnerable = (Boolean)TravelersBackpackConfig.SERVER.backpackSettings.invulnerableBackpack.get();
    }

    public void tick() {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.voidProtection.get()).booleanValue()) {
            if (!this.level().isClientSide && !this.isNoGravity() && this.wasFloatingUp && this.getY() < (double)this.level().getMinY() && this.random.nextFloat() > 0.25f) {
                float ab = this.random.nextFloat() * 2.0f;
                float ag = this.random.nextFloat() * ((float)Math.PI * 2);
                double n = Mth.cos((float)ag) * ab;
                double o = 0.01 + this.random.nextDouble() * 0.5;
                double p = Mth.sin((float)ag) * ab;
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.position().x() + n * 0.1, this.position().y() + 0.3, this.position().z() + p * 0.1, 0, n * (double)0.01f, o * (double)0.1f, p * (double)0.01f, 1.0);
            }
            if (!this.isNoGravity()) {
                if (this.isInWater() || this.isInLava()) {
                    this.onInsideBubbleColumn(false);
                    this.wasFloatingUp = true;
                } else if (this.wasFloatingUp) {
                    this.setNoGravity(true);
                    this.setDeltaMovement(Vec3.ZERO);
                }
            }
        }
        super.tick();
    }

    public boolean isInWater() {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.voidProtection.get()).booleanValue()) {
            return this.getY() < (double)(this.level().getMinY() + 1) || super.isInWater();
        }
        return super.isInWater();
    }

    public boolean fireImmune() {
        return this.isInvulnerable;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return this.isInvulnerable;
    }

    public boolean isInvulnerable() {
        return this.isInvulnerable;
    }

    protected void onBelowWorld() {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.voidProtection.get()).booleanValue()) {
            this.discard();
        }
    }
}

