/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.CraftingSlot;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.TrashSlot;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeLockableSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundUpdateRecipePacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class BackpackBaseMenu
extends AbstractBackpackMenu {
    public List<UpgradeLockableSlotItemHandler> upgradeSlot = new ArrayList<UpgradeLockableSlotItemHandler>();
    public int unmodifiableSlotCount = 0;
    public int TOOL_START;
    public int TOOL_END;
    public int UPGRADE_START;
    public int UPGRADE_END;
    public int BUCKET_LEFT_IN;
    public int BUCKET_LEFT_OUT;
    public int BUCKET_RIGHT_IN;
    public int BUCKET_RIGHT_OUT;
    public int CRAFTING_RESULT;
    public int CRAFTING_GRID_START;
    public int CRAFTING_GRID_END;

    public BackpackBaseMenu(MenuType<?> type, int windowID, Inventory inventory, BackpackWrapper wrapper) {
        super(type, windowID, inventory, wrapper);
        this.addSlots();
    }

    public void addSlots() {
        if (this.wrapper.tanksVisible()) {
            this.extendedScreenOffset = 22;
        }
        this.addBackpackStorageSlots(this.wrapper);
        this.BACKPACK_INV_END = this.slots.size();
        this.TOOL_START = this.slots.size();
        this.addBackpackToolSlots(this.wrapper);
        this.TOOL_END = this.slots.size();
        this.UPGRADE_START = this.slots.size();
        this.addBackpackUpgradeSlots(this.wrapper);
        this.UPGRADE_END = this.slots.size();
        this.PLAYER_INV_START = this.slots.size();
        this.addPlayerInventoryAndHotbar(this.inventory, this.getWrapper().getBackpackSlotIndex());
        this.PLAYER_HOT_END = this.slots.size();
        this.unmodifiableSlotCount = this.slots.size();
        this.addUpgradeListeners();
        this.addUpgradeSlots(this.wrapper);
    }

    public void addModifiableSlots() {
        if (this.wrapper.tanksVisible()) {
            this.extendedScreenOffset = 22;
        }
        this.updateSlotsPosition();
        this.updateBackpackUpgradeSlots();
        this.addUpgradeListeners();
        this.addUpgradeSlots(this.wrapper);
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.canCraft(this.inventory.player.level(), this.inventory.player));
    }

    public void updateModifiableSlots() {
        this.extendedScreenOffset = 0;
        if (this.lastSlots.size() > this.unmodifiableSlotCount) {
            this.lastSlots.subList(this.unmodifiableSlotCount, this.lastSlots.size()).clear();
        }
        if (this.slots.size() > this.unmodifiableSlotCount) {
            this.slots.subList(this.unmodifiableSlotCount, this.slots.size()).clear();
        }
        if (this.remoteSlots.size() > this.unmodifiableSlotCount) {
            this.remoteSlots.subList(this.unmodifiableSlotCount, this.remoteSlots.size()).clear();
        }
        this.addModifiableSlots();
    }

    public void updateSlotsPosition() {
        int i;
        int slot = 0;
        for (int i2 = this.BACKPACK_INV_START; i2 < this.BACKPACK_INV_END; ++i2) {
            if (!((Slot)this.slots.get(i2)).getClass().equals(BackpackSlotItemHandler.class)) continue;
            ((Slot)this.slots.get((int)i2)).x = this.extendedScreenOffset + 8 + slot * 18;
            if (slot < this.wrapper.getSlotsInRow() - 1) {
                ++slot;
                continue;
            }
            slot = 0;
        }
        int modifiedOffset = this.extendedScreenOffset * 2;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 36;
        }
        for (i = this.UPGRADE_START; i < this.UPGRADE_END; ++i) {
            if (!((Slot)this.slots.get(i)).getClass().equals(UpgradeLockableSlotItemHandler.class)) continue;
            ((Slot)this.slots.get((int)i)).x = 162 + modifiedOffset + 15;
        }
        modifiedOffset = this.extendedScreenOffset;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }
        slot = 0;
        for (i = this.PLAYER_INV_START; i < this.PLAYER_HOT_END; ++i) {
            if (!(((Slot)this.slots.get((int)i)).container instanceof Inventory)) continue;
            ((Slot)this.slots.get((int)i)).x = modifiedOffset + 8 + slot * 18;
            if (slot < 8) {
                ++slot;
                continue;
            }
            slot = 0;
        }
    }

    public void updateSlots() {
        this.extendedScreenOffset = 0;
        this.lastSlots.clear();
        this.slots.clear();
        this.remoteSlots.clear();
        this.addSlots();
    }

    public void addUpgradeListeners() {
        for (Optional upgrade : this.wrapper.getUpgradeManager().mappedUpgrades.values()) {
            upgrade.ifPresent(iUpgrade -> iUpgrade.initializeContainers(this, this.wrapper));
        }
    }

    public void updateBackpackUpgradeSlots() {
        AtomicInteger nextSlot = new AtomicInteger();
        boolean tabOpened = false;
        int lastOccupiedSlot = -1;
        for (int i = this.wrapper.getUpgrades().getSlots() - 1; i >= 0; --i) {
            if (this.wrapper.getUpgrades().getStackInSlot(i).isEmpty()) continue;
            if (i != 0 && lastOccupiedSlot == -1) {
                lastOccupiedSlot = i;
            }
            if (tabOpened || !this.wrapper.getUpgradeManager().hasUpgradeInSlot(i)) continue;
            tabOpened = (Boolean)this.wrapper.getUpgrades().getStackInSlot(i).getOrDefault(ModDataComponents.TAB_OPEN, (Object)false);
        }
        boolean finalTabOpened = tabOpened;
        int finalLastOccupiedSlot = lastOccupiedSlot;
        this.slots.stream().filter(slot -> slot instanceof UpgradeLockableSlotItemHandler).forEach(slot -> {
            UpgradeLockableSlotItemHandler upgradeSlot = (UpgradeLockableSlotItemHandler)((Object)slot);
            upgradeSlot.setHidden(false);
            int j = slot.getContainerSlot();
            if (j > 0) {
                Optional upgrade = (Optional)this.wrapper.getUpgradeManager().mappedUpgrades.get((Object)(j - 1));
                if (upgrade != null && upgrade.isPresent()) {
                    nextSlot.addAndGet(((IUpgrade)upgrade.get()).getTabSize().y() + 1);
                } else {
                    nextSlot.addAndGet(25);
                }
            }
            upgradeSlot.y = 33 + nextSlot.get();
            if (finalTabOpened && upgradeSlot.getContainerSlot() > finalLastOccupiedSlot) {
                upgradeSlot.setHidden(true);
            }
            upgradeSlot.setLocked(upgradeSlot.getItem().getItem() instanceof UpgradeItem);
        });
    }

    public void addBackpackUpgradeSlots(BackpackWrapper wrapper) {
        int i;
        this.upgradeSlot.clear();
        int modifiedOffset = this.extendedScreenOffset * 2;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 36;
        }
        int nextSlot = 0;
        boolean tabOpened = false;
        int lastOccupiedSlot = -1;
        for (i = wrapper.getUpgrades().getSlots() - 1; i >= 0; --i) {
            if (wrapper.getUpgrades().getStackInSlot(i).isEmpty()) continue;
            if (i != 0 && lastOccupiedSlot == -1) {
                lastOccupiedSlot = i;
            }
            if (tabOpened || !wrapper.getUpgradeManager().hasUpgradeInSlot(i)) continue;
            tabOpened = (Boolean)wrapper.getUpgrades().getStackInSlot(i).getOrDefault(ModDataComponents.TAB_OPEN, (Object)false);
        }
        for (i = 0; i < wrapper.getUpgrades().getSlots(); ++i) {
            if (i > 0) {
                Optional upgrade = (Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)(i - 1));
                nextSlot = upgrade != null && upgrade.isPresent() ? (nextSlot += ((IUpgrade)upgrade.get()).getTabSize().y() + 1) : (nextSlot += 25);
            }
            UpgradeLockableSlotItemHandler slot = new UpgradeLockableSlotItemHandler(this, (IItemHandler)wrapper.getUpgrades(), i, 162 + modifiedOffset + 15, 33 + nextSlot);
            if (tabOpened && slot.getContainerSlot() > lastOccupiedSlot) {
                slot.setHidden(true);
            }
            this.addSlot((Slot)slot);
        }
    }

    protected Slot addSlot(Slot slot) {
        if (slot instanceof UpgradeLockableSlotItemHandler) {
            UpgradeLockableSlotItemHandler upgradeSlotItemHandler = (UpgradeLockableSlotItemHandler)slot;
            this.upgradeSlot.add(upgradeSlotItemHandler);
        }
        return super.addSlot(slot);
    }

    public void addBackpackToolSlots(BackpackWrapper wrapper) {
        for (int i = 0; i < wrapper.getTools().getSlots(); ++i) {
            this.addSlot((Slot)new ToolSlotItemHandler(wrapper, i, -14, 18 + i * 18));
        }
    }

    public void addPlayerInventoryAndHotbar(Inventory inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 25 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 83));
        }
    }

    public void addUpgradeSlots(BackpackWrapper wrapper) {
        for (Optional upgrade : wrapper.getUpgradeManager().mappedUpgrades.values()) {
            upgrade.ifPresent(upgradeLoaded -> {
                int x = this.upgradeSlot.get((int)((Integer)wrapper.getUpgradeManager().mappedUpgrades.inverse().get((Object)upgrade)).intValue()).x - 4;
                int y = this.upgradeSlot.get((int)((Integer)wrapper.getUpgradeManager().mappedUpgrades.inverse().get((Object)upgrade)).intValue()).y - 4;
                if (upgradeLoaded.isTabOpened()) {
                    for (Slot slot : upgradeLoaded.getUpgradeSlots(this, wrapper, x, y)) {
                        this.addSlot(slot);
                    }
                }
            });
        }
    }

    protected void doClick(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        Object object;
        if (pSlotId >= 0 && pSlotId < this.slots.size() && (object = this.slots.get(pSlotId)) instanceof TrashSlot) {
            TrashSlot trashSlot = (TrashSlot)((Object)object);
            if (!this.getCarried().isEmpty() && trashSlot.hasItem() && pClickType == ClickType.PICKUP) {
                trashSlot.set(ItemStack.EMPTY.copy());
            }
        }
        if (pSlotId >= 0 && pSlotId < this.slots.size() && (object = this.slots.get(pSlotId)) instanceof FilterSlotItemHandler) {
            FilterSlotItemHandler filterSlot = (FilterSlotItemHandler)((Object)object);
            if (this.getCarried().isEmpty() && pClickType == ClickType.PICKUP && pButton == 0) {
                super.doClick(pSlotId, pButton, pClickType, pPlayer);
            } else if (!this.getCarried().isEmpty() && filterSlot.mayPlace(this.getCarried()) && !filterSlot.hasItem()) {
                filterSlot.set(this.getCarried().copyWithCount(1));
            }
        } else {
            super.doClick(pSlotId, pButton, pClickType, pPlayer);
        }
    }

    protected void canCraft(Level level, Player player) {
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.slotChangedCraftingGrid((CraftingUpgrade)craftingUpgrade, level, player));
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
        this.canCraft(this.inventory.player.level(), this.inventory.player);
    }

    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
        this.canCraft(this.inventory.player.level(), this.inventory.player);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).isPresent()) {
            return slot.container != this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).get().resultSlots;
        }
        if (slot instanceof FilterSlotItemHandler) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = this.getSlot(index);
        ItemStack result = ItemStack.EMPTY;
        if (slot != null && slot.hasItem()) {
            UpgradeSlotItemHandler upgradeSlotItemHandler;
            ItemStack stack = slot.getItem();
            result = stack.copy();
            if (slot instanceof ResultSlotExt) {
                ResultSlotExt resultSlotExtNew = (ResultSlotExt)slot;
                return this.handleShiftCraft(this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).get(), player, resultSlotExtNew);
            }
            if (slot instanceof CraftingSlot && !this.moveItemStackTo(stack, this.BACKPACK_INV_START, this.PLAYER_HOT_END, false)) {
                return ItemStack.EMPTY;
            }
            if (index >= this.BACKPACK_INV_START && index < this.BACKPACK_INV_END && !this.moveItemStackTo(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true)) {
                return ItemStack.EMPTY;
            }
            if (index >= this.PLAYER_INV_START && index < this.PLAYER_HOT_END) {
                if (this.wrapper.showToolSlots() && ToolSlotItemHandler.isValid(stack) && !this.moveItemStackTo(stack, this.TOOL_START, this.TOOL_END, false) && !this.moveItemStackTo(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.checkMemorySlots(stack) && !this.moveItemStackTo(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (slot instanceof UpgradeSlotItemHandler && ((upgradeSlotItemHandler = (UpgradeSlotItemHandler)slot).shiftClickToBackpack() ? !this.moveItemStackTo(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false) && !this.moveItemStackTo(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true) : !this.moveItemStackTo(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true) && !this.moveItemStackTo(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false))) {
                return ItemStack.EMPTY;
            }
            if (slot instanceof ToolSlotItemHandler && !this.moveItemStackTo(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.set(stack);
            }
            if (stack.getCount() == result.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return result;
    }

    public boolean checkMemorySlots(ItemStack stack) {
        if (!this.wrapper.getMemorySlots().isEmpty()) {
            for (Pair<Integer, Pair<ItemStack, Boolean>> memorizedStack : this.wrapper.getMemorySlots()) {
                if (stack.getItem() != ((ItemStack)((Pair)memorizedStack.getSecond()).getFirst()).getItem() || !((Boolean)((Pair)memorizedStack.getSecond()).getSecond() != false ? ItemStackUtils.isSameItemSameComponents((ItemStack)((Pair)memorizedStack.getSecond()).getFirst(), stack) && this.moveItemStackTo(stack, (Integer)memorizedStack.getFirst(), (Integer)memorizedStack.getFirst() + 1, false) : ItemStack.isSameItem((ItemStack)((ItemStack)((Pair)memorizedStack.getSecond()).getFirst()), (ItemStack)stack) && this.moveItemStackTo(stack, (Integer)memorizedStack.getFirst(), (Integer)memorizedStack.getFirst() + 1, false))) continue;
                return stack.isEmpty();
            }
        }
        return false;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean applyRespectedSlotLogic = startIndex == this.BACKPACK_INV_START && endIndex == this.BACKPACK_INV_END;
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                Slot slot = (Slot)this.slots.get(i);
                ItemStack itemstack = slot.getItem().copy();
                if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.getCount() + stack.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemstack))) {
                        stack.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        stack.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                ItemStack itemstack1;
                Slot slot1 = (Slot)this.slots.get(i);
                boolean accept = true;
                Optional<Pair<Integer, Pair<ItemStack, Boolean>>> memorizedOptional = this.getWrapper().getMemorizedSlot(slot1.getSlotIndex());
                boolean isUnsortable = this.getWrapper().getUnsortableSlots().contains(slot1.getSlotIndex());
                if (memorizedOptional.isPresent()) {
                    ItemStack memorizedStack = (ItemStack)((Pair)memorizedOptional.get().getSecond()).getFirst();
                    boolean matchComponents = (Boolean)((Pair)memorizedOptional.get().getSecond()).getSecond();
                    if (applyRespectedSlotLogic) {
                        boolean bl = accept = matchComponents ? ItemStackUtils.isSameItemSameComponents(memorizedStack, stack) : ItemStack.isSameItem((ItemStack)memorizedStack, (ItemStack)stack);
                    }
                }
                if (isUnsortable && !memorizedOptional.isPresent() && accept && applyRespectedSlotLogic) {
                    accept = false;
                }
                if ((itemstack1 = slot1.getItem()).isEmpty() && slot1.mayPlace(stack) && accept) {
                    int l = slot1.getMaxStackSize(stack);
                    slot1.setByPlayer(stack.split(Math.min(stack.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ItemStack handleShiftCraft(CraftingUpgrade upgrade, Player player, ResultSlotExt resultSlot) {
        ItemStack outputCopy = ItemStack.EMPTY;
        CraftingInput input = upgrade.craftSlots.asCraftInput();
        if (resultSlot != null && resultSlot.hasItem()) {
            upgrade.craftSlots.checkChanges = false;
            RecipeHolder recipe = upgrade.resultSlots.getRecipeUsed();
            while (recipe != null && ((CraftingRecipe)recipe.value()).matches((RecipeInput)input, player.level())) {
                ItemStack recipeOutput = ((CraftingRecipe)recipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)player.level().registryAccess());
                if (recipeOutput.isEmpty()) {
                    throw new RuntimeException("A recipe matched but produced an empty output - Offending Recipe : " + String.valueOf(recipe.id()) + " - This is NOT a bug in Traveler's Backpack!");
                }
                outputCopy = recipeOutput.copy();
                recipeOutput.onCraftedBy(player, 1);
                EventHooks.firePlayerCraftingEvent((Player)player, (ItemStack)recipeOutput, (Container)upgrade.craftSlots);
                if (!player.level().isClientSide) {
                    if (upgrade.shiftClickToBackpack(upgrade.getDataHolderStack())) {
                        if (!this.checkMemorySlots(recipeOutput) && !this.moveItemStackTo(recipeOutput, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                            upgrade.craftSlots.checkChanges = true;
                            return ItemStack.EMPTY;
                        }
                    } else if (!this.moveItemStackTo(recipeOutput, this.PLAYER_INV_START, this.PLAYER_HOT_END, true) && !this.moveItemStackTo(recipeOutput, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                        upgrade.craftSlots.checkChanges = true;
                        return ItemStack.EMPTY;
                    }
                }
                resultSlot.removeCount += outputCopy.getCount();
                resultSlot.onTake(player, recipeOutput);
                this.resetStackedContents(input);
            }
            upgrade.craftSlots.checkChanges = true;
            this.slotChangedCraftingGrid(upgrade, player.level(), player);
        }
        return outputCopy;
    }

    public void resetStackedContents(CraftingInput input) {
        StackedItemContents contents = input.stackedContents();
        contents.clear();
        for (ItemStack i : input.items()) {
            if (i.isEmpty()) continue;
            contents.accountStack(i, 1);
        }
    }

    public void slotChangedCraftingGrid(CraftingUpgrade upgrade, Level world, Player player) {
        if (!world.isClientSide && upgrade.craftSlots.checkChanges) {
            ItemStack itemstack = ItemStack.EMPTY;
            CraftingInput input = upgrade.craftSlots.asCraftInput();
            RecipeHolder oldRecipe = upgrade.resultSlots.getRecipeUsed();
            RecipeHolder recipe = oldRecipe;
            if (recipe == null || !((CraftingRecipe)recipe.value()).matches((RecipeInput)input, world)) {
                recipe = ((ServerLevel)world).recipeAccess().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, world).orElse(null);
            }
            if (recipe != null) {
                itemstack = ((CraftingRecipe)recipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)world.registryAccess());
            }
            if (oldRecipe != recipe || upgrade.resultSlots.getItem(0).isEmpty()) {
                for (Player user : this.getWrapper().getPlayersUsing().stream().filter(p -> p instanceof ServerPlayer).toList()) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)user), (CustomPacketPayload)new ClientboundUpdateRecipePacket(itemstack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                upgrade.resultSlots.setItem(0, itemstack);
                upgrade.resultSlots.setRecipeUsed(recipe);
            } else if (recipe != null && (((CraftingRecipe)recipe.value()).isSpecial() || !recipe.getClass().getName().startsWith("net.minecraft") && !ItemStack.matches((ItemStack)itemstack, (ItemStack)upgrade.resultSlots.getItem(0)))) {
                for (Player user : this.getWrapper().getPlayersUsing().stream().filter(p -> p instanceof ServerPlayer).toList()) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)user), (CustomPacketPayload)new ClientboundUpdateRecipePacket(itemstack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                upgrade.resultSlots.setItem(0, itemstack);
                upgrade.resultSlots.setRecipeUsed(recipe);
            }
        }
    }

    public void removed(Player player) {
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.checkHandlerAndPlaySound(craftingUpgrade.crafting, player, craftingUpgrade.crafting.getSlots()));
        this.wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> this.clearSlotsAndPlaySound(this.inventory.player, tanksUpgrade.getFluidSlotsHandler(), 4));
        this.wrapper.getUpgradeManager().getUpgrade(VoidUpgrade.class).ifPresent(this::voidTrashSlot);
        this.shiftTools(this.wrapper.getTools());
        super.removed(player);
    }

    public void clearSlotsAndPlaySound(Player player, ItemStackHandler handler, int size) {
        boolean playSound = false;
        for (int i = 0; i < size; ++i) {
            boolean flag = this.clearSlot(player, handler, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            this.playSound(player);
        }
    }

    public boolean clearSlot(Player player, ItemStackHandler handler, int index) {
        if (!handler.getStackInSlot(index).isEmpty()) {
            ServerPlayer serverPlayer;
            if (player == null) {
                return false;
            }
            if (!player.isAlive() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hasDisconnected()) {
                ItemStack stack = handler.getStackInSlot(index).copy();
                handler.setStackInSlot(index, ItemStack.EMPTY);
                player.drop(stack, false);
                return false;
            }
            ItemStack stack = handler.getStackInSlot(index);
            handler.setStackInSlot(index, ItemStack.EMPTY);
            player.getInventory().placeItemBackInInventory(stack);
            return true;
        }
        return false;
    }

    public void playSound(Player player) {
        player.level().playSound((Entity)player, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, (1.0f + (player.level().getRandom().nextFloat() - player.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
    }

    public void shiftTools(ItemStackHandler toolSlotsHandler) {
        boolean foundEmptySlot = false;
        boolean needsShifting = false;
        for (int i = 0; i < toolSlotsHandler.getSlots(); ++i) {
            if (foundEmptySlot && !toolSlotsHandler.getStackInSlot(i).isEmpty()) {
                needsShifting = true;
            }
            if (!toolSlotsHandler.getStackInSlot(i).isEmpty() || foundEmptySlot) continue;
            foundEmptySlot = true;
        }
        if (needsShifting) {
            int i;
            NonNullList tools = NonNullList.withSize((int)toolSlotsHandler.getSlots(), (Object)ItemStack.EMPTY);
            int j = 0;
            for (i = 0; i < toolSlotsHandler.getSlots(); ++i) {
                if (toolSlotsHandler.getStackInSlot(i).isEmpty()) continue;
                tools.set(j, (Object)toolSlotsHandler.getStackInSlot(i));
                ++j;
            }
            j = 0;
            for (i = 0; i < toolSlotsHandler.getSlots(); ++i) {
                if (tools.isEmpty()) continue;
                toolSlotsHandler.setStackInSlot(i, (ItemStack)tools.get(j));
                ++j;
            }
        }
    }

    public void voidTrashSlot(VoidUpgrade upgrade) {
        upgrade.voidTrashSlotStack();
    }

    public void checkHandlerAndPlaySound(ItemStackHandler handler, Player player, int size) {
        boolean playSound = false;
        for (int i = 0; i < size; ++i) {
            boolean flag = this.clearSlot(handler, player, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            this.playSound(player);
        }
    }

    public boolean clearSlot(ItemStackHandler handler, Player player, int index) {
        if (!BackpackSlotItemHandler.isItemValid(handler.getStackInSlot(index))) {
            if (player == null) {
                return false;
            }
            if (!player.isAlive()) {
                ServerPlayer serverPlayer;
                ItemStack stack = handler.getStackInSlot(index).copy();
                handler.setStackInSlot(index, ItemStack.EMPTY);
                if (player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).hasDisconnected()) {
                    player.drop(stack, false);
                }
                return false;
            }
            ItemStack stack = handler.getStackInSlot(index);
            handler.setStackInSlot(index, ItemStack.EMPTY);
            player.getInventory().placeItemBackInInventory(stack);
            return true;
        }
        return false;
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

