/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class UpgradeLockableSlotItemHandler
extends SlotItemHandler {
    public BackpackBaseMenu menu;
    public boolean isLocked = false;
    public boolean isHidden = false;

    public UpgradeLockableSlotItemHandler(BackpackBaseMenu menu, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.menu = menu;
        if (itemHandler.getStackInSlot(index).getItem() instanceof UpgradeItem && menu.getWrapper().getUpgradeManager().hasUpgradeInSlot(index)) {
            this.setLocked(true);
        }
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean mayPlace(ItemStack stack) {
        if (stack.getItem() instanceof TanksUpgradeItem && !this.getItemHandler().isItemValid(this.index, stack) && !TanksUpgradeItem.canBePutInBackpack(this.menu.getWrapper().getBackpackTankCapacity(), stack)) {
            BackpackScreen.displayTanksUpgradeWarning(this.menu.player);
        }
        return super.mayPlace(stack);
    }

    public boolean mayPickup(Player playerIn) {
        return super.mayPickup(playerIn) && !this.isLocked && !this.isHidden;
    }

    public boolean isActive() {
        return super.isActive() && !this.isLocked && !this.isHidden;
    }

    public void setByPlayer(ItemStack pNewStack, ItemStack pOldStack) {
        if (this.menu.player.level().isClientSide) {
            this.menu.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
        }
        super.setByPlayer(pNewStack, pOldStack);
    }

    public void setChanged() {
        super.setChanged();
    }
}

