/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.crafting;

import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class CraftingContainerImproved
implements CraftingContainer {
    private final CraftingUpgrade craftingUpgrade;
    public boolean checkChanges = true;
    public BackpackBaseMenu menu;

    public CraftingContainerImproved(BackpackBaseMenu menu, CraftingUpgrade craftingUpgrade) {
        this.menu = menu;
        this.craftingUpgrade = craftingUpgrade;
    }

    public int getContainerSize() {
        return this.craftingUpgrade.crafting.getSlots();
    }

    public NonNullList<ItemStack> getStackList() {
        NonNullList stacks = NonNullList.create();
        for (int i = 0; i < this.craftingUpgrade.crafting.getSlots(); ++i) {
            stacks.add(i, (Object)this.getItem(i));
        }
        return stacks;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.craftingUpgrade.crafting.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return slot >= this.getContainerSize() ? ItemStack.EMPTY : this.craftingUpgrade.crafting.getStackInSlot(slot);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return InventoryHelper.takeItem((IItemHandler)this.craftingUpgrade.crafting, slot);
    }

    public ItemStack removeItemShiftClick(int slot, int amount) {
        ItemStack stack = InventoryHelper.removeItemShiftClick((IItemHandlerModifiable)this.craftingUpgrade.crafting, slot, amount);
        if (this.checkChanges) {
            this.menu.slotsChanged((Container)this);
        }
        return stack;
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.craftingUpgrade.crafting.extractItem(slot, amount, false);
        if (!stack.isEmpty() && this.checkChanges) {
            this.menu.slotsChanged((Container)this);
        }
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.craftingUpgrade.crafting.setStackInSlot(slot, stack);
        if (this.checkChanges) {
            this.menu.slotsChanged((Container)this);
        }
    }

    public void setChanged() {
    }

    public boolean stillValid(Player p_39340_) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
    }

    public int getHeight() {
        return 3;
    }

    public int getWidth() {
        return 3;
    }

    public List<ItemStack> getItems() {
        return List.copyOf(this.getStackList());
    }

    public void fillStackedContents(StackedItemContents contents) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            contents.accountSimpleStack(this.getItem(i));
        }
    }
}

