/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.pickup;

import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.pickup.AutoPickupFilterSettings;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class AutoPickupUpgrade
extends FilterUpgradeBase<AutoPickupUpgrade, AutoPickupFilterSettings>
implements IEnable {
    public AutoPickupUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 49), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.pickupUpgradeSettings.filterSlotCount.get(), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.pickupUpgradeSettings.slotsInRow.get(), filter, filterTags);
    }

    public boolean canPickup(ItemStack stack) {
        return ((AutoPickupFilterSettings)this.getFilterSettings()).matchesFilter(null, stack) && this.isEnabled(this);
    }

    @Override
    public AutoPickupFilterSettings createFilterSettings(UpgradeManager manager, NonNullList<ItemStack> filter, List<String> filterTags) {
        return new AutoPickupFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.isEmpty()).toList(), this.getFilter(), filterTags, manager.getWrapper().getRegistriesAccess());
    }

    @Override
    protected FilterHandler createFilter(NonNullList<ItemStack> stacks, final int size) {
        return new FilterHandler(stacks, size){

            protected void onContentsChanged(int slot) {
                AutoPickupUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), InventoryHelper.itemsToList(size, AutoPickupUpgrade.this.filter));
                ((AutoPickupFilterSettings)AutoPickupUpgrade.this.getFilterSettings()).updateFilter((List<ItemStack>)((BackpackContainerContents)AutoPickupUpgrade.this.getDataHolderStack().get(ModDataComponents.BACKPACK_CONTAINER)).getItems());
                ((AutoPickupFilterSettings)AutoPickupUpgrade.this.getFilterSettings()).updateFilterTags((List)AutoPickupUpgrade.this.getDataHolderStack().get(ModDataComponents.FILTER_TAGS));
                AutoPickupUpgrade.this.changeListeners.forEach(Runnable::run);
            }
        };
    }
}

