/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.FilterUpgradeWidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;

public class VoidWidget
extends FilterUpgradeWidgetBase<VoidWidget, VoidUpgrade> {
    private static final List<Component> WHITELIST_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_allow_voiding"), Component.translatable((String)"screen.travelersbackpack.filter_block_voiding"), Component.translatable((String)"screen.travelersbackpack.filter_match_contents_voiding"));
    private static final List<Component> OBJECT_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_item"), Component.translatable((String)"screen.travelersbackpack.filter_modid"), Component.translatable((String)"screen.travelersbackpack.filter_tag"));
    private static final List<Component> IGNORE_MODE_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_match_components"), Component.translatable((String)"screen.travelersbackpack.filter_ignore_components"));

    public VoidWidget(BackpackScreen screen, VoidUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.void_upgrade");
        FilterButton<VoidWidget> whitelistButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(0), ButtonStates.ALLOW, new Point(pos.x() + 6, pos.y() + 22));
        FilterButton<VoidWidget> objectButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(1), ButtonStates.OBJECT_TYPE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        FilterButton<VoidWidget> ignoreModeButton = new FilterButton<VoidWidget>(this, upgrade.getFilter().get(2), ButtonStates.IGNORE_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));
        this.addFilterButton(whitelistButton);
        this.addFilterButton(objectButton);
        this.addFilterButton(ignoreModeButton);
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        this.renderMatchContentsSlotOverlay(guiGraphics, ((VoidUpgrade)this.upgrade).getFilter(), 0, 2, (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.filterSlotCount.get());
        if (this.isTabOpened() && !((VoidUpgrade)this.upgrade).isTagSelector()) {
            guiGraphics.fill(RenderPipelines.GUI, this.pos.x() + 7, this.pos.y() + 44, this.pos.x() + 6 + 17, this.pos.y() + 43 + 17, 2143884822);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened()) {
            if (!((VoidUpgrade)this.upgrade).isTagSelector() && ((VoidUpgrade)this.upgrade).getTrashSlotStack().isEmpty() && this.isWithinBounds(mouseX, mouseY, new Point(7, 44), new Point(17, 17))) {
                guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), List.of(Component.translatable((String)"screen.travelersbackpack.void_upgrade_trash_slot"), Component.translatable((String)"screen.travelersbackpack.void_upgrade_trash_slot_description")), Optional.empty(), mouseX, mouseY);
            }
            if (this.getFilterButton(ButtonStates.ALLOW).isMouseOver(mouseX, mouseY)) {
                guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), WHITELIST_TOOLTIPS.get(this.getFilterButton(ButtonStates.ALLOW).getCurrentState()), mouseX, mouseY);
            }
            if (this.getFilterButton(ButtonStates.OBJECT_TYPE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), OBJECT_TOOLTIPS.get(this.getFilterButton(ButtonStates.OBJECT_TYPE).getCurrentState()), mouseX, mouseY);
            }
            if (this.getFilterButton(ButtonStates.IGNORE_MODE).isMouseOver(mouseX, mouseY)) {
                guiGraphics.setTooltipForNextFrame(((BackpackScreen)this.screen).getFont(), IGNORE_MODE_TOOLTIPS.get(this.getFilterButton(ButtonStates.IGNORE_MODE).getCurrentState()), mouseX, mouseY);
            }
        }
    }
}

