/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundSlotPacket(int selectType, List<Integer> unsortables, List<Pair<Integer, Boolean>> memorizedSlots) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundSlotPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundSlotPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ServerboundSlotPacket::selectType, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), ServerboundSlotPacket::unsortables, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.mapPair((MapCodec)Codec.INT.fieldOf("index"), (MapCodec)Codec.BOOL.fieldOf("matchComponents")).codec()).apply(ByteBufCodecs.list()), ServerboundSlotPacket::memorizedSlots, ServerboundSlotPacket::new);
    public static final int UNSORTABLES = 0;
    public static final int MEMORY = 1;

    public static void handle(ServerboundSlotPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AbstractContainerMenu patt0$temp = serverPlayer.containerMenu;
                if (patt0$temp instanceof BackpackSettingsMenu) {
                    BackpackSettingsMenu menu = (BackpackSettingsMenu)patt0$temp;
                    if (message.selectType() == 0) {
                        menu.getWrapper().setUnsortableSlots(message.unsortables());
                    }
                    if (message.selectType() == 1) {
                        List<Pair<Integer, Pair<ItemStack, Boolean>>> oldMemoryStacks = menu.getWrapper().getMemorySlots();
                        ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>> memoryStacks = new ArrayList<Pair<Integer, Pair<ItemStack, Boolean>>>();
                        for (Pair<Integer, Boolean> memorizedSlot : message.memorizedSlots()) {
                            ItemStack retrievedStack;
                            ItemStack itemStack = retrievedStack = (Boolean)memorizedSlot.getSecond() != false ? menu.getSlot((Integer)memorizedSlot.getFirst()).getItem().copy() : menu.getSlot((Integer)memorizedSlot.getFirst()).getItem().getItem().getDefaultInstance();
                            if (retrievedStack.isEmpty()) {
                                for (Pair<Integer, Pair<ItemStack, Boolean>> oldMemorizedSlot : oldMemoryStacks) {
                                    if (!((Integer)oldMemorizedSlot.getFirst()).equals(memorizedSlot.getFirst())) continue;
                                    retrievedStack = (ItemStack)((Pair)oldMemorizedSlot.getSecond()).getFirst();
                                    break;
                                }
                            }
                            if (retrievedStack.isEmpty()) continue;
                            memoryStacks.add((Pair<Integer, Pair<ItemStack, Boolean>>)Pair.of((Object)((Integer)memorizedSlot.getFirst()), (Object)Pair.of((Object)retrievedStack, (Object)((Boolean)memorizedSlot.getSecond()))));
                        }
                        menu.getWrapper().setMemorySlots(memoryStacks);
                    }
                    menu.getWrapper().sendDataToClients((DataComponentType)ModDataComponents.SLOTS.get());
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

