/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tiviacz.travelersbackpack.client.model.BackpackModelPart;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class StackModelPart
extends BackpackModelPart {
    public List<ItemStack> prepare(ItemStack stack) {
        if (stack.has(ModDataComponents.TOOLS_CONTAINER)) {
            return new ArrayList<ItemStack>((Collection<ItemStack>)((BackpackContainerContents)stack.get(ModDataComponents.TOOLS_CONTAINER)).getItems()).stream().filter(itemStack -> !itemStack.isEmpty()).toList();
        }
        return new ArrayList<ItemStack>();
    }

    public void render(ItemStack backpack, MultiBufferSource buffer, PoseStack poseStack, int light, int overlay) {
        if (buffer == null) {
            return;
        }
        this.render(this.prepare(backpack), poseStack, buffer, light, overlay);
    }

    public void render(List<ItemStack> tools, PoseStack poseStack, MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        BakedModel model;
        if (tools.isEmpty()) {
            return;
        }
        ItemStack toolUpper = tools.get(0);
        ItemStack toolLower = ItemStack.EMPTY;
        if (!toolUpper.isEmpty() && tools.size() > 1) {
            toolLower = tools.get(tools.size() - 1);
        }
        poseStack.pushPose();
        if (!toolUpper.isEmpty()) {
            model = Minecraft.getInstance().getItemRenderer().getModel(toolUpper, null, null, 0);
            model = this.applyTransform(model, poseStack);
            poseStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(0.04, 0.075, 0.17);
            poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            Minecraft.getInstance().getItemRenderer().render(toolUpper, ItemDisplayContext.NONE, false, poseStack, buffer, pPackedLight, pPackedOverlay, model);
            RenderSystem.disableBlend();
            poseStack.popPose();
        }
        if (!toolLower.isEmpty()) {
            model = Minecraft.getInstance().getItemRenderer().getModel(toolLower, null, null, 0);
            model = this.applyTransform(model, poseStack);
            poseStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            poseStack.translate(-0.25, 0.75, -0.025);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            Minecraft.getInstance().getItemRenderer().render(toolLower, ItemDisplayContext.NONE, false, poseStack, buffer, pPackedLight, pPackedOverlay, model);
            RenderSystem.disableBlend();
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public BakedModel applyTransform(BakedModel model, PoseStack poseStack) {
        return model.applyTransform(ItemDisplayContext.NONE, poseStack, false);
    }
}

