/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SortingButtons
extends WidgetBase<BackpackScreen> {
    public SortingButtons(BackpackScreen screen, Point pos, int width, int height) {
        super(screen, pos, width, height);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.blit(BackpackScreen.ICONS, this.pos.x(), this.pos.y(), 77, 54, this.width, this.height);
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.SORT)) {
            guiGraphics.blit(BackpackScreen.ICONS, this.pos.x() + 1, this.pos.y() + 2, 78, 69, 12, 12);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.QUICK_STACK)) {
            guiGraphics.blit(BackpackScreen.ICONS, this.pos.x() + 13, this.pos.y() + 2, 90, 69, 12, 12);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.TRANSFER_TO_BACKPACK)) {
            guiGraphics.blit(BackpackScreen.ICONS, this.pos.x() + 25, this.pos.y() + 2, 102, 69, 12, 12);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.TRANSFER_TO_PLAYER)) {
            guiGraphics.blit(BackpackScreen.ICONS, this.pos.x() + 37, this.pos.y() + 2, 114, 69, 12, 12);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> list;
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.SORT)) {
            list = new ArrayList<MutableComponent>();
            list.add(Component.translatable((String)"screen.travelersbackpack.sort"));
            list.add(Component.translatable((String)"screen.travelersbackpack.sort_shift"));
            list.add(Component.translatable((String)("screen.travelersbackpack.sort_" + ((BackpackScreen)this.screen).getWrapper().getSortType().name().toLowerCase())));
            guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), list, Optional.empty(), mouseX, mouseY);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.QUICK_STACK)) {
            list = new ArrayList();
            list.add(Component.translatable((String)"screen.travelersbackpack.quick_stack"));
            list.add(Component.translatable((String)"screen.travelersbackpack.quick_stack_shift"));
            guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), list, Optional.empty(), mouseX, mouseY);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.TRANSFER_TO_BACKPACK)) {
            list = new ArrayList();
            list.add(Component.translatable((String)"screen.travelersbackpack.transfer_to_backpack"));
            list.add(Component.translatable((String)"screen.travelersbackpack.transfer_to_backpack_shift"));
            guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), list, Optional.empty(), mouseX, mouseY);
        }
        if (this.isButtonHovered(this.pos, mouseX, mouseY, Buttons.TRANSFER_TO_PLAYER)) {
            guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), (Component)Component.translatable((String)"screen.travelersbackpack.transfer_to_player"), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isButtonHovered(this.pos, (int)mouseX, (int)mouseY, Buttons.SORT)) {
            ServerboundActionTagPacket.create(3, 0, KeyHelper.isShiftPressed());
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isButtonHovered(this.pos, (int)mouseX, (int)mouseY, Buttons.QUICK_STACK)) {
            ServerboundActionTagPacket.create(3, 1, KeyHelper.isShiftPressed());
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isButtonHovered(this.pos, (int)mouseX, (int)mouseY, Buttons.TRANSFER_TO_BACKPACK)) {
            ServerboundActionTagPacket.create(3, 2, KeyHelper.isShiftPressed());
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isButtonHovered(this.pos, (int)mouseX, (int)mouseY, Buttons.TRANSFER_TO_PLAYER)) {
            ServerboundActionTagPacket.create(3, 3, KeyHelper.isShiftPressed());
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }

    public boolean isButtonHovered(int mouseX, int mouseY, Buttons button) {
        return 65 + button.ordinal() * 11 + ((BackpackScreen)this.screen).getGuiLeft() <= mouseX && mouseX <= 65 + button.ordinal() * 11 + 8 + ((BackpackScreen)this.screen).getGuiLeft() && -6 + ((BackpackScreen)this.screen).getGuiTop() <= mouseY && mouseY <= 2 + ((BackpackScreen)this.screen).getGuiTop();
    }

    public boolean isButtonHovered(Point pos, int mouseX, int mouseY, Buttons button) {
        return pos.x() + 4 + button.ordinal() * 11 <= mouseX && mouseX <= pos.x() + 4 + button.ordinal() * 11 + 8 && pos.y() + 4 <= mouseY && mouseY <= pos.y() + 4 + 8;
    }

    public static enum Buttons {
        SORT,
        QUICK_STACK,
        TRANSFER_TO_BACKPACK,
        TRANSFER_TO_PLAYER;

    }
}

