/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.util.FluidStackHelper;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class InventoryActions {
    public static boolean transferContainerTank(TanksUpgrade upgrade, FluidTank tank, int slotIn) {
        Optional fluidHandler;
        boolean hasFluidHandler;
        ItemStackHandler itemStackHandler = upgrade.getFluidSlotsHandler();
        ItemStack stackIn = itemStackHandler.getStackInSlot(slotIn);
        int slotOut = slotIn + 1;
        if (tank == null || stackIn.isEmpty() || stackIn.getItem() == Items.AIR) {
            return false;
        }
        if (stackIn.getItem() instanceof PotionItem && stackIn.getItem() != Items.GLASS_BOTTLE && !(hasFluidHandler = FluidUtil.getFluidHandler((ItemStack)stackIn).isPresent())) {
            int amount = 250;
            FluidStack fluidStack = new FluidStack((Fluid)ModFluids.POTION_FLUID.get(), amount);
            int potionType = 0;
            if (stackIn.getItem() == Items.SPLASH_POTION) {
                potionType = 1;
            }
            if (stackIn.getItem() == Items.LINGERING_POTION) {
                potionType = 2;
            }
            FluidStackHelper.setFluidStackData(stackIn, fluidStack, potionType);
            if ((tank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)fluidStack)) && tank.getFluidAmount() + amount <= tank.getCapacity()) {
                ItemStack bottle = potionType != 0 ? ItemStack.EMPTY.copy() : new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                ItemStack currentStackOut = itemStackHandler.getStackInSlot(slotOut);
                if (currentStackOut.isEmpty() || currentStackOut.getItem() == bottle.getItem() || bottle.isEmpty()) {
                    if (currentStackOut.getItem() == bottle.getItem() && !bottle.isEmpty()) {
                        if (currentStackOut.getCount() + 1 > currentStackOut.getMaxStackSize()) {
                            return false;
                        }
                        bottle.setCount(itemStackHandler.getStackInSlot(slotOut).getCount() + 1);
                    }
                    tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    InventoryHelper.removeItem((IItemHandlerModifiable)upgrade.getFluidSlotsHandler(), slotIn, 1);
                    if (!bottle.isEmpty()) {
                        itemStackHandler.setStackInSlot(slotOut, bottle);
                    }
                    InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), SoundEvents.BREWING_STAND_BREW, true);
                    return true;
                }
            }
        }
        if (stackIn.getItem() == Items.GLASS_BOTTLE && tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get() && tank.getFluidAmount() >= 250) {
            ItemStack stackOut = FluidStackHelper.getItemStackFromFluidStack(tank.getFluid());
            ItemStack currentStackOut = itemStackHandler.getStackInSlot(slotOut);
            if (currentStackOut.isEmpty()) {
                tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
                InventoryHelper.removeItem((IItemHandlerModifiable)upgrade.getFluidSlotsHandler(), slotIn, 1);
                itemStackHandler.setStackInSlot(slotOut, stackOut);
                InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), SoundEvents.BREWING_STAND_BREW, false);
                return true;
            }
        }
        if ((fluidHandler = FluidUtil.getFluidHandler((ItemStack)stackIn)).isPresent()) {
            ItemStack slotOutStack;
            ItemStack stackOut;
            SoundEvent fluidSound;
            FluidTank tankCopy;
            Optional fluidstack = FluidUtil.getFluidContained((ItemStack)stackIn);
            if (fluidstack.isPresent() && fluidstack.map(FluidStack::getAmount).orElse(0) > 0) {
                int amount = fluidstack.map(FluidStack::getAmount).orElse(0);
                if (tank.getFluidAmount() > 0 && !FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)fluidstack.orElse(FluidStack.EMPTY))) {
                    return false;
                }
                ItemStack stackInCopy = stackIn.copy();
                tankCopy = new FluidTank(tank.getCapacity());
                tankCopy.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                fluidSound = tank.getFluid().getFluidType().getSound(tank.getFluid(), SoundActions.BUCKET_EMPTY);
                stackOut = FluidUtil.tryEmptyContainer((ItemStack)stackInCopy, (IFluidHandler)tankCopy, (int)amount, null, (boolean)false).getResult();
                if (!stackOut.isEmpty() && ((slotOutStack = itemStackHandler.getStackInSlot(slotOut)).isEmpty() || slotOutStack.getItem() == stackOut.getItem())) {
                    if (slotOutStack.getItem() == stackOut.getItem()) {
                        stackOut.setCount(slotOutStack.getCount() + 1);
                        if (stackOut.getCount() > slotOutStack.getMaxStackSize()) {
                            return false;
                        }
                    }
                    InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), fluidSound, false);
                    FluidUtil.tryEmptyContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, null, (boolean)true);
                    itemStackHandler.setStackInSlot(slotOut, stackOut);
                    InventoryHelper.removeItem((IItemHandlerModifiable)upgrade.getFluidSlotsHandler(), slotIn, 1);
                    return true;
                }
            }
            if (tank.isEmpty() || tank.getFluidAmount() <= 0) {
                return false;
            }
            if (InventoryActions.isFluidEqual(stackIn, tank)) {
                int amount = FluidUtil.getFluidHandler((ItemStack)stackIn).map(iFluidHandlerItem -> iFluidHandlerItem.getTankCapacity(0)).orElse(0);
                ItemStack stackInCopy = stackIn.copy();
                tankCopy = new FluidTank(tank.getCapacity());
                tankCopy.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                fluidSound = tank.getFluid().getFluidType().getSound(tank.getFluid(), SoundActions.BUCKET_FILL);
                stackOut = FluidUtil.tryFillContainer((ItemStack)stackInCopy, (IFluidHandler)tankCopy, (int)amount, null, (boolean)true).getResult();
                if (stackOut.isEmpty()) {
                    return false;
                }
                slotOutStack = itemStackHandler.getStackInSlot(slotOut);
                if (slotOutStack.isEmpty() || slotOutStack.getItem() == stackOut.getItem()) {
                    if (slotOutStack.getItem() == stackOut.getItem()) {
                        stackOut.setCount(slotOutStack.getCount() + 1);
                        if (stackOut.getCount() > slotOutStack.getMaxStackSize()) {
                            return false;
                        }
                    }
                    InventoryActions.playFluidSound(upgrade.getUpgradeManager().getWrapper().getBackpackOwner(), upgrade.getUpgradeManager().getWrapper().getPlayersUsing(), fluidSound, true);
                    FluidUtil.tryFillContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, null, (boolean)true);
                    itemStackHandler.setStackInSlot(slotOut, stackOut);
                    InventoryHelper.removeItem((IItemHandlerModifiable)upgrade.getFluidSlotsHandler(), slotIn, 1);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isFluidEqual(ItemStack stackIn, FluidTank tank) {
        if (FluidUtil.getFluidContained((ItemStack)stackIn).isPresent() && FluidUtil.getFluidContained((ItemStack)stackIn).map(FluidStack::getAmount).orElse(0) > 0) {
            return FluidUtil.getFluidContained((ItemStack)stackIn).map(fluidstack -> FluidStack.isSameFluidSameComponents((FluidStack)fluidstack, (FluidStack)tank.getFluid())).orElse(false);
        }
        return !FluidUtil.getFluidContained((ItemStack)stackIn).isPresent();
    }

    public static void playFluidSound(@Nullable Player player, List<Player> usingPlayers, SoundEvent soundEvent, boolean fill) {
        if (soundEvent == null) {
            soundEvent = fill ? SoundEvents.BUCKET_FILL : SoundEvents.BUCKET_EMPTY;
        }
        if (player != null) {
            player.level().playSound(null, player.position().x(), player.position().y() + 0.5, player.position().z(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (!usingPlayers.isEmpty()) {
            BackpackBaseMenu menu;
            Player user = usingPlayers.get(0);
            AbstractContainerMenu abstractContainerMenu = user.containerMenu;
            if (abstractContainerMenu instanceof BackpackBlockEntityMenu) {
                menu = (BackpackBlockEntityMenu)abstractContainerMenu;
                Vec3 backpackPos = menu.getWrapper().getBackpackPos().getCenter();
                ((BackpackBlockEntityMenu)menu).player.level().playSound(null, backpackPos.x(), backpackPos.y() + 0.5, backpackPos.z(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if ((abstractContainerMenu = user.containerMenu) instanceof BackpackItemMenu && (menu = (BackpackItemMenu)abstractContainerMenu).getWrapper().getScreenID() == 1 && !((BackpackItemMenu)menu).player.level().isClientSide) {
                ((BackpackItemMenu)menu).player.playNotifySound(soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

