/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.items.HoseItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ToolSlotItemHandler
extends SlotItemHandler {
    private final BackpackWrapper wrapper;
    public static final List<Item> TOOL_SLOTS_ACCEPTABLE_ITEMS = new ArrayList<Item>();

    public ToolSlotItemHandler(BackpackWrapper wrapper, int index, int xPosition, int yPosition) {
        super((IItemHandler)wrapper.getTools(), index, xPosition, yPosition);
        this.wrapper = wrapper;
    }

    public boolean isActive() {
        return this.wrapper.showToolSlots();
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        return super.mayPlace(stack) && this.isActive();
    }

    public boolean mayPickup(Player playerIn) {
        return super.mayPickup(playerIn) && this.isActive();
    }

    public static boolean isValid(ItemStack stack) {
        if (stack.getItem() instanceof HoseItem) {
            return false;
        }
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.toolSlotsAcceptEverything.get()).booleanValue()) {
            return BackpackSlotItemHandler.isItemValid(stack);
        }
        if (stack.is(ModTags.ACCEPTABLE_TOOLS)) {
            return true;
        }
        if (TOOL_SLOTS_ACCEPTABLE_ITEMS.contains(stack.getItem())) {
            return true;
        }
        if (stack.getItem() instanceof TieredItem || stack.getItem() instanceof HoeItem || stack.getItem() instanceof FishingRodItem || stack.getItem() instanceof ShearsItem || stack.getItem() instanceof FlintAndSteelItem || stack.getItem() instanceof ProjectileWeaponItem || stack.getItem() instanceof BrushItem || stack.getItem() instanceof TridentItem || stack.getItem() instanceof MaceItem || stack.getItem() instanceof SpyglassItem) {
            return true;
        }
        return stack.has(DataComponents.TOOL);
    }

    public void setChanged() {
        super.setChanged();
    }
}

