package com.tiviacz.travelersbackpack;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.client.renderer.BackpackEntityLayer;
import com.tiviacz.travelersbackpack.client.renderer.BackpackLayer;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.HudOverlay;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.client.screens.tooltip.ClientBackpackTooltipComponent;
import com.tiviacz.travelersbackpack.commands.BackpackIconCommands;
import com.tiviacz.travelersbackpack.compat.accessories.TravelersBackpackAccessory;
import com.tiviacz.travelersbackpack.compat.polymorph.PolymorphCompat;
import com.tiviacz.travelersbackpack.compat.trinkets.TravelersBackpackTrinket;
import com.tiviacz.travelersbackpack.fluids.potion.PotionFluidVariantAttributeHandler;
import com.tiviacz.travelersbackpack.fluids.potion.PotionFluidVariantRenderHandler;
import com.tiviacz.travelersbackpack.handlers.BackpackModelLoadingPlugin;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.handlers.ScreenRenderHandler;
import com.tiviacz.travelersbackpack.init.*;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.client.rendering.v1.*;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1007;
import net.minecraft.class_1091;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_5253;
import net.minecraft.class_572;
import net.minecraft.class_7923;
import net.minecraft.class_916;
import net.minecraft.class_922;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.List;

@Environment(EnvType.CLIENT)
public class TravelersBackpackClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        //Handled Screens
        class_3929.method_17542(ModScreenHandlerTypes.BACKPACK_MENU, BackpackScreen::new);
        class_3929.method_17542(ModScreenHandlerTypes.BACKPACK_BLOCK_MENU, BackpackScreen::new);
        class_3929.method_17542(ModScreenHandlerTypes.BACKPACK_SETTINGS_MENU, BackpackSettingsScreen::new);

        //Feature renderers
        registerFeatureRenderers();

        //Hud Overlay
        registerHudOverlay();

        //Backpack Tooltip
        registerTooltipComponent();

        //Keybindings
        KeybindHandler.initKeybinds();
        KeybindHandler.registerListener();

        //Client Network
        ModNetwork.initClient();

        //Hose Model Predicate
        registerModelPredicate();

        //Fluids Rendering
        setupFluidRendering();

        //Backpack Item Entity
        registerBackpackItemEntityRenderer();

        //Client Commands
        registerClientCommands();

        //Polymorph Integration
        if(TravelersBackpack.polymorphLoaded) PolymorphCompat.registerWidget();

        //Backpack model loading plugin
        ModelLoadingPlugin.register(new BackpackModelLoadingPlugin());

        //Color providers
        registerItemColorProvider();
        registerBlockColorProvider();

        //Render Layers
        registerBackpackRenderLayers();

        //Screen Handlers
        ScreenRenderHandler.registerScreenEvents();

        //Crafting Tweaks Integration
        //if(TravelersBackpack.craftingTweaksLoaded) TravelersBackpackCraftingGridProvider.registerClient();
        if(TravelersBackpack.accessoriesLoaded) TravelersBackpackAccessory.initClient();
        if(TravelersBackpack.trinketsLoaded) TravelersBackpackTrinket.initClient();
    }

    public static final class_1091 STAR_MODEL = new class_1091(class_2960.method_60655(TravelersBackpack.MODID, "item/supporter_star"), "standalone");

    public static void registerBackpackItemEntityRenderer() {
        EntityRendererRegistry.register(ModItems.BACKPACK_ITEM_ENTITY, class_916::new);
    }

    public static void registerItemColorProvider() {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if(tintIndex != 0) {
                return -1;
            }
            if(stack.method_57826(class_9334.field_49644)) {
                return class_5253.class_5254.method_57174(stack.method_57824(class_9334.field_49644).comp_2384());
            }
            return -1;
        }, ModBlocks.STANDARD_TRAVELERS_BACKPACK);
    }

    public static void registerBlockColorProvider() {
        ColorProviderRegistry.BLOCK.register((state, view, pos, tintIndex) -> {
            if(tintIndex != 0 || pos == null) {
                return -1;
            }
            if(view.method_8321(pos) instanceof BackpackBlockEntity backpack) {
                if(backpack.getWrapper().getBackpackStack().method_57826(class_9334.field_49644)) {
                    return class_5253.class_5254.method_57174(backpack.getWrapper().getBackpackStack().method_57824(class_9334.field_49644).comp_2384());
                }
            }
            return -1;
        }, ModBlocks.STANDARD_TRAVELERS_BACKPACK);
    }

    public static void registerBackpackRenderLayers() {
        List<class_2248> cutout = new ArrayList<>(class_7923.field_41175.method_10220().filter(block -> block instanceof TravelersBackpackBlock).toList());
        cutout.removeIf(block -> block == ModBlocks.QUARTZ_TRAVELERS_BACKPACK);
        cutout.removeIf(block -> block == ModBlocks.SNOW_TRAVELERS_BACKPACK);

        cutout.forEach(block -> BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581()));
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.QUARTZ_TRAVELERS_BACKPACK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.SNOW_TRAVELERS_BACKPACK, class_1921.method_23583());
    }

    public static void registerFeatureRenderers() {
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) ->
        {
            if(entityRenderer instanceof class_1007 renderer) {
                registrationHelper.register(new BackpackLayer(renderer));
            }
            if(entityRenderer.method_4038() instanceof class_572 && entityRenderer instanceof class_922) {
                if(entityRenderer instanceof class_1007) return;
                registrationHelper.register(new BackpackEntityLayer((class_922<class_1309, class_572<class_1309>>)entityRenderer));
            }
        });
    }

    public static void registerHudOverlay() {
        HudRenderCallback.EVENT.register(HudOverlay::renderOverlay);
    }

    public static void setupFluidRendering() {
        FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.POTION_STILL, ModFluids.POTION_FLOWING, new SimpleFluidRenderHandler(
                class_2960.method_60655(TravelersBackpack.MODID, "block/potion_still"),
                class_2960.method_60655(TravelersBackpack.MODID, "block/potion_flow"),
                13458603
        ));

        //FluidRenderHandlerRegistry.INSTANCE.register(ModFluids.MILK_STILL, ModFluids.MILK_FLOWING, new SimpleFluidRenderHandler(
        //        ResourceLocation.fromNamespaceAndPath(TravelersBackpack.MODID, "block/milk_still"),
        //        ResourceLocation.fromNamespaceAndPath(TravelersBackpack.MODID, "block/milk_flow"),
        //        0xFFFFFFFF
        //));

        FluidVariantAttributes.register(ModFluids.POTION_STILL, new PotionFluidVariantAttributeHandler());
        FluidVariantAttributes.register(ModFluids.POTION_FLOWING, new PotionFluidVariantAttributeHandler());
        FluidVariantRendering.register(ModFluids.POTION_STILL, new PotionFluidVariantRenderHandler());
        FluidVariantRendering.register(ModFluids.POTION_FLOWING, new PotionFluidVariantRenderHandler());

        //FluidVariantAttributes.register(ModFluids.MILK_STILL, new MilkFluidVariantAttributeHandler());
        //FluidVariantAttributes.register(ModFluids.MILK_FLOWING, new MilkFluidVariantAttributeHandler());

        BlockRenderLayerMap.INSTANCE.putFluids(class_1921.method_23583(), ModFluids.POTION_STILL, ModFluids.POTION_FLOWING);
        //BlockRenderLayerMap.INSTANCE.putFluids(RenderType.translucent(), ModFluids.MILK_STILL, ModFluids.MILK_FLOWING);
    }

    public static void registerTooltipComponent() {
        TooltipComponentCallback.EVENT.register((data ->
        {
            if(data instanceof BackpackTooltipComponent) {
                return new ClientBackpackTooltipComponent((BackpackTooltipComponent)data);
            }
            return null;
        }));
    }

    public static void registerModelPredicate() {
        FabricModelPredicateProviderRegistry.register(ModItems.HOSE, class_2960.method_60655(TravelersBackpack.MODID, "mode"), (itemStack, clientWorld, livingEntity, par) ->
        {
            if(itemStack.method_57826(ModDataComponents.HOSE_MODES)) {
                int mode = itemStack.method_57824(ModDataComponents.HOSE_MODES).get(0);
                return (float)mode / 10.0F;
            }
            return 0.0F;
        });
    }

    public static void registerClientCommands() {
        ClientCommandRegistrationCallback.EVENT.register(BackpackIconCommands::new);
    }
}