package com.tiviacz.travelersbackpack.attachment;

import com.mojang.serialization.Codec;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.Reference;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9323;

/**
 * Preparation for removal of the required Cardinal Components dependency.
 * This class is not used in version 1.21.x.
 * Use the component TravelersBackpackComponent instead.
 * Currently, this class is only used for data transfer purposes.
 */
public class TravelersBackpackAttachment implements ITravelersBackpackAttachment {
    public static Codec<TravelersBackpackAttachment> CODEC = class_1799.field_49266.xmap(TravelersBackpackAttachment::new, TravelersBackpackAttachment::getBackpack);
    public static class_9139<class_9129, TravelersBackpackAttachment> STREAM_CODEC = class_1799.field_49268.method_56432(TravelersBackpackAttachment::new, TravelersBackpackAttachment::getBackpack);
    public static TravelersBackpackAttachment DEFAULT = new TravelersBackpackAttachment(new class_1799(class_1802.field_8162, 0));

    public BackpackWrapper backpackWrapper;
    public class_1799 backpack = new class_1799(class_1802.field_8162, 0);

    public TravelersBackpackAttachment(class_1799 backpack) {
        this.backpack = backpack;
    }

    @Override
    public boolean hasBackpack() {
        return this.backpack.method_7909() instanceof TravelersBackpackItem;
    }

    public class_1799 getBackpack() {
        return this.backpack;
    }

    @Override
    public void equipBackpack(class_1799 stack, class_1657 player) {
        this.remove(player);
        if(!(stack.method_7909() instanceof TravelersBackpackItem)) return;

        this.backpack = stack;
        this.backpackWrapper = new BackpackWrapper(this.backpack, Reference.WEARABLE_SCREEN_ID, player, player.method_37908());
        this.backpackWrapper.setBackpackOwner(player);

        //Update client
        synchronise(player);
    }

    @Override
    public void updateBackpack(class_1799 stack, class_1657 player) {
        if(this.backpackWrapper != null) {
            this.backpack = stack;
            this.backpackWrapper.setBackpackStack(this.backpack);
        } else {
            equipBackpack(stack, player);
        }
    }

    @Override
    public void applyComponents(class_9323 map) {
        if(this.backpackWrapper != null) {
            this.backpack.method_57365(map);
            this.backpackWrapper.setBackpackStack(this.backpack);
        }
    }

    @Override
    public void removeWearable() {
        this.backpack = new class_1799(class_1802.field_8162, 0);
    }

    @Override
    public void removeWrapper() {
        if(this.backpackWrapper != null) {
            this.backpackWrapper = null;
        }
    }

    @Override
    public void remove(class_1657 player) {
        removeWearable();
        removeWrapper();

        //Update client to remove old backpack wrapper
        /*if(this.player.level() != null && !this.player.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf(this.player, new ClientboundSyncAttachmentPacket(this.player.getId(), this.backpack, true));
        }*/
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.backpackWrapper;
    }

    @Override
    public void synchronise(class_1657 player) {

    }

    @Override
    public void synchronise(class_9323 map, class_1657 player) {

    }
}