package com.tiviacz.travelersbackpack.blocks;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_8567;

public class SleepingBagBlock extends class_2244 {
    public static final class_2754<class_2742> PART = class_2741.field_12483;
    public static final class_2746 OCCUPIED = class_2741.field_12528;
    public static final class_2746 CAN_DROP = class_2741.field_12486;
    protected static final class_265 SLEEPING_BAG = class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 2.0D, 16.0D);

    protected static final class_265 SLEEPING_BAG_NORTH = Stream.of(
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 2.0D, 16.0D),
            class_2248.method_9541(0.0D, 2.0D, 0.0D, 16.0D, 2.5D, 8.0D)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    protected static final class_265 SLEEPING_BAG_EAST = Stream.of(
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 2.0D, 16.0D),
            class_2248.method_9541(8.0D, 2.0D, 0.0D, 16.0D, 2.5D, 16.0D)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    protected static final class_265 SLEEPING_BAG_SOUTH = Stream.of(
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 2.0D, 16.0D),
            class_2248.method_9541(0.0D, 2.0D, 8.0D, 16.0D, 2.5D, 16.0D)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    protected static final class_265 SLEEPING_BAG_WEST = Stream.of(
            class_2248.method_9541(0.0D, 0.0D, 0.0D, 16.0D, 2.0D, 16.0D),
            class_2248.method_9541(0.0D, 2.0D, 0.0D, 8.0D, 2.5D, 16.0D)
    ).reduce((v1, v2) -> class_259.method_1072(v1, v2, class_247.field_1366)).get();

    public SleepingBagBlock(class_1767 color, class_2251 properties) {
        super(color, properties.method_51369());
        this.method_9590(this.field_10647.method_11664().method_11657(field_9967, class_2742.field_12557).method_11657(field_9968, Boolean.FALSE).method_11657(CAN_DROP, Boolean.TRUE));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 getter, class_2338 pos, class_3726 context) {
        return switch(state.method_11654(field_9967)) {
            case field_12557 -> SLEEPING_BAG;
            case field_12560 -> switch(state.method_11654(field_11177)) {
                case field_11034 -> SLEEPING_BAG_EAST;
                case field_11035 -> SLEEPING_BAG_SOUTH;
                case field_11039 -> SLEEPING_BAG_WEST;
                default -> SLEEPING_BAG_NORTH;
            };
        };
    }

    @Override
    protected class_1269 method_55766(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_3965 pHitResult) {
        if(pLevel.field_9236) {
            return class_1269.field_21466;
        } else {
            if(pState.method_11654(field_9967) != class_2742.field_12560) {
                pPos = pPos.method_10093(pState.method_11654(field_11177));
                pState = pLevel.method_8320(pPos);
                if(!pState.method_27852(this)) {
                    return class_1269.field_21466;
                }
            }

            if(!method_27352(pLevel)) {
                pLevel.method_8650(pPos, false);
                class_2338 blockpos = pPos.method_10093(pState.method_11654(field_11177).method_10153());
                if(pLevel.method_8320(blockpos).method_27852(this)) {
                    pLevel.method_8650(blockpos, false);
                }

                if(pLevel.method_8321(pPos.method_10079(pState.method_11654(field_11177).method_10153(), pState.method_11654(field_9967) == class_2742.field_12557 ? 1 : 2)) instanceof BackpackBlockEntity blockEntity) {
                    blockEntity.setSleepingBagDeployed(false);
                }

                //Vec3 vec3 = pPos.getCenter();
                //pLevel.explode(null, pLevel.damageSources().badRespawnPointExplosion(vec3), null, vec3, 5.0F, true, Level.ExplosionInteraction.BLOCK);
                return class_1269.field_5812;
            } else if(pState.method_11654(field_9968)) {
                if(!this.method_22357(pLevel, pPos)) {
                    pPlayer.method_7353(class_2561.method_43471("block.minecraft.bed.occupied"), true);
                }

                return class_1269.field_5812;
            } else {
                if(TravelersBackpackConfig.getConfig().backpackSettings.enableSleepingBagSpawnPoint) {
                    if(pPlayer instanceof class_3222 serverPlayer) {
                        serverPlayer.method_26284(pLevel.method_27983(), pPos, serverPlayer.method_36454(), true, true);
                    }
                }
                pPlayer.method_7269(pPos).ifLeft(p_49477_ -> {
                    if(p_49477_.method_19206() != null) {
                        pPlayer.method_7353(p_49477_.method_19206(), true);
                    }
                });
                return class_1269.field_5812;
            }
        }
    }

    private boolean method_22357(class_1937 level, class_2338 pos) {
        List<class_1646> var3 = level.method_8390(class_1646.class, new class_238(pos), class_1309::method_6113);
        if(var3.isEmpty()) {
            return false;
        } else {
            var3.get(0).method_18400();
            return true;
        }
    }

    @Override
    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float factor) {
        super.method_9554(level, state, pos, entity, factor * 0.75F);
    }

    @Override
    public void method_9502(class_1922 getter, class_1297 entity) {
        if(entity.method_21750()) {
            super.method_9502(getter, entity);
        } else {
            this.method_21838(entity);
        }

    }

    private void method_21838(class_1297 entity) {
        class_243 var2 = entity.method_18798();
        if(var2.field_1351 < 0.0D) {
            double var3 = entity instanceof class_1309 ? 1.0D : 0.8D;
            entity.method_18800(var2.field_1352, -var2.field_1351 * 0.3300000262260437D * var3, var2.field_1350);
        }
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 accessor, class_2338 pos, class_2338 newPos) {
        if(direction == method_9488(state.method_11654(field_9967), state.method_11654(field_11177))) {
            return newState.method_27852(this) && newState.method_11654(field_9967) != state.method_11654(field_9967) ? state.method_11657(field_9968, newState.method_11654(field_9968)) : class_2246.field_10124.method_9564();
        } else {
            return super.method_9559(state, direction, newState, accessor, pos, newPos);
        }
    }

    private static class_2350 method_9488(class_2742 part, class_2350 direction) {
        return part == class_2742.field_12557 ? direction : direction.method_10153();
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        boolean isFoot = state.method_11654(field_9967) == class_2742.field_12557;

        class_2338 backpackPos = isFoot ? pos.method_10093(state.method_11654(field_11177).method_10153()) : pos.method_10079(state.method_11654(field_11177).method_10153(), 2);

        if(level.method_8321(backpackPos) instanceof BackpackBlockEntity blockEntity) {
            blockEntity.setSleepingBagDeployed(false);
        }
        return super.method_9576(level, pos, state, player);
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction = context.method_8042();
        class_2338 blockpos = context.method_8037();
        class_2338 blockpos1 = blockpos.method_10093(direction);
        return context.method_8045().method_8320(blockpos1).method_26166(context) ? this.method_9564().method_11657(field_11177, direction) : null;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_11177, field_9967, field_9968, CAN_DROP);
    }

    @Override
    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 livingEntity, class_1799 itemstack) {
        super.method_9567(level, pos, state, livingEntity, itemstack);
        if(!level.field_9236) {
            class_2338 var6 = pos.method_10093(state.method_11654(field_11177));
            level.method_8652(var6, state.method_11657(field_9967, class_2742.field_12560), 3);
            level.method_8408(pos, class_2246.field_10124);
            state.method_30101(level, pos, 3);
        }
    }

    @Override
    public long method_9535(class_2680 state, class_2338 pos) {
        class_2338 var3 = pos.method_10079(state.method_11654(field_11177), state.method_11654(field_9967) == class_2742.field_12560 ? 0 : 1);
        return class_3532.method_15371(var3.method_10263(), pos.method_10264(), var3.method_10260());
    }

    @Override
    public List<class_1799> method_9560(class_2680 pState, class_8567.class_8568 pParams) {
        if(!pState.method_11654(CAN_DROP)) {
            return List.of();
        }
        return super.method_9560(pState, pParams);
    }

    @Override
    public class_2586 method_10123(class_2338 p_152175_, class_2680 p_152176_) {
        return null;
    }
}