package com.tiviacz.travelersbackpack.client.model;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_804;
import net.minecraft.class_806;
import net.minecraft.class_809;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;

public class BackpackBakedModel implements class_1087 {
    private final BackpackBakedQuadCollector bakedQuads;
    private static final class_809 ITEM_TRANSFORMS = createItemTransforms();

    public BackpackBakedModel(class_1087 backpack, class_1087 dyedBackpack) {
        this.bakedQuads = new BackpackBakedQuadCollector(backpack, dyedBackpack);
        class_5819 random = class_5819.method_43049(0);
        this.bakedQuads.collectBakedQuads(null, random);
    }

    @Override
    public boolean isVanillaAdapter() {
        return false;
    }

    @Override
    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        BackpackBlockEntity.BackpackRenderData renderData = (BackpackBlockEntity.BackpackRenderData)blockView.getBlockEntityRenderData(pos);
        if(renderData == null) {
            renderData = new BackpackBlockEntity.BackpackRenderData(RenderInfo.EMPTY, -1, false, class_1767.field_7964.method_7789());
        }
        RenderInfo info = renderData.info() == null ? RenderInfo.EMPTY : renderData.info();

        //collectBakedQuads(state, randomSupplier.get()); //#TODO?

        class_2350 direction = class_2350.field_11043;
        if(state.method_11654(TravelersBackpackBlock.FACING) != null) {
            direction = state.method_11654(TravelersBackpackBlock.FACING);
        }
        int index = direction.method_10161();

        if(state.method_26204() == ModBlocks.STANDARD_TRAVELERS_BACKPACK && renderData.dyeColor() != -1) {
            emitDyedBaseQuads(context.getEmitter(), index);
        } else {
            emitBaseQuads(context.getEmitter());
        }
        emitTanksQuads(context.getEmitter(), info, index);
        if(!renderData.isSleepingBagDeployed()) {
            emitSleepingBagQuads(context.getEmitter(), renderData.sleepingBagColor());
        }
        emitExtras(context.getEmitter(), new class_1799(state.method_26204()).method_7909());
    }

    @Override
    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        RenderInfo info = stack.method_57824(ModDataComponents.RENDER_INFO);
        int color = stack.method_57825(ModDataComponents.SLEEPING_BAG_COLOR, class_1767.field_7964.method_7789());
        int dyeColor = stack.method_57825(class_9334.field_49644, new class_9282(-1, false)).comp_2384();

        if(stack.method_7909() == ModItems.STANDARD_TRAVELERS_BACKPACK && dyeColor != -1) {
            emitDyedBaseQuads(context.getEmitter(), 0);
        } else {
            emitBaseQuads(context.getEmitter());
        }
        emitTanksQuads(context.getEmitter(), info, 0);
        emitSleepingBagQuads(context.getEmitter(), color);
        emitExtras(context.getEmitter(), stack.method_7909());
    }

    private void emitBaseQuads(QuadEmitter emitter) {
        bakedQuads.getBaseQuads().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
    }

    private void emitDyedBaseQuads(QuadEmitter emitter, int index) {
        bakedQuads.getDyedBaseQuads().forEach(quad -> {
            emitter.fromVanilla(quad, emitter.material(), null);

            // Center of rotation
            final float centerX = 0.5f;
            final float centerZ = 0.5f;

            // Rotation based on provided index
            float angleDegrees = index * 90f;
            float radians = (float)Math.toRadians(angleDegrees);
            float cos = (float)Math.cos(radians);
            float sin = (float)Math.sin(radians);

            for(int i = 0; i < 4; i++) {
                float x = emitter.x(i) - centerX;
                float y = emitter.y(i);
                float z = emitter.z(i) - centerZ;

                float newX = x * cos - z * sin;
                float newZ = x * sin + z * cos;

                emitter.pos(i, newX + centerX, y, newZ + centerZ);
            }

            emitter.emit();
        });
    }

    private void emitExtras(QuadEmitter emitter, class_1792 item) {
        if(item == ModItems.FOX_TRAVELERS_BACKPACK) {
            bakedQuads.getFoxNose().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
        if(item == ModItems.WOLF_TRAVELERS_BACKPACK) {
            bakedQuads.getWolfNose().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
        if(item == ModItems.WARDEN_TRAVELERS_BACKPACK) {
            bakedQuads.getWardenHorns().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
        if(item == ModItems.OCELOT_TRAVELERS_BACKPACK) {
            bakedQuads.getOcelotNose().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
        if(item == ModItems.PIG_TRAVELERS_BACKPACK || item == ModItems.HORSE_TRAVELERS_BACKPACK) {
            bakedQuads.getPigNose().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
        if(item == ModItems.VILLAGER_TRAVELERS_BACKPACK || item == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK) {
            bakedQuads.getVillagerNose().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        }
    }

    private void emitTanksQuads(QuadEmitter emitter, RenderInfo info, int index) {
        if(info == null || info.hasTanks()) {
            bakedQuads.getTanksQuads().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
            addFluids(emitter, info, index);
        }
    }

    private void emitSleepingBagQuads(QuadEmitter emitter, int color) {
        bakedQuads.getSleepingBagExtrasQuads().forEach(quad -> emitter.fromVanilla(quad, emitter.material(), null).emit());
        class_1058 sprite = class_310.method_1551().method_1549(class_1723.field_21668).apply(class_2960.method_60655(TravelersBackpack.MODID, "block/bag/" + class_1767.method_7791(color).method_7792().toLowerCase(Locale.ENGLISH) + "_sleeping_bag"));
        rebakeSleepingBag(emitter, sprite);
    }

    private void rebakeSleepingBag(QuadEmitter emitter, class_1058 sprite) {
        bakedQuads.getSleepingBagQuads().forEach(quad -> {
            class_1058 oldSprite = quad.method_35788();
            int[] oldData = quad.method_3357();
            int[] newData = Arrays.copyOf(oldData, oldData.length);

            for(int i = 0; i < 4; i++) {
                int index = i * 8;

                float oldU = Float.intBitsToFloat(oldData[index + 4]);
                float oldV = Float.intBitsToFloat(oldData[index + 5]);

                float uUn = oldSprite.method_35804(oldU);
                float vUn = oldSprite.method_35805(oldV);

                float newU = sprite.method_4580(uUn);
                float newV = sprite.method_4570(vUn);

                newData[index + 4] = Float.floatToRawIntBits(newU);
                newData[index + 5] = Float.floatToRawIntBits(newV);

                class_777 rebaked = new class_777(newData, quad.method_3359(), quad.method_3358(), sprite, quad.method_24874());
                emitter.fromVanilla(rebaked, emitter.material(), null).emit();
            }
        });
    }

    private void addFluids(QuadEmitter emitter, RenderInfo renderInfo, int index) {
        if(renderInfo != null && !renderInfo.isEmpty()) {
            if(!renderInfo.getLeftFluidStack().isEmpty()) {
                addFluid(emitter, renderInfo.getLeftFluidStack(), (float)renderInfo.getLeftFluidStack().getAmount() / renderInfo.getCapacity(), 1.8F / 16D, index);
            }
            if(!renderInfo.getRightFluidStack().isEmpty()) {
                addFluid(emitter, renderInfo.getRightFluidStack(), (float)renderInfo.getRightFluidStack().getAmount() / renderInfo.getCapacity(), 12.7F / 16D, index);
            }
        }
    }

    private void addFluid(QuadEmitter emitter, FluidVariantWrapper fluidStack, float ratio, double xMin, int index) {
        if(fluidStack.isEmpty() || class_3532.method_15347(ratio, 0.0f)) {
            return;
        }

        double yMin = 0.8 / 16d;
        double yMax = yMin + (ratio * 6.2) / 16d;
        class_238 bounds = new class_238(xMin, yMin, 6.3 / 16d, xMin + 1.5 / 16d, yMax, 7.8 / 16d);

        int color = FluidVariantRendering.getColor(fluidStack.fluidVariant()) | -16777216;
        class_1058 still = FluidVariantRendering.getSprite(fluidStack.fluidVariant());
        float bx1 = 0F;
        float bx2 = 3F;
        float by1 = 0F;
        float by2 = ratio * 12F;
        float bz1 = 0F;
        float bz2 = 3F;

        createQuad(List.of(getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index), getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index)), still, class_2350.field_11036, false, color, bx1, 4, bz1, 4, emitter);
        createQuad(List.of(getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index), getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321, index), getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321, index), getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index)), still, class_2350.field_11043, false, color, bx1, bx2, by1, by2, emitter);
        createQuad(List.of(getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index), getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index)), still, class_2350.field_11035, false, color, bx1, bx2, by1, by2, emitter);
        createQuad(List.of(getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index), getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321, index), getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324, index), getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index)), still, class_2350.field_11039, false, color, bz1, bz2, by1, by2, emitter);
        createQuad(List.of(getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321, index), getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index)), still, class_2350.field_11034, false, color, bz1, bz2, by1, by2, emitter);
    }

    private void addSleepingBag(QuadEmitter emitter, int color, int index) {
        float minX = 2.6F / 16;
        float minY = 0.8F / 16;
        float minZ = 8.9F / 16;
        float maxX = 13.5F / 16;
        float maxY = 2.4F / 16;
        float maxZ = 10.5F / 16;

        class_238 bounds = new class_238(minX, minY, minZ, maxX, maxY, maxZ);

        class_1058 sprite = class_310.method_1551().method_1549(class_1723.field_21668).apply(class_2960.method_60655(TravelersBackpack.MODID, "block/bags/" + class_1767.method_7791(color).method_7792().toLowerCase(Locale.ENGLISH) + "_sleeping_bag"));
        createQuad(List.of(getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index), getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321, index), getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321, index), getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index)), sprite,
                class_2350.field_11043, true, 0xFFFFFFFF, 11.5F, 15.25F, 0.5F, 1F, emitter);
        createQuad(List.of(getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index), getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index)), sprite,
                class_2350.field_11035, true, 0xFFFFFFFF, 8.25F, 12.25F, 0.5F, 1F, emitter);
        createQuad(List.of(getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index), getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321, index), getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324, index), getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index)), sprite,
                class_2350.field_11039, true, 0xFFFFFFFF, 7.75F, 8.25F, 0.5F, 1F, emitter);
        createQuad(List.of(getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321, index), getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index)), sprite,
                class_2350.field_11034, true, 0xFFFFFFFF, 15.25F, 15.75F, 0.5F, 1F, emitter);
        createQuad(List.of(getVector(bounds.field_1323, bounds.field_1325, bounds.field_1321, index), getVector(bounds.field_1323, bounds.field_1325, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1325, bounds.field_1324, index), getVector(bounds.field_1320, bounds.field_1325, bounds.field_1321, index)), sprite,
                class_2350.field_11036, true, 0xFFFFFFFF, 12F, 8.25F, 0.5F, 0F, emitter);
        createQuad(List.of(getVector(bounds.field_1320, bounds.field_1322, bounds.field_1321, index), getVector(bounds.field_1320, bounds.field_1322, bounds.field_1324, index), getVector(bounds.field_1323, bounds.field_1322, bounds.field_1324, index), getVector(bounds.field_1323, bounds.field_1322, bounds.field_1321, index)), sprite,
                class_2350.field_11033, true, 0xFFFFFFFF, 15.25F, 11.5F, 0F, 0.5F, emitter);
    }

    private Vector3f getVector(double x, double y, double z, int index) {
        Vector3f ret = new Vector3f((float)x, (float)y, (float)z);
        rotate(ret, new Matrix4f().rotateY((float)Math.toRadians(-(index * 90))));
        return ret;
    }

    private void rotate(Vector3f posIn, Matrix4f transform) {
        Vector3f originIn = new Vector3f(0.5f, 0.5f, 0.5f);
        Vector4f vector4f = transform.transform(new Vector4f(posIn.x() - originIn.x(), posIn.y() - originIn.y(), posIn.z() - originIn.z(), 1.0F));
        posIn.set(vector4f.x() + originIn.x(), vector4f.y() + originIn.y(), vector4f.z() + originIn.z());
    }

    private void createQuad(List<Vector3f> vecs, class_1058 sprite, class_2350 face, boolean hasAmbientOcclusion, int color, float u1x, float u2x, float v1x, float v2x, QuadEmitter emitter) {
        class_2382 dirVec = face.method_10163();

        u1x = u1x / 16F;
        u2x = u2x / 16F;
        v1x = v1x / 16F;
        v2x = v2x / 16F;

        float u1 = sprite.method_4580(u1x);
        float u2 = sprite.method_4580(u2x);
        float v1 = sprite.method_4570(v1x);
        float v2 = sprite.method_4570(v2x);

        emitter.cullFace(face);
        emitter.nominalFace(face);
        emitter.spriteBake(sprite, 0); // 0 = no bake flags

        if(!hasAmbientOcclusion) {
            if(RendererAccess.INSTANCE.hasRenderer()) {
                emitter.material(RendererAccess.INSTANCE.getRenderer().materialFinder().ambientOcclusion(TriState.FALSE).find());
            }
        }

        emitter.pos(0, vecs.get(0));
        emitter.color(0, color);
        emitter.uv(0, u1, v1);
        emitter.normal(0, dirVec.method_10263(), dirVec.method_10264(), dirVec.method_10260());

        emitter.pos(1, vecs.get(1));
        emitter.color(1, color);
        emitter.uv(1, u1, v2);
        emitter.normal(1, dirVec.method_10263(), dirVec.method_10264(), dirVec.method_10260());

        emitter.pos(2, vecs.get(2));
        emitter.color(2, color);
        emitter.uv(2, u2, v2);
        emitter.normal(2, dirVec.method_10263(), dirVec.method_10264(), dirVec.method_10260());

        emitter.pos(3, vecs.get(3));
        emitter.color(3, color);
        emitter.uv(3, u2, v1);
        emitter.normal(3, dirVec.method_10263(), dirVec.method_10264(), dirVec.method_10260());

        emitter.emit();
    }

    @Override
    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
        return bakedQuads.getBaseQuads();
    }

    @Override
    public boolean method_4708() {
        return true;
    }

    @Override
    public boolean method_4712() {
        return false;
    }

    @Override
    public boolean method_24304() {
        return true;
    }

    @Override
    public boolean method_4713() {
        return false;
    }

    @Override
    public class_1058 method_4711() {
        return bakedQuads.getBackpackBakedModel().method_4711();
    }

    @Override
    public class_809 method_4709() {
        return ITEM_TRANSFORMS;
    }

    @Override
    public class_806 method_4710() {
        return this.bakedQuads.getBackpackBakedModel().method_4710();
    }

    private static class_809 createItemTransforms() {
        return new class_809(
                new class_804(
                        new Vector3f(60, -180, 0),
                        new Vector3f(0, 1.5f / 16f, 0.5f / 16f),
                        new Vector3f(0.7f, 0.7f, 0.7f)
                ),
                new class_804(
                        new Vector3f(60, -180, 0),
                        new Vector3f(0, 1.5f / 16f, 0.5f / 16f),
                        new Vector3f(0.7f, 0.7f, 0.7f)
                ),
                new class_804(
                        new Vector3f(0, -90, 12.5f),
                        new Vector3f(1.13f / 16f, 6f / 16f, 2f / 16f),
                        new Vector3f(0.68f, 0.68f, 0.68f)
                ),
                new class_804(
                        new Vector3f(0, -90, 12.5f),
                        new Vector3f(1.13f / 16f, 6f / 16f, 2f / 16f),
                        new Vector3f(0.68f, 0.68f, 0.68f)
                ),
                new class_804(
                        new Vector3f(0, 180, 0),
                        new Vector3f(0, 14.5f / 16f, 0),
                        new Vector3f(1, 1, 1)
                ),
                new class_804(
                        new Vector3f(30, -38, 0),
                        new Vector3f(-0.25f / 16f, 2.25f / 16f, 0),
                        new Vector3f(1, 1, 1)
                ),
                new class_804(
                        new Vector3f(0, 0, 0),
                        new Vector3f(0, 2f / 16f, 0),
                        new Vector3f(0.5f, 0.5f, 0.5f)
                ),
                new class_804(
                        new Vector3f(0, 180, 0),
                        new Vector3f(0, 2.25f / 16f, 0),
                        new Vector3f(1, 1, 1)
                )
        );
    }
}