package com.tiviacz.travelersbackpack.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_811;

public class StackModelPart extends BackpackModelPart {
    public List<class_1799> prepare(class_1799 stack) {
        if(stack.method_57826(ModDataComponents.TOOLS_CONTAINER)) {
            return new ArrayList<>(stack.method_57824(ModDataComponents.TOOLS_CONTAINER).getItems()).stream().filter(itemStack -> !itemStack.method_7960()).toList();
        } else {
            return new ArrayList<>();
        }
    }

    public void render(class_1799 backpack, class_4597 buffer, class_4587 poseStack, int light, int overlay) {
        if(buffer == null) {
            return;
        }
        render(prepare(backpack), poseStack, buffer, light, overlay);
    }

    public void render(List<class_1799> tools, class_4587 poseStack, class_4597 buffer, int pPackedLight, int pPackedOverlay) {
        if(tools.isEmpty()) return;

        class_1799 toolUpper = tools.get(0);
        class_1799 toolLower = class_1799.field_8037;

        if(!toolUpper.method_7960() && tools.size() > 1) {
            toolLower = tools.get(tools.size() - 1);
        }

        poseStack.method_22903();

        if(!toolUpper.method_7960()) {
            class_1087 model = class_310.method_1551().method_1480().method_4019(toolUpper, null, null, 0);

            poseStack.method_22903();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA, 1, 0);

            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0F));

            poseStack.method_22904(0.04D, 0.075D, 0.17D);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(45F));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180F));
            poseStack.method_22905(0.50F, 0.50F, 0.50F);

            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture(0, class_1723.field_21668);
            class_310.method_1551().method_1480().method_23179(toolUpper, class_811.field_4315, false, poseStack, buffer, pPackedLight, pPackedOverlay, model);

            RenderSystem.disableBlend();
            poseStack.method_22909();
        }

        if(!toolLower.method_7960()) {
            class_1087 model = class_310.method_1551().method_1480().method_4019(toolLower, null, null, 0);

            poseStack.method_22903();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA, 1, 0);

            poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0F));

            poseStack.method_22904(-0.25, 0.75, -0.025);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(90F));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(45F));
            poseStack.method_22905(0.50F, 0.50F, 0.50F);

            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture(0, class_1723.field_21668);
            class_310.method_1551().method_1480().method_23179(toolLower, class_811.field_4315, false, poseStack, buffer, pPackedLight, pPackedOverlay, model);

            RenderSystem.disableBlend();
            poseStack.method_22909();
        }

        poseStack.method_22909();
    }
}