package com.tiviacz.travelersbackpack.client.screens;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.buttons.*;
import com.tiviacz.travelersbackpack.client.screens.widgets.*;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.ContainerSorter;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.item.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.item.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import com.tiviacz.travelersbackpack.util.Reference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_746;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Environment(EnvType.CLIENT)
public class BackpackScreen extends AbstractBackpackScreen<BackpackBaseMenu> implements class_3936<BackpackBaseMenu> {
    public boolean tanksVisible;
    public List<UpgradeSlot> upgradeSlots = new ArrayList<>();
    public List<IButton> buttons = new ArrayList<>();
    public SortingButtons sortingButtons;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    public int warningTicks = 0;

    public BackpackScreen(BackpackBaseMenu backpackMenu, class_1661 inventory, class_2561 component) {
        super(backpackMenu, inventory, backpackMenu.getWrapper().getBackpackScreenTitle());
        //Init getting called internally
        recalculate();

        //Update position
        updateBackpackSlotsPosition();
        updatePlayerSlotsPosition();

        this.field_25267 = 8 + (tanksVisible ? 22 : 0);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        initButtons();
        initWidgets();
    }

    @Override
    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);

        //Reload screen
        updateScreen(true);
        method_17577().updateSlots();

        //Update position
        updateBackpackSlotsPosition();
        updatePlayerSlotsPosition();
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        if(this.warningTicks > 0) {
            this.warningTicks--;
        }
    }

    public void recalculate() {
        this.method_37067();
        upgradeSlots.clear();

        this.slotCount = getWrapper().getStorage().getSlots();
        this.visibleSlots = this.slotCount;
        this.slotsHeight = calculateSlotHeight(slotCount > 81);
        this.tanksVisible = getWrapper().tanksVisible();

        this.field_2776 = 0;
        this.field_2800 = 0;

        boolean wideTexture = slotCount > 81;
        this.wider = wideTexture;
        this.visibleRows = (int)Math.ceil((double)this.slotCount / getSlotsInRow());
        int playerInventoryHeight = 96;
        this.field_2792 = wideTexture ? (tanksVisible ? 256 : 212) : (tanksVisible ? 220 : 176);
        this.field_2779 = TOP_BAR_OFFSET + this.slotsHeight + playerInventoryHeight;

        updateDimensions();

        this.field_25270 = 3 + TOP_BAR_OFFSET + (this.visibleRows * 18);
        this.field_25269 = 8;
        this.field_25267 = 8 + (tanksVisible ? 22 : 0);
        this.field_25268 = 6;

        if(tanksVisible) {
            this.field_25269 += 22;
        }

        if(wideTexture) {
            this.field_25269 += 18;
        }

        //Cache first slot Y pos, ignore if not visible
        if(field_2797.method_7611(0).field_7872 >= 0) {
            this.slotYPos = field_2797.method_7611(0).field_7872;
        }
    }

    public int getMiddleBar() {
        return TOP_BAR_OFFSET + calculateSlotHeight(this.visibleRows) + 1;
    }

    public int getWidthAdditions() {
        int addition = 0;
        if(tanksVisible) addition += 22;
        if(wider) addition += 18;
        return addition;
    }

    public void updateScreen(boolean duplicatedCall) {
        this.isScrollable = false;
        recalculate();
        method_25426();

        //Update position
        if(!duplicatedCall) {
            updateBackpackSlotsPosition();
            updatePlayerSlotsPosition();
        }
    }

    @Override
    public void renderScreen(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {

        //Render widgets below inventory
        renderUpgradeSlots(guiGraphics, x, y);

        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));

        boolean wideTexture = slotCount > 81;
        int inventoryXOffset = tanksVisible ? 22 : 0;
        renderInventoryBackground(guiGraphics, x + inventoryXOffset, y, wideTexture ? BACKGROUND_11 : BACKGROUND_9, field_2792, this.slotsHeight);

        int slotsXOffset = 7;

        if(tanksVisible) {
            slotsXOffset = 29;

            int halfTankHeight = this.slotsHeight / 2;
            int tanksHeight = 90;
            int uOffset = 56;
            int posOffset = 193;
            if(wideTexture) {
                uOffset = 0;
                posOffset = 229;
            }

            //Left Tank
            guiGraphics.method_25302(TANKS, x, y, 0, 0, 27, TOP_BAR_OFFSET - 9 + halfTankHeight);
            guiGraphics.method_25302(TANKS, x, y + TOP_BAR_OFFSET - 9 + halfTankHeight, uOffset, 256 - (tanksHeight + halfTankHeight + TOP_BAR_OFFSET), 27, tanksHeight + halfTankHeight + TOP_BAR_OFFSET - 9);

            //Right Tank
            guiGraphics.method_25302(TANKS, x + posOffset, y, uOffset + 28, 0, 27, TOP_BAR_OFFSET - 9 + halfTankHeight);
            guiGraphics.method_25302(TANKS, x + posOffset, y + TOP_BAR_OFFSET - 9 + halfTankHeight, uOffset + 28, 256 - (tanksHeight + halfTankHeight + TOP_BAR_OFFSET), 27, tanksHeight + halfTankHeight + TOP_BAR_OFFSET - 9);
        }

        //Render Upgrades
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));

        renderSlots(guiGraphics, x + slotsXOffset, y + TOP_BAR_OFFSET, this.slotCount);
        renderLockedBackpackSlot(guiGraphics);
    }

    public void renderUpgradeSlots(class_332 guiGraphics, int x, int y) {
        for(UpgradeSlot slot : upgradeSlots) {
            slot.render(guiGraphics, x, y);
        }
    }

    public void initializeUpgradeSlots() {
        for(int i = 0; i < getWrapper().getUpgrades().getSlots(); i++) {
            int x = field_2797.upgradeSlot.get(i).field_7873 - 4;
            int y = field_2797.upgradeSlot.get(i).field_7872 - 4;
            upgradeSlots.add(new UpgradeSlot(getWrapper(), new Point(getGuiLeft() + x, getGuiTop() + y), i, x, y, field_2797.upgradeSlot.get(i).isHidden));
        }
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4), false);
        method_37063(this.settingsWidget);

        int xPos = field_2776 + (wider ? 36 : 0) + (tanksVisible ? 22 : 0) + 120;
        this.sortingButtons = new SortingButtons(this, new Point(xPos, field_2800 - 10 + 12), 50, 13);
        method_37063(this.sortingButtons);

        int xPosTools = (wider ? 36 : 0) + (tanksVisible ? 22 : 0);
        this.toolSlotsWidget = new ToolSlotsWidget(this, new Point(this.field_2776 + xPosTools + 110, field_2800 - 10 + 15), xPosTools);
        method_37063(this.toolSlotsWidget);

        UpgradeManager manager = getWrapper().getUpgradeManager();

        for(int i : manager.mappedUpgrades.keySet()) {
            Optional<UpgradeBase<?>> upgrade = manager.mappedUpgrades.get(i);
            upgrade.ifPresent(loadedUpgrade -> {
                int x = field_2797.upgradeSlot.get(i).field_7873 - 4;
                int y = field_2797.upgradeSlot.get(i).field_7872 - 4;

                method_37063(loadedUpgrade.createWidget(this, x, y));
            });
        }

        initializeUpgradeSlots();

        if(this.isScrollable) {
            int scrollXPos = field_2776 + 7 + (tanksVisible ? 22 : 0); //leftPos + (wider ? 27 : 9) + (tanksVisible ? 22 : (wider ? 0 : 18));
            this.scroll = new InventoryScroll(this, class_310.method_1551(), 4, this.visibleRows * 18, field_2800 + TOP_BAR_OFFSET, scrollXPos + getSlotsInRow() * 18);
            if(this.scrollAmount != 0) {
                this.scroll.setScrollDistance(this.scrollAmount);
            }
            method_37063(this.scroll);
        }
    }

    public void initButtons() {
        buttons.clear();
        int xOffset = 0;
        if(getWrapper().getScreenID() == Reference.ITEM_SCREEN_ID) {
            if(!TravelersBackpack.enableIntegration()) {
                buttons.add(new EquipButton(this, getWrapper().getBackpackSlotIndex() == getScreenPlayer().method_31548().field_7545));
                xOffset += 12;
            }
        }
        if(getWrapper().getScreenID() == Reference.WEARABLE_SCREEN_ID && getWrapper().isOwner(method_17577().player)) {
            buttons.add(new MoreButton(this));

            if(!TravelersBackpack.enableIntegration()) {
                buttons.add(new UnequipButton(this));
                xOffset += 12;
            }

            if(TravelersBackpackConfig.getConfig().backpackSettings.quickSleepingBag) {
                buttons.add(new SleepingBagButton(this, true, xOffset));
                xOffset += 12;
            }

            if(BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, getWrapper().getBackpackStack())) {
                buttons.add(new AbilitySliderButton(this, false, xOffset));
            }
        }
        if(getWrapper().getScreenID() == Reference.BLOCK_ENTITY_SCREEN_ID) {
            buttons.add(new MoreButton(this));
            buttons.add(new SleepingBagButton(this, false, 0));

            if(BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, getWrapper().getBackpackStack())) {
                buttons.add(new AbilitySliderButton(this, true, 12));
            }
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);

        this.buttons.forEach(button -> {
            if(getWrapper().showMoreButtons() || button instanceof MoreButton || button instanceof EquipButton) {
                button.render(guiGraphics, mouseX, mouseY, partialTicks);
            }
        });

        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        this.buttons.forEach(button -> {
            if(getWrapper().showMoreButtons() || button instanceof MoreButton || button instanceof EquipButton) {
                button.renderTooltip(guiGraphics, mouseX, mouseY);
            }
        });
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));

        renderFluidWarningTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void drawUnsortableSlots(class_332 guiGraphics) {
        if(!getWrapper().getUnsortableSlots().isEmpty()) {
            getWrapper().getUnsortableSlots().forEach(i -> guiGraphics.method_25302(ICONS, this.getGuiLeft() + method_17577().method_7611(i).field_7873, this.getGuiTop() + method_17577().method_7611(i).field_7872, 25, 55, 16, 16));
        }
    }

    @Override
    public void drawMemorySlots(class_332 guiGraphics) {
        if(!getWrapper().getMemorySlots().isEmpty()) {
            getWrapper().getMemorySlots().forEach(pair -> {
                if(method_17577().method_7611(pair.getFirst()).method_7677().method_7960()) {
                    class_1799 itemstack = pair.getSecond().getFirst();
                    guiGraphics.method_51445(itemstack, this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872);
                    guiGraphics.method_51739(class_1921.method_51787(), this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872, this.getGuiLeft() + method_17577().method_7611(pair.getFirst()).field_7873 + 16, this.getGuiTop() + method_17577().method_7611(pair.getFirst()).field_7872 + 16, 822083583);
                }
            });
        }
    }

    @Override
    protected boolean method_2381(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if(!this.field_2797.method_34255().method_7960()) {
            for(class_364 widget : method_25396()) {
                if(widget instanceof WidgetBase base) {
                    if(base.method_25405(pMouseX, pMouseY)) return false;
                }
            }
        }
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.field_2792) || pMouseY >= (double)(pGuiTop + this.field_2779);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.buttons.forEach(b -> {
            if(getWrapper().showMoreButtons() || b instanceof MoreButton || b instanceof EquipButton) {
                b.mouseClicked(mouseX, mouseY, button);
            }
        });
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if(method_19355(mouseX, mouseY).isPresent()) {
            class_364 child = method_19355(mouseX, mouseY).get();
            if(child instanceof FilterUpgradeWidgetBase<?, ?> widget) {
                if(widget.getUpgrade().isTagSelector()) {
                    if(widget.method_25401(mouseX, mouseY, scrollX, scrollY)) {
                        return true;
                    }
                }
            }
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if(KeybindHandler.SORT_BACKPACK.method_1417(pKeyCode, pScanCode)) {
            ServerboundActionTagPacket.create(ServerboundActionTagPacket.SORTER, ContainerSorter.SORT_BACKPACK, KeyHelper.isShiftPressed());
            playUIClickSound();
            return true;
        }
        if(KeybindHandler.OPEN_BACKPACK.method_1417(pKeyCode, pScanCode)) {
            class_746 playerEntity = this.field_22787.field_1724;
            if(playerEntity != null && (field_2787 == null || !(field_2787.method_7677().method_7909() instanceof TravelersBackpackItem))) {
                this.method_25419();
            }
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public static void displayTanksUpgradeWarning(class_1657 player) {
        if(player.method_37908().field_9236) {
            if(class_310.method_1551().field_1755 instanceof BackpackScreen screen) {
                screen.warningTicks = 60;
            }
        }
    }

    //Fabric

    public void renderFluidWarningTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if(warningTicks > 0) {
            if(!(field_2797.method_34255().method_7909() instanceof TanksUpgradeItem)) {
                warningTicks = 0;
            }

            List<class_2561> tooltip = new ArrayList<>();
            tooltip.add(class_2561.method_43471("screen.travelersbackpack.cant_apply_upgrade"));
            tooltip.add(class_2561.method_43471("screen.travelersbackpack.too_much_fluid"));
            FluidVariantWrapper leftFluidStack = TanksUpgradeItem.getLeftFluidStack(field_2797.method_34255());
            FluidVariantWrapper rightFluidStack = TanksUpgradeItem.getRightFluidStack(field_2797.method_34255());

            if(!leftFluidStack.isEmpty() && leftFluidStack.getAmount() > getWrapper().getBackpackTankCapacity()) {
                tooltip.add(createFluidWarning(leftFluidStack, getWrapper().getBackpackTankCapacity()));
            }

            if(!rightFluidStack.isEmpty() && rightFluidStack.getAmount() > getWrapper().getBackpackTankCapacity()) {
                tooltip.add(createFluidWarning(rightFluidStack, getWrapper().getBackpackTankCapacity()));
            }
            guiGraphics.method_51437(getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public class_2561 createFluidWarning(FluidVariantWrapper fluidVariantWrapper, long backpackCapacity) {
        return class_2561.method_43470(FluidTypeHelper.getFluidVariantName(fluidVariantWrapper.fluidVariant()).getString() + " " + fluidVariantWrapper.amount() + "/" + backpackCapacity + "mB").method_27692(class_124.field_1061);
    }
}