package com.tiviacz.travelersbackpack.client.screens.tooltip;

import com.tiviacz.travelersbackpack.inventory.CommonFluid;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.KeyHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5684;
import org.joml.Matrix4f;

@Environment(EnvType.CLIENT)
public class ClientBackpackTooltipComponent implements class_5684 {
    private final BackpackTooltipComponent component;

    public ClientBackpackTooltipComponent(BackpackTooltipComponent component) {
        this.component = component;
    }

    public boolean show() {
        return KeyHelper.isCtrlPressed() || component.isHoveredWithItem();
    }

    @Override
    public int method_32661() {
        int height = 0;

        if(show()) {
            if(!component.leftFluidStack.isEmpty()) {
                height += 10;
            }

            if(!component.rightFluidStack.isEmpty()) {
                height += 10;
            }

            if(!component.upgrades.isEmpty()) {
                height += 10; //Text
                height += 18;
            }

            if(!component.storage.isEmpty()) {
                height += 10; //Text
                height += (int)(Math.ceil((float)component.storage.size() / 9) * 18);
            }

            if(!component.tools.isEmpty()) {
                height += 10; //Text
                height += 18;
            }
        }
        return height;
    }

    @Override
    public int method_32664(class_327 font) {
        int width = 0;

        if(show()) {
            if(!component.storage.isEmpty()) {
                width += Math.min(component.storage.size(), 9) * 18 + Math.min(component.storage.size(), 9) * 2;
            }
        }
        return width;
    }

    @Override
    public void method_32665(class_327 pFont, int pMouseX, int pMouseY, Matrix4f pMatrix, class_4597.class_4598 pBufferSource) {
        if(show()) {
            int yOffset = 0;

            if(!component.leftFluidStack.isEmpty()) {
                renderFluidTankTooltip(component.leftFluidStack, pFont, pMouseX, pMouseY, pMatrix, pBufferSource);
                yOffset += 10;
            }

            if(!component.rightFluidStack.isEmpty()) {
                renderFluidTankTooltip(component.rightFluidStack, pFont, pMouseX, pMouseY + yOffset, pMatrix, pBufferSource);
                yOffset += 10;
            }

            if(!component.upgrades.isEmpty()) {
                pFont.method_30882(class_2561.method_43471("screen.travelersbackpack.upgrades"), (float)pMouseX, (float)pMouseY + yOffset, class_124.field_1054.method_532(), true, pMatrix, pBufferSource, class_327.class_6415.field_33993, 0, 15728880);
                yOffset += 10;
                yOffset += 18;
            }

            if(!component.storage.isEmpty()) {
                pFont.method_30882(class_2561.method_43471("screen.travelersbackpack.inventory"), (float)pMouseX, (float)pMouseY + yOffset, class_124.field_1054.method_532(), true, pMatrix, pBufferSource, class_327.class_6415.field_33993, 0, 15728880);
                yOffset += 10;
                yOffset += (int)(Math.ceil((float)component.storage.size() / 9) * 18);
            }

            if(!component.tools.isEmpty()) {
                pFont.method_30882(class_2561.method_43471("screen.travelersbackpack.tools"), (float)pMouseX, (float)pMouseY + yOffset, class_124.field_1054.method_532(), true, pMatrix, pBufferSource, class_327.class_6415.field_33993, 0, 15728880);
                yOffset += 10;
                yOffset += 18;
            }
        }
    }

    @Override
    public void method_32666(class_327 pFont, int pX, int pY, class_332 pGuiGraphics) {
        int yOffset = 0;

        if(show()) {
            if(!component.leftFluidStack.isEmpty()) {
                yOffset += 10;
            }

            if(!component.rightFluidStack.isEmpty()) {
                yOffset += 10;
            }

            boolean flag = false;

            if(!component.upgrades.isEmpty()) {
                yOffset += 10; //text
                flag = true;

                for(int i = 0; i < component.upgrades.size(); i++) {
                    renderItem(component.upgrades.get(i), pX + (i * 18), pY + yOffset, pFont, pGuiGraphics);
                }
            }

            if(!component.storage.isEmpty()) {
                yOffset += 10; //Text
                int j = 0;
                if(flag) yOffset += 18;
                flag = true;
                boolean nextRow = false;

                for(int i = 0; i < component.storage.size(); i++) {
                    if(nextRow) {
                        yOffset += 18;
                        nextRow = false;
                    }
                    renderItem(component.storage.get(i), pX + j * 2 + j * 18, pY + yOffset, pFont, pGuiGraphics);

                    if(j < 8) {
                        j++;
                    } else {
                        j = 0;
                        nextRow = true;
                    }
                }
            }

            if(!component.tools.isEmpty()) {
                yOffset += 10; //Text
                if(flag) yOffset += 18;

                for(int i = 0; i < component.tools.size(); i++) {
                    renderItem(component.tools.get(i), pX + (i * 18), pY + yOffset, pFont, pGuiGraphics);
                }
            }
        }
    }

    private void renderItem(class_1799 stack, int pX, int pY, class_327 pFont, class_332 guiGraphics) {
        guiGraphics.method_51445(stack, pX, pY);
        guiGraphics.method_51431(pFont, stack, pX, pY);
    }

    //Fabric

    public void renderFluidTankTooltip(FluidVariantWrapper fluidStack, class_327 font, int mouseX, int mouseY, Matrix4f matrix, class_4597 bufferSource) {
        class_2561 c = CommonFluid.getFluidName(fluidStack);
        class_2561 c1 = class_2561.method_43470(": ");
        class_2561 c2 = class_2561.method_43470(fluidStack.getAmount() + "mB");

        font.method_30882(c, (float)mouseX, (float)mouseY, -1, true, matrix, bufferSource, class_327.class_6415.field_33993, 0, 15728880);
        font.method_30882(c1, (float)mouseX + font.method_27525(c), (float)mouseY, -1, true, matrix, bufferSource, class_327.class_6415.field_33993, 0, 15728880);
        font.method_30882(c2, (float)mouseX + font.method_27525(c) + font.method_27525(c1), (float)mouseY, 5592575, true, matrix, bufferSource, class_327.class_6415.field_33993, 0, 15728880);
    }
}