package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.AbstractBackpackScreen;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class InventoryScroll extends ScrollPanel {
    public final AbstractBackpackScreen<?> screen;

    public InventoryScroll(AbstractBackpackScreen<?> screen, class_310 client, int width, int height, int top, int left) {
        super(client, width, height, top, left, 0);
        this.screen = screen;
    }

    @Override
    protected int getScrollAmount() {
        return 18;
    }

    @Override
    protected int getContentHeight() {
        return this.screen.getRows() * 18;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean ret = super.method_25401(mouseX, mouseY, scrollX, scrollY);
        screen.setScrollAmount((int)scrollDistance / 18); //.scrollAmount = (int)scrollDistance / 18;
        screen.updateBackpackSlotsPosition();
        return ret;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean ret = super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        screen.setScrollAmount((int)scrollDistance / 18); // = (int)scrollDistance / 18;
        screen.updateBackpackSlotsPosition();
        return ret;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if(method_25405(mouseX, mouseY)) {
            return super.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    protected void drawPanel(class_332 guiGraphics, int entryRight, int relativeY, class_289 tess, int mouseX, int mouseY) {
    }

    @Override
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    @Override
    public void method_37020(class_6382 narrationElementOutput) {

    }

    public void setScrollDistance(int amount) {
        this.scrollDistance = (float)amount * 18;
    }
}
