package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.client.screens.AbstractBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.Reference;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class SettingsWidget extends WidgetBase<AbstractBackpackScreen<?>> {
    private final Point tabUvOpen;
    private final Point tabUvReturn;
    private final boolean isSettingsScreen;

    public SettingsWidget(AbstractBackpackScreen<?> screen, Point pos, boolean isSettingsScreen) {
        super(screen, pos, 24, 24);
        this.tabUvOpen = new Point(42, 0);
        this.tabUvReturn = new Point(42, 18);
        this.isSettingsScreen = isSettingsScreen;
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        guiGraphics.method_25302(BackpackScreen.ICONS, pos.x(), pos.y(), emptyTabUv.x(), emptyTabUv.y(), width, height);
        if(this.isSettingsScreen) {
            guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() + 3, pos.y() + 3, tabUvReturn.x(), tabUvReturn.y(), iconSize.x(), iconSize.y());
        } else {
            guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() + 3, pos.y() + 3, tabUvOpen.x(), tabUvOpen.y(), iconSize.x(), iconSize.y());
        }
    }

    public int getSettingsUser() {
        if(this.screen.getWrapper().getScreenID() == Reference.BLOCK_ENTITY_SCREEN_ID) {
            class_2338 pos = this.screen.getWrapper().getBackpackPos();
            if(pos != null) {
                return ((BackpackBlockEntity)this.screen.getScreenPlayer().method_37908().method_8321(pos)).getSettingsUser();
            }
        }
        return -1;
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if(method_25405(mouseX, mouseY)) {
            if(this.isSettingsScreen) {
                guiGraphics.method_51438(screen.getFont(), class_2561.method_43471("screen.travelersbackpack.settings_back"), mouseX, mouseY);
            } else {
                if(this.screen.getWrapper().getScreenID() != Reference.BLOCK_ENTITY_SCREEN_ID) {
                    if(!this.screen.getWrapper().isOwner(this.screen.getScreenPlayer())) {
                        guiGraphics.method_51438(screen.getFont(), class_2561.method_43471("screen.travelersbackpack.settings_owner"), mouseX, mouseY);
                        return;
                    }
                } else if(getSettingsUser() != -1) {
                    guiGraphics.method_51438(screen.getFont(), class_2561.method_43471("screen.travelersbackpack.settings_other_player"), mouseX, mouseY);
                    return;
                }
                guiGraphics.method_51438(screen.getFont(), class_2561.method_43471("screen.travelersbackpack.settings"), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if(this.screen.getWrapper().getScreenID() != Reference.BLOCK_ENTITY_SCREEN_ID && !this.screen.getWrapper().isOwner(this.screen.getScreenPlayer())) {
            return false;
        }

        if(this.screen.getWrapper().getScreenID() == Reference.BLOCK_ENTITY_SCREEN_ID && (getSettingsUser() != -1 && !this.isSettingsScreen)) {
            return false;
        }

        if(method_25405(pMouseX, pMouseY)) {
            if(this.isSettingsScreen) {
                //Save Data if changed
                this.screen.sendDataToServer();
                //Open Normal backpack here
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.OPEN_SETTINGS, this.screen.getScreenPlayer().method_5628(), false);
            } else {
                //Open settings menu here
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.OPEN_SETTINGS, this.screen.getScreenPlayer().method_5628(), true);
            }
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }
}