package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilter;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilterSlots;
import com.tiviacz.travelersbackpack.item.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class UpgradeWidgetBase<U extends UpgradeBase> extends WidgetBase<BackpackScreen> {
    private final WidgetElement removeElement;
    private final WidgetElement enableElement;
    protected U upgrade;
    protected int dataHolderSlot;
    protected final Point tabUv;
    private final String upgradeIconTooltip;

    public UpgradeWidgetBase(BackpackScreen screen, U upgrade, Point pos, Point tabUv, String upgradeIconTooltip) {
        super(screen, pos, 24, 24);
        this.upgrade = upgrade;
        this.dataHolderSlot = upgrade.getDataHolderSlot();
        this.tabUv = tabUv;
        this.upgradeIconTooltip = upgradeIconTooltip;

        this.width = upgrade.getTabSize().x();
        this.height = upgrade.getTabSize().y();

        this.removeElement = new WidgetElement(new Point(this.upgrade.getTabSize().x() - 3 - 18, 3), new Point(18, 18));
        this.enableElement = new WidgetElement(new Point(this.upgrade.getTabSize().x(), 6), new Point(4, 13));
    }

    public U getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        if(isTabOpened()) {
            if(upgrade instanceof IFilterSlots filter) {
                int sizeX = width;
                int sizeY = height;
                boolean requiresWider = false;

                int splitY = sizeY / 2;
                int remY = sizeY - splitY;

                int tabUvWidth = 66;
                int tabUvHeight = 103;

                //Upper
                if(width > tabUvWidth) {
                    requiresWider = true;
                }

                if(requiresWider) {
                    int splitX = sizeX / 2;
                    int remX = sizeX - splitX;

                    //Upper
                    guiGraphics.method_25302(BackpackScreen.TABS, pos.x(), pos.y(), tabUv.x(), tabUv.y(), splitX, splitY); //Left
                    guiGraphics.method_25302(BackpackScreen.TABS, pos.x() + splitX, pos.y(), tabUv.x() + tabUvWidth - remX, tabUv.y(), remX, splitY);//Right

                    //Lower
                    guiGraphics.method_25302(BackpackScreen.TABS, pos.x(), pos.y() + splitY, tabUv.x(), tabUv.y() + tabUvHeight - remY, splitX, remY);
                    guiGraphics.method_25302(BackpackScreen.TABS, pos.x() + splitX, pos.y() + splitY, tabUv.x() + tabUvWidth - remX, tabUv.y() + tabUvHeight - remY, remX, remY);
                } else {
                    //Upper
                    guiGraphics.method_25302(BackpackScreen.TABS, pos.x(), pos.y(), tabUv.x(), tabUv.y(), width, splitY);
                    //Lower
                    guiGraphics.method_25302(BackpackScreen.TABS, pos.x(), pos.y() + splitY, tabUv.x(), tabUv.y() + tabUvHeight - remY, width, remY);
                }

                int slotOffset = hasButtons() ? 43 : 22;

                for(int i = 0; i < filter.getRows(); i++) {
                    for(int j = 0; j < filter.getSlotsInRow(i); j++) {
                        guiGraphics.method_25302(BackpackScreen.TABS, pos.x() + 6 + j * 18, pos.y() + slotOffset + i * 18, 233, 0, 18, 18);
                    }
                }
            } else {
                guiGraphics.method_25302(BackpackScreen.TABS, pos.x(), pos.y(), tabUv.x(), tabUv.y(), width, height);
            }
            guiGraphics.method_51427(screen.getWrapper().getUpgrades().getStackInSlot(this.dataHolderSlot), pos.x() + 4, pos.y() + 4);
        }
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        renderEnableButton(guiGraphics, mouseX, mouseY, partialTicks);

        if(isBackpackOwner()) {
            renderRemoveButton(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if(isMouseOverIcon(mouseX, mouseY)) {
            List<class_2561> tooltips = new ArrayList<>();
            tooltips.add(class_2561.method_43471(this.upgradeIconTooltip));
            if(getUpgrade().getUpgradeManager().getWrapper().getScreenID() != Reference.WEARABLE_SCREEN_ID && this.upgrade.getDataHolderStack().method_7909() instanceof UpgradeItem upgradeItem && upgradeItem.requiresEquippedBackpack()) {
                tooltips.add(class_2561.method_43471("screen.travelersbackpack.equip_to_use"));
            }
            guiGraphics.method_51437(screen.getFont(), tooltips, Optional.empty(), mouseX, mouseY);
        }

        renderEnableButtonTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if(enableButtonMouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if(removeButtonMouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if(isMouseOverIcon(pMouseX, pMouseY)) {
            if(this.upgrade.isTabOpened()) {
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.UPGRADE_TAB, this.dataHolderSlot, false, ServerActions.TAB_OPEN);
            } else {
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.UPGRADE_TAB, this.dataHolderSlot, true, ServerActions.TAB_OPEN);
            }
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25405(double pMouseX, double pMouseY) {
        return pMouseX > pos.x() + 3 && pMouseY > pos.y() && pMouseX < pos.x() + upgrade.getTabSize().x() && pMouseY < pos.y() + upgrade.getTabSize().y();
    }

    public boolean isMouseOverRemoveButton(double mouseX, double mouseY) {
        return isWithinBounds(mouseX, mouseY, this.removeElement);
    }

    public boolean isMouseOverEnableButton(double mouseX, double mouseY) {
        return isWithinBounds(mouseX, mouseY, this.enableElement);
    }

    public void renderMatchContentsSlotOverlay(class_332 guiGraphics, List<Integer> filter, int settingType, int settingValue, int activeSlots) {
        if(isTabOpened()) {
            if(filter.get(settingType) == settingValue) {
                for(int i = 0; i < 3; i++) {
                    for(int j = 0; j < 3; j++) {
                        if(j + i * 3 < activeSlots) {
                            guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() + 6 + 18 * j, pos.y() + 43 + 18 * i, 24, 36, 18, 18);
                        }
                    }
                }
            }
        }
    }

    public void renderRemoveButton(class_332 guiGraphics, double mouseX, double mouseY) {
        if(isTabOpened()) {
            guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() + this.removeElement.pos().x(), pos.y() + this.removeElement.pos().y(), 42, 36, this.removeElement.size().x(), this.removeElement.size().y());
        }
    }

    public boolean removeButtonMouseClicked(double pMouseX, double pMouseY, int pButton) {
        if(this.upgrade.isTabOpened()) {
            if(isMouseOverRemoveButton(pMouseX, pMouseY)) {
                if(!isBackpackOwner()) {
                    return false;
                }
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.REMOVE_UPGRADE, this.dataHolderSlot);
                this.screen.playUIClickSound();
                return true;
            }
        }
        return false;
    }

    public void renderEnableButton(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if(this.upgrade instanceof IEnable e && !this.upgrade.isTabOpened()) {
            if(e.isEnabled(this.upgrade)) {
                guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() + this.enableElement.pos().x(), pos.y() + this.enableElement.pos().y(), 18, 24, this.enableElement.size().x(), this.enableElement.size().y());
                if(isMouseOverEnableButton(mouseX, mouseY)) {
                    guiGraphics.method_51740(class_1921.method_51785(), pos.x() + this.enableElement.pos().x(), pos.y() + this.enableElement.pos().y() + 7, pos.x() + this.enableElement.pos().x() + 3, pos.y() + this.enableElement.pos().y() + 12, -2130706433, -2130706433, 0);
                }
            } else {
                guiGraphics.method_25302(BackpackScreen.ICONS, pos.x() + this.enableElement.pos().x(), pos.y() + this.enableElement.pos().y(), 18, 37, this.enableElement.size().x(), this.enableElement.size().y());
                if(isMouseOverEnableButton(mouseX, mouseY)) {
                    guiGraphics.method_51740(class_1921.method_51785(), pos.x() + this.enableElement.pos().x(), pos.y() + this.enableElement.pos().y() + 1, pos.x() + this.enableElement.pos().x() + 3, pos.y() + this.enableElement.pos().y() + 6, -2130706433, -2130706433, 0);
                }
            }
        }
    }

    public void renderEnableButtonTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        if(this.upgrade instanceof IEnable e && !this.upgrade.isTabOpened()) {
            if(isMouseOverEnableButton(mouseX, mouseY)) {
                if(e.isEnabled(this.upgrade)) {
                    guiGraphics.method_51438(screen.getFont(), class_2561.method_43470("Disable Upgrade"), mouseX, mouseY);
                } else {
                    guiGraphics.method_51438(screen.getFont(), class_2561.method_43470("Enable Upgrade"), mouseX, mouseY);
                }
            }
        }
    }

    public boolean enableButtonMouseClicked(double pMouseX, double pMouseY, int pButton) {
        if(this.upgrade instanceof IEnable e && !this.upgrade.isTabOpened()) {
            if(isMouseOverEnableButton(pMouseX, pMouseY)) {
                if(!isBackpackOwner()) {
                    return false;
                }
                ServerboundActionTagPacket.create(ServerboundActionTagPacket.UPGRADE_TAB, this.dataHolderSlot, !e.isEnabled(this.upgrade), ServerActions.UPGRADE_ENABLED);
                this.screen.playUIClickSound();
                return true;
            }
        }
        return false;
    }

    public boolean hasButtons() {
        return upgrade instanceof IFilter;
    }

    public boolean isBackpackOwner() {
        return screen.getWrapper().isOwner(screen.method_17577().player);
    }

    public boolean isTabOpened() {
        return this.upgrade.isTabOpened();
    }

    @Override
    public int[] getWidgetSizeAndPos() {
        int[] size = new int[4];
        size[0] = pos.x();
        size[1] = pos.y();
        size[2] = width + (this.upgrade instanceof IEnable && !isTabOpened() ? 4 : 0);
        size[3] = height;
        return size;
    }
}