package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.util.Reference;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class AccessCommand {
    public AccessCommand(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        LiteralArgumentBuilder<class_2168> tbCommand = class_2170.method_9247("tb").requires(player -> player.method_9259(2));

        tbCommand.then(class_2170.method_9247("access")
                .then(class_2170.method_9244("pos", class_2262.method_9698())
                        .executes(source -> openTargetBlockEntity(source.getSource(), class_2262.method_9696(source, "pos"))))
                .then(class_2170.method_9244("target", class_2186.method_9308())
                        .executes(source -> openTargetInventory(source.getSource(), class_2186.method_9315(source, "target")))));

        dispatcher.register(tbCommand);
    }

    public int openTargetBlockEntity(class_2168 source, class_2338 blockPos) throws CommandSyntaxException {
        if(source.method_9225().method_8321(blockPos) instanceof BackpackBlockEntity backpackBlockEntity) {
            backpackBlockEntity.openBackpackFromCommand(source.method_9207(), backpackBlockEntity, blockPos);
            source.method_9226(() -> class_2561.method_43470("Accessing backpack of " + blockPos.method_23854()), true);
            return 1;
        } else {
            source.method_9213(class_2561.method_43470("There's no backpack at coordinates " + blockPos.method_23854()));
            return -1;
        }
    }

    public int openTargetInventory(class_2168 source, class_3222 target) throws CommandSyntaxException {
        class_3222 self = source.method_9207();
        boolean hasBackpack = ComponentUtils.isWearingBackpack(target);
        class_1799 stack = ComponentUtils.getWearingBackpack(target);

        if(hasBackpack) {
            BackpackContainer.openAnotherPlayerBackpack(self, target, stack, Reference.WEARABLE_SCREEN_ID);
            source.method_9226(() -> class_2561.method_43470("Accessing backpack of " + target.method_5476().getString()), true);
            return 1;
        } else {
            source.method_9213(class_2561.method_43470("Can't access backpack"));
            return -1;
        }
    }
}