package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class BackpackIconCommands {
    public BackpackIconCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandBuildContext) {
        dispatcher.register(ClientCommandManager.literal("tb_client")
                .then(ClientCommandManager.literal("hide").executes(source -> hideIcon(source.getSource())))
                .then(ClientCommandManager.literal("show").executes(source -> showIcon())));
    }

    public int hideIcon(FabricClientCommandSource source) {
        TravelersBackpackConfig.getConfig().client.showBackpackIconInInventory = false;
        TravelersBackpackConfig.saveConfig();
        source.sendFeedback(class_2561.method_43471("screen.travelersbackpack.hidden_icon_info"));
        return 1;
    }

    public int showIcon() {
        TravelersBackpackConfig.getConfig().client.showBackpackIconInInventory = true;
        TravelersBackpackConfig.saveConfig();
        return 1;
    }
}
