package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class RestoreCommand {
    private static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER = (context, builder) -> {
        File backpacksFolder = BackpackManager.getBackpackFolder(context.getSource().method_9225());
        if(backpacksFolder.listFiles() == null) return Suggestions.empty();

        List<String> backpackEntries = new ArrayList<>();

        for(File file : backpacksFolder.listFiles((dir, name) -> name.matches("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$"))) {
            if(file.listFiles() == null) continue;

            backpackEntries.addAll(Arrays.stream(file.listFiles()).collect(ArrayList::new, (list, backpack) -> list.add(backpack.getName()), List::addAll));
        }
        return class_2172.method_9264(backpackEntries.stream(), builder);
    };

    public RestoreCommand(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        LiteralArgumentBuilder<class_2168> tbCommand = class_2170.method_9247("tb").requires(player -> player.method_9259(2));

        tbCommand.then(class_2170.method_9247("restore")
                .then(class_2170.method_9244("target", class_2186.method_9305())
                        .then(class_2170.method_9244("backpack_id", StringArgumentType.string()).suggests(SUGGESTION_PROVIDER)
                                .executes(source -> restoreBackpack(source.getSource(), StringArgumentType.getString(source, "backpack_id"), class_2186.method_9315(source, "target"))))));

        dispatcher.register(tbCommand);
    }

    public int restoreBackpack(class_2168 source, String backpackID, class_3222 player) {
        class_1799 backpack = BackpackManager.getBackpack(player.method_51469(), backpackID);
        if(backpack == null) {
            source.method_9213(class_2561.method_43470("Backpack with ID " + backpackID + " not found"));
            return 0;
        }
        if(!player.method_31548().method_7394(backpack)) {
            player.method_7328(backpack, false);
        }
        source.method_9226(() -> class_2561.method_43470("Successfully restored " + player.method_5476().getString() + "'s backpack"), true);
        return 1;
    }
}